/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.tbs;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.PerformanceHotspotProvider;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.PerformanceHotspotTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterSpec;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfInvocations;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.resource.InvocationDist;
import com.sap.jvm.profiling.snapshot.resource.MptSpecName;
import com.sap.jvm.profiling.snapshot.tbs.Elements;
import com.sap.jvm.profiling.snapshot.tbs.MethodParameterStatistic;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class MethodParameterStatisticProvider
extends PerformanceHotspotTableProvider<MethodParameterStatistic> {
    public MethodParameterStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Method Parameters"), "views/method_parameter_statistic.gif", ProviderUtils.getSelfAndTotalSpec(name, I18n._ss((String)"Entity, ex: total time {0} was running", (String)"this method"), false, false, SumBehavior.SUM_SELF).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of method invocations"), 2, NrOfInvocations.class, "nr_method_invocations").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Parameter Definition"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The name of the parameter definition"), 73, NormalParameterSpec.class, "method_parameter_definition"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalParameterSpec(((MptSpecName)((MethodParameterStatistic)this.statistic).getKey(entryId)).getName());
        }
        if (column == 1) {
            return NrOfInvocations.PROTOTYPE.create(((InvocationDist)((MethodParameterStatistic)this.statistic).getOther(entryId)).getTotalInvocations());
        }
        return ProviderUtils.getEntry(entryId, column - 2, (SelfAndTotalValueStatistic)this.statistic, (PerformanceHotspotProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((MethodParameterStatistic)this.statistic).getKeyColumn();
        }
        if (columnIndex == 1) {
            return ((MethodParameterStatistic)this.statistic).getOtherColumn();
        }
        return ProviderUtils.getColumn((SelfAndTotalValueStatistic)this.statistic, columnIndex - 2);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateMethodParameterStatistic());
    }
}

