/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.tbs;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.PerformanceHotspotProvider;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.PerformanceHotspotValueSetProvider;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.filter.FilterParseException;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.tbs.Elements;
import com.sap.jvm.profiling.snapshot.tbs.MethodTypeStatistic;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.tracing.Trace;

public class NativeVsNonNativeProvider
extends PerformanceHotspotValueSetProvider<MethodTypeStatistic, MethodFilter> {
    private MethodFilter[] filters;

    public NativeVsNonNativeProvider(ResourceName name) {
        super(ProviderUtils.getSampleSpec(name, I18n._ss((String)"Entity, ex: ... affected by {0}, ... time spent in {0}", (String)"methods")), I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Native Vs. Non-Native"), "profiling/native_vs_nonnative.gif", name);
    }

    @Override
    protected ResourceName getStatisticName() {
        ResourceName baseName = this.getResourceName().stripLastElement();
        ProfilingSession session = baseName.getSession();
        try {
            this.filters = new MethodFilter[]{new MethodFilter(session, "native", "is_native"), new MethodFilter(session, "non-native", "!is_native")};
            return baseName.addElement((ResourceNameElement)new Elements.CreateMethodTypeStatistic(this.filters));
        }
        catch (FilterParseException e) {
            Trace.error((Throwable)e, (String)"Could not create method filter");
            return null;
        }
    }

    @Override
    public int getNrOfRows() {
        return ((MethodTypeStatistic)this.statistic).size();
    }

    @Override
    public String getRowColorTag(int row) {
        return (new String[]{"performance.graph.native", "performance.graph.non-native"})[row];
    }

    @Override
    public String getRowName(int row) {
        return (new String[]{I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Non Native")})[row];
    }

    @Override
    public String getRowToolTip(int row) {
        return (new String[]{I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in non-native methods")})[row];
    }

    @Override
    public MethodFilter getRowType(int row) {
        return this.filters[row];
    }

    @Override
    public Quantity getEntry(int row, int column) {
        assert (row == 0 || row == 1);
        int orderedRow = row;
        if (((MethodTypeStatistic)this.statistic).getKey(0) != this.getRowType(0)) {
            orderedRow = 1 - row;
        }
        return (Quantity)ProviderUtils.getEntry(orderedRow, column, (ValueStatistic)this.statistic, (PerformanceHotspotProvider)this);
    }
}

