/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.tbs;

import com.sap.jvm.profiling.presentation.impl.typed.StatisticBasedTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.PerformanceHotspotProvider;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.tbs.PerformanceHotspotSnapshot;
import com.sap.jvm.profiling.snapshot.util.Statistic;

public abstract class PerformanceHotspotTableProvider<T extends Statistic<?>>
extends StatisticBasedTableProvider<T>
implements PerformanceHotspotProvider {
    private final long totalTime;
    private final PerformanceHotspotSnapshot snapshot;

    protected PerformanceHotspotTableProvider(ResourceName name, String title, String iconKey, TypedColumnSpec columnSpec) {
        super(name, title, iconKey, columnSpec);
        this.snapshot = (PerformanceHotspotSnapshot)SnapshotResourceManagerFactory.get(name.getSession()).getExplicitSnapshot(name);
        this.totalTime = this.snapshot.getSleepingTime() + Math.max(this.snapshot.getRunningTime(), this.snapshot.getCpuTime());
    }

    @Override
    public PerformanceHotspotSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public long getSnapshotCpuTime() {
        return this.snapshot.getCpuTime();
    }

    @Override
    public long getSnapshotRunningTime() {
        return this.snapshot.getRunningTime();
    }

    @Override
    public long getSnapshotSleepingTime() {
        return this.snapshot.getSleepingTime();
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }
}

