/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.tbs;

import com.sap.jvm.profiling.presentation.impl.typed.tbs.PerformanceHotspotProvider;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedValueSetProvider;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.tbs.PerformanceHotspotSnapshot;

public abstract class PerformanceHotspotValueSetProvider<T, R>
extends TypedValueSetProvider<T, R>
implements PerformanceHotspotProvider {
    private final long totalTime;
    private final PerformanceHotspotSnapshot snapshot;

    protected PerformanceHotspotValueSetProvider(TypedColumnSpec columnSpec, String title, String iconKey, ResourceName name) {
        super(columnSpec, title, iconKey, name);
        this.snapshot = (PerformanceHotspotSnapshot)SnapshotResourceManagerFactory.get(name.getSession()).getExplicitSnapshot(name);
        this.totalTime = this.snapshot.getSleepingTime() + Math.max(this.snapshot.getRunningTime(), this.snapshot.getCpuTime());
    }

    @Override
    public PerformanceHotspotSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public long getSnapshotCpuTime() {
        return this.snapshot.getCpuTime();
    }

    @Override
    public long getSnapshotRunningTime() {
        return this.snapshot.getRunningTime();
    }

    @Override
    public long getSnapshotSleepingTime() {
        return this.snapshot.getSleepingTime();
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }
}

