/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.tbs;

import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.PerformanceHotspotProvider;
import com.sap.jvm.profiling.presentation.typed.SortOrder;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.BasicTimeDistributionEntry;
import com.sap.jvm.profiling.presentation.typed.entries.DetailedTimeDistributionEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.tbs.PerformanceHotspotSnapshot;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDistColumn;
import com.sap.jvm.profiling.snapshot.tbs.TimeDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeDistColumn;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.ValueTreeBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;

public class ProviderUtils {
    private static LongValueColumn getColumn(TimeAndDistColumn column, int columnIndex) {
        if (columnIndex == 0) {
            return column.getTimeColumn();
        }
        if (columnIndex == 1) {
            return column.getCpuTimeColumn();
        }
        if (columnIndex == 2) {
            return column.getSleepingTimeColumn();
        }
        if (columnIndex < 15) {
            return ProviderUtils.getColumn(column.getTimeDistributionColumn(), columnIndex - 3);
        }
        return ProviderUtils.getColumn(column.getCpuTimeDistributionColumn(), columnIndex - 15);
    }

    private static LongValueColumn getColumn(TimeDistColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getInterpreterTimeColumn();
            }
            case 1: {
                return column.getNativeInterpreterTimeColumn();
            }
            case 2: {
                return column.getCompiledTimeColumn();
            }
            case 3: {
                return column.getNativeCompiledTimeColumn();
            }
            case 4: {
                return column.getInlinedTimeColumn();
            }
            case 5: {
                return column.getNativeInlinedTimeColumn();
            }
            case 6: {
                return column.getCompiledTier1TimeColumn();
            }
            case 7: {
                return column.getNativeCompiledTier1TimeColumn();
            }
            case 8: {
                return column.getInlinedTier1TimeColumn();
            }
            case 9: {
                return column.getNativeInlinedTier1TimeColumn();
            }
            case 10: 
            case 11: {
                return null;
            }
        }
        assert (false);
        return null;
    }

    private static ProviderEntry getEntry(TimeDist dist, int column, long totalRunningTime, long displayedRunningTime) {
        switch (column) {
            case 0: {
                return ElapsedTime.PROTOTYPE.create(dist.getInterpreterTime(), totalRunningTime, displayedRunningTime);
            }
            case 1: {
                return ElapsedTime.PROTOTYPE.create(dist.getNativeInterpreterTime(), totalRunningTime, displayedRunningTime);
            }
            case 2: {
                return ElapsedTime.PROTOTYPE.create(dist.getCompiledTime(), totalRunningTime, displayedRunningTime);
            }
            case 3: {
                return ElapsedTime.PROTOTYPE.create(dist.getNativeCompiledTime(), totalRunningTime, displayedRunningTime);
            }
            case 4: {
                return ElapsedTime.PROTOTYPE.create(dist.getInlinedTime(), totalRunningTime, displayedRunningTime);
            }
            case 5: {
                return ElapsedTime.PROTOTYPE.create(dist.getNativeInlinedTime(), totalRunningTime, displayedRunningTime);
            }
            case 6: {
                return ElapsedTime.PROTOTYPE.create(dist.getCompiledTier1Time(), totalRunningTime, displayedRunningTime);
            }
            case 7: {
                return ElapsedTime.PROTOTYPE.create(dist.getNativeCompiledTier1Time(), totalRunningTime, displayedRunningTime);
            }
            case 8: {
                return ElapsedTime.PROTOTYPE.create(dist.getInlinedTier1Time(), totalRunningTime, displayedRunningTime);
            }
            case 9: {
                return ElapsedTime.PROTOTYPE.create(dist.getNativeInlinedTier1Time(), totalRunningTime, displayedRunningTime);
            }
            case 10: {
                return new BasicTimeDistributionEntry(dist);
            }
            case 11: {
                return new DetailedTimeDistributionEntry(dist);
            }
        }
        assert (false);
        return null;
    }

    private static ProviderEntry getEntry(TimeAndDist time, int column, TimeAndDist total, PerformanceHotspotProvider provider) {
        if (column == 0) {
            long displayedRunning = total.getTime();
            long totalRunningTime = Math.max(displayedRunning, provider.getSnapshotRunningTime());
            return ElapsedTime.PROTOTYPE.create(time.getTime(), totalRunningTime, displayedRunning);
        }
        if (column == 1) {
            long displayedCpu = total.getCpuTime();
            long totalCpuTime = Math.max(displayedCpu, provider.getSnapshotCpuTime());
            return ElapsedTime.PROTOTYPE.create(time.getCpuTime(), totalCpuTime, displayedCpu);
        }
        if (column == 2) {
            long displayedSleeping = total.getSleepingTime();
            long totalSleepingTime = Math.max(displayedSleeping, provider.getSnapshotSleepingTime());
            return ElapsedTime.PROTOTYPE.create(time.getSleepingTime(), totalSleepingTime, displayedSleeping);
        }
        if (column < 15) {
            long displayedRunning = total.getTime();
            long totalRunningTime = Math.max(displayedRunning, provider.getSnapshotRunningTime());
            return ProviderUtils.getEntry(time.getTimeDistribution(), column - 3, totalRunningTime, displayedRunning);
        }
        long displayedCpu = total.getCpuTime();
        long totalCpuTime = Math.max(displayedCpu, provider.getSnapshotCpuTime());
        return ProviderUtils.getEntry(time.getCpuTimeDistribution(), column - 15, totalCpuTime, displayedCpu);
    }

    public static LongValueColumn getColumn(ValueStatistic<?, TimeAndDist> statistic, int column) {
        return ProviderUtils.getColumn((TimeAndDistColumn)statistic.getValueColumn(), column);
    }

    public static ProviderEntry getEntry(int id, int column, ValueStatistic<?, TimeAndDist> statistic, PerformanceHotspotProvider provider) {
        return ProviderUtils.getEntry(statistic.getValue(id), column, statistic.getValue(), provider);
    }

    public static LongValueColumn getColumn(SelfAndTotalValueStatistic<?, TimeAndDist> statistic, int column) {
        if ((column & 1) == 0) {
            return ProviderUtils.getColumn((TimeAndDistColumn)statistic.getSelfColumn(), column / 2);
        }
        return ProviderUtils.getColumn((TimeAndDistColumn)statistic.getTotalColumn(), column / 2);
    }

    public static ProviderEntry getEntry(int id, int column, SelfAndTotalValueStatistic<?, TimeAndDist> statistic, PerformanceHotspotProvider provider) {
        if ((column & 1) == 0) {
            return ProviderUtils.getEntry(statistic.getSelf(id), column / 2, statistic.getTotal(), provider);
        }
        return ProviderUtils.getEntry(statistic.getTotal(id), column / 2, statistic.getTotal(), provider);
    }

    public static ProviderEntry getEntry(SelfAndTotalValueTreeNode<?, TimeAndDist> node, int column, ValueTreeBase<?, TimeAndDist, ?> tree, PerformanceHotspotProvider provider) {
        if ((column & 1) == 0) {
            return ProviderUtils.getEntry(node.getSelf(), column / 2, tree.getTotal(), provider);
        }
        return ProviderUtils.getEntry(node.getTotal(), column / 2, tree.getTotal(), provider);
    }

    public static TypedColumnSpec getSimpleSampleSpec(ResourceName name, String entity) {
        TypedColumnSpec spec = new TypedColumnSpec("RunningTime");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time (Runnable)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time consumed by {0}", (Object[])new Object[]{entity}), 12550, ElapsedTime.class, "elapsed_time_runnable_nanoseconds", new VisibilitySet("RunnableTime", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable"), "tables/col_running_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Runnable time"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by {0}", (Object[])new Object[]{entity}), 12294, ElapsedTime.class, "cpu_time_nanoseconds", new VisibilitySet("CPUTime", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time"), "tables/col_cpu_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"CPU time"), new Integer[0]));
        return ProviderUtils.disableUnneededColumns(name, spec, new SortOrder(0), new SortOrder(1));
    }

    public static TypedColumnSpec getSampleSpec(ResourceName name, String entity) {
        VisibilitySet runningTime = new VisibilitySet("RunningTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Running"), "tables/col_running_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running (and not sleeping)"), new Integer[0]);
        VisibilitySet sleepingTime = new VisibilitySet("SleepingTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Sleeping"), "tables/col_sleepingl_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time sleeping"), new Integer[0]);
        VisibilitySet interpreted = new VisibilitySet("InterpreterTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Interpreted"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running non-native methods interpreted"), new Integer[0]);
        VisibilitySet nativeInterpreted = new VisibilitySet("NativeInterpreterTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native Interpreted"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running native methods interpreted"), new Integer[0]);
        VisibilitySet compiled = new VisibilitySet("CompiledTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running non-native methods compiled, but not inlined"), new Integer[0]);
        VisibilitySet nativeCompiled = new VisibilitySet("NativeCompiledTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native Compiled"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running native methods compiled but not inlined"), new Integer[0]);
        VisibilitySet inlined = new VisibilitySet("InlinedTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running non-native method inlined"), new Integer[0]);
        VisibilitySet nativeInlined = new VisibilitySet("NativeInlinedTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native Inlined"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running native methods inlined"), new Integer[0]);
        VisibilitySet compTier1 = new VisibilitySet("CompiledTier1Time", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Tier 1"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running non-native methods compiled in tier 1, but not inlined"), new Integer[0]);
        VisibilitySet nativeCompTier1 = new VisibilitySet("NativeCompiledTier1Time", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native Compiled Tier 1"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running native methods compiled in tier 1 but not inlined"), new Integer[0]);
        VisibilitySet inlinedTier1 = new VisibilitySet("InlinedTier1Time", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Tier 1"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running non-native method inlined in tier 1"), new Integer[0]);
        VisibilitySet nativeInlinedTier1 = new VisibilitySet("NativeInlinedTier1Time", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native Inlined Tier 1"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running native methods inlined in tier 1"), new Integer[0]);
        VisibilitySet basicDist = new VisibilitySet("BasicDistribution", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Basic Distribution"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Basic distribution (interpreted, compiled, native)"), new Integer[0]);
        VisibilitySet detailedDist = new VisibilitySet("DetailedDistribution", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Detailed Distribution"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Detailed distribution"), new Integer[0]);
        VisibilitySet runnableTime = new VisibilitySet("RunnableTime", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable"), "tables/col_running_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Runnable time"), new Integer[0]);
        VisibilitySet cpuTime = new VisibilitySet("CPUTime", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time"), "tables/col_cpu_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"CPU time"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("RunningTime");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time (Runnable)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time consumed by {0}", (Object[])new Object[]{entity}), 12550, ElapsedTime.class, "elapsed_time_runnable_nanoseconds", runningTime, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by {0}", (Object[])new Object[]{entity}), 12294, ElapsedTime.class, "cpu_time_nanoseconds", runningTime, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time (Sleeping)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The sleeping time consumed by {0}", (Object[])new Object[]{entity}), 12294, ElapsedTime.class, "elapsed_time_sleeping_nanoseconds", sleepingTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable Time (Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time in the interpreter"), 12294, ElapsedTime.class, "time_runnable_interpreted_nanoseconds", interpreted, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable Time (Native Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time in the interpreter calling native code"), 12294, ElapsedTime.class, "time_runnable_native_interpreted_nanoseconds", nativeInterpreted, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable Time (Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time compiled but not inlined"), 12294, ElapsedTime.class, "time_runnable_compiled_nanoseconds", compiled, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable Time (Native Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time compiled but not inlined calling native code"), 12294, ElapsedTime.class, "time_runnable_native_compiled_nanoseconds", nativeCompiled, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable Time (Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time inlined"), 12294, ElapsedTime.class, "time_runnable_inlined_nanoseconds", inlined, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable Time (Native Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time inlined calling native code"), 12294, ElapsedTime.class, "time_runnable_native_inlined_nanoseconds", nativeInlined, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable Time (Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time compiled in tier 1 but not inlined"), 12294, ElapsedTime.class, "time_runnable_compiled_tier_1_nanoseconds", compTier1, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable Time (Native Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time compiled in tier 1 but not inlined calling native code"), 12294, ElapsedTime.class, "time_runnable_native_compiled_tier_1_nanoseconds", nativeCompTier1, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable Time (Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time inlined in tier 1"), 12294, ElapsedTime.class, "time_runnable_inlined_tier_1_nanoseconds", inlinedTier1, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable Time (Native Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The runnable time inlined in tier 1 calling native code"), 12294, ElapsedTime.class, "time_runnable_native_inlined_tier_1_nanoseconds", nativeInlinedTier1, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Basic Runnable Time Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The basic distribution of the runnable time"), 2, BasicTimeDistributionEntry.class, "basic_runnable_time_distribution_nanoseconds", basicDist, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Detailed Runnable Time Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The detailed distribution of the runnable time"), 2, DetailedTimeDistributionEntry.class, "detailed_runnable_time_distribution_nanoseconds", detailedDist, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time (Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time in the interpreter"), 12294, ElapsedTime.class, "cpu_time_interpreted_nanoseconds", interpreted, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time (Native Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time in the interpreter calling native code"), 12294, ElapsedTime.class, "cpu_time_native_interpreted_nanoseconds", nativeInterpreted, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time (Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time compiled but not inlined"), 12294, ElapsedTime.class, "cpu_time_compiled_nanoseconds", compiled, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time (Native Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time compiled but not inlined calling native code"), 12294, ElapsedTime.class, "cpu_time_native_compiled_nanoseconds", nativeCompiled, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time (Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time inlined"), 12294, ElapsedTime.class, "cpu_time_inlined_nanoseconds", inlined, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time (Native Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time inlined calling native code"), 12294, ElapsedTime.class, "cpu_time_native_inlined_nanoseconds", nativeInlined, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time (Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time compiled in tier 1 but not inlined"), 12294, ElapsedTime.class, "cpu_time_compiled_tier_1_nanoseconds", compTier1, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time (Native Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time compiled in tier 1 but not inlined calling native code"), 12294, ElapsedTime.class, "cpu_time_native_compiled_tier_1_nanoseconds", nativeCompTier1, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time (Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time inlined in tier 1"), 12294, ElapsedTime.class, "cpu_time_inlined_tier_1_nanoseconds", inlinedTier1, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time (Native Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time inlined in tier 1 calling native code"), 12294, ElapsedTime.class, "cpu_time_native_inlined_tier_1_nanoseconds", nativeInlinedTier1, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Basic CPU Time Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The basic distribution of the CPU time"), 12294, BasicTimeDistributionEntry.class, "basic_cpu_time_distribution_nanoseconds", basicDist, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Detailed CPU Time Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The detailed distribution of the CPU time"), 12294, DetailedTimeDistributionEntry.class, "detailed_cpu_time_distribution_nanoseconds", detailedDist, cpuTime);
        return ProviderUtils.disableUnneededColumns(name, spec, new SortOrder(0), new SortOrder(1));
    }

    public static TypedColumnSpec getSelfAndTotalSpec(ResourceName name, String entity, boolean pluralEntity, boolean sortBySelf, SumBehavior sumBehavior) {
        int sumSelf = 0xB000 | (sumBehavior.sumSelf() ? 4 : 0);
        int sumTotal = 0x3000 | (sumBehavior.sumTotal() ? 4 : 0);
        VisibilitySet runningTime = new VisibilitySet("RunningTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Running"), "tables/col_running_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running (and not sleeping)"), new Integer[0]);
        VisibilitySet sleepingTime = new VisibilitySet("SleepingTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Sleeping"), "tables/col_sleepingl_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time sleeping"), new Integer[0]);
        VisibilitySet interpreted = new VisibilitySet("InterpreterTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Interpreted"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running non-native methods interpreted"), new Integer[0]);
        VisibilitySet nativeInterpreted = new VisibilitySet("NativeInterpreterTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native Interpreted"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running native methods interpreted"), new Integer[0]);
        VisibilitySet compiled = new VisibilitySet("CompiledTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running non-native methods compiled, but not inlined"), new Integer[0]);
        VisibilitySet nativeCompiled = new VisibilitySet("NativeCompiledTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native Compiled"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running native methods compiled but not inlined"), new Integer[0]);
        VisibilitySet inlined = new VisibilitySet("InlinedTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running non-native method inlined"), new Integer[0]);
        VisibilitySet nativeInlined = new VisibilitySet("NativeInlinedTime", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native Inlined"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running native methods inlined"), new Integer[0]);
        VisibilitySet compTier1 = new VisibilitySet("CompiledTier1Time", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Tier 1"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running non-native methods compiled in tier 1, but not inlined"), new Integer[0]);
        VisibilitySet nativeCompTier1 = new VisibilitySet("NativeCompiledTier1Time", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native Compiled Tier 1"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running native methods compiled in tier 1 but not inlined"), new Integer[0]);
        VisibilitySet inlinedTier1 = new VisibilitySet("InlinedTier1Time", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Tier 1"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running non-native method inlined in tier 1"), new Integer[0]);
        VisibilitySet nativeInlinedTier1 = new VisibilitySet("NativeInlinedTier1Time", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native Inlined Tier 1"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time running native methods inlined in tier 1"), new Integer[0]);
        VisibilitySet basicDist = new VisibilitySet("BasicDistribution", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Basic Distribution"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Basic distribution (interpreted, compiled, native)"), new Integer[0]);
        VisibilitySet detailedDist = new VisibilitySet("DetailedDistribution", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Detailed Distribution"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Detailed distribution"), new Integer[0]);
        VisibilitySet self = new VisibilitySet("Self", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self"), "tables/col_self_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Self time"), new Integer[0]);
        VisibilitySet total = new VisibilitySet("Total", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total"), "tables/col_total_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total time"), new Integer[0]);
        VisibilitySet runnableTime = new VisibilitySet("RunnableTime", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Runnable"), "tables/col_running_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Runnable time"), new Integer[0]);
        VisibilitySet cpuTime = new VisibilitySet("CPUTime", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time"), "tables/col_cpu_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"CPU time"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("RunningTime|Self|Total");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Time (Runnable)"), I18n._ssn((String)"The runnable time {0} was top on stack", (String)"The runnable time {0} were top on stack", (int)(pluralEntity ? 100 : 1), (Object[])new Object[]{entity}), 2 | sumSelf | (sortBySelf ? 256 : 0), ElapsedTime.class, "self_elapsed_time_runnable_nanoseconds", runningTime, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Time (Runnable)"), I18n._ssn((String)"The runnable time {0} was on the stack", (String)"The runnable time {0} were on the stack", (int)(pluralEntity ? 100 : 1), (Object[])new Object[]{entity}), 2 | sumTotal | (sortBySelf ? 0 : 256), ElapsedTime.class, "total_elapsed_time_runnable_nanoseconds", runningTime, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self CPU Time"), I18n._ssn((String)"The CPU time {0} was top on stack", (String)"The CPU time {0} were top on stack", (int)(pluralEntity ? 100 : 1), (Object[])new Object[]{entity}), 2 | sumSelf, ElapsedTime.class, "self_cpu_time_nanoseconds", runningTime, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total CPU Time"), I18n._ssn((String)"The CPU time {0} was on the stack", (String)"The CPU time {0} were on the stack", (int)(pluralEntity ? 100 : 1), (Object[])new Object[]{entity}), 2 | sumTotal, ElapsedTime.class, "total_cpu_time_nanoseconds", runningTime, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Time (Sleeping)"), I18n._ssn((String)"The sleeping time {0} was top on stack", (String)"The sleeping time {0} were top on stack", (int)(pluralEntity ? 100 : 1), (Object[])new Object[]{entity}), 2 | sumSelf, ElapsedTime.class, "self_elapsed_time_sleeping_nanoseconds", sleepingTime, self, runnableTime, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Time (Sleeping)"), I18n._ssn((String)"The sleeping time {0} was on the stack", (String)"The sleeping time {0} were on the stack", (int)(pluralEntity ? 100 : 1), (Object[])new Object[]{entity}), 2 | sumTotal, ElapsedTime.class, "total_elapsed_time_sleeping_nanoseconds", sleepingTime, total, runnableTime, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Runnable Time (Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self runnable time in the interpreter"), 2 | sumSelf, ElapsedTime.class, "self_time_runnable_interpreted_nanoseconds", interpreted, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Runnable Time (Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total runnable time in the interpreter"), 2 | sumTotal, ElapsedTime.class, "total_time_runnable_interpreted_nanoseconds", interpreted, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Runnable Time (Native Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self runnable time in the interpreter calling native code"), 2 | sumSelf, ElapsedTime.class, "self_time_runnable_native_interpreted_nanoseconds", nativeInterpreted, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Runnable Time (Native Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total runnable time in the interpreter calling native code"), 2 | sumTotal, ElapsedTime.class, "total_time_runnable_native_interpreted_nanoseconds", nativeInterpreted, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Runnable Time (Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self runnable time compiled but not inlined"), 2 | sumSelf, ElapsedTime.class, "self_time_runnable_compiled_nanoseconds", compiled, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Runnable Time (Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total runnable time compiled but not inlined"), 2 | sumTotal, ElapsedTime.class, "total_time_runnable_compiled_nanoseconds", compiled, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Runnable Time (Native Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self runnable time compiled but not inlined calling native code"), 2 | sumSelf, ElapsedTime.class, "self_time_runnable_native_compiled_nanoseconds", nativeCompiled, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Runnable Time (Native Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total runnable time compiled but not inlined calling native code"), 2 | sumTotal, ElapsedTime.class, "total_time_runnable_native_compiled_nanoseconds", nativeCompiled, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Runnable Time (Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self runnable time inlined"), 2 | sumSelf, ElapsedTime.class, "self_time_runnable_inlined_nanoseconds", inlined, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Runnable Time (Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total runnable time inlined"), 2 | sumTotal, ElapsedTime.class, "total_time_runnable_inlined_nanoseconds", inlined, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Runnable Time (Native Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self runnable time inlined calling native code"), 2 | sumSelf, ElapsedTime.class, "self_time_runnable_native_inlined_nanoseconds", nativeInlined, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Runnable Time (Native Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total runnable time inlined calling native code"), 2 | sumTotal, ElapsedTime.class, "total_time_runnable_native_inlined_nanoseconds", nativeInlined, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Runnable Time (Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self runnable time compiled in tier 1 but not inlined"), 2 | sumSelf, ElapsedTime.class, "self_time_runnable_compiled_tier_1_nanoseconds", compTier1, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Runnable Time (Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total runnable time compiled in tier 1 but not inlined"), 2 | sumTotal, ElapsedTime.class, "total_time_runnable_compiled_tier_1_nanoseconds", compTier1, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Runnable Time (Native Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self runnable time compiled in tier 1 but not inlined calling native code"), 2 | sumSelf, ElapsedTime.class, "self_time_runnable_native_compiled_tier_1_nanoseconds", nativeCompTier1, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Runnable Time (Native Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total runnable time compiled in tier 1 but not inlined calling native code"), 2 | sumTotal, ElapsedTime.class, "total_time_runnable_native_compiled_tier_1_nanoseconds", nativeCompTier1, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Runnable Time (Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self runnable time inlined in tier 1"), 2 | sumSelf, ElapsedTime.class, "self_time_runnable_inlined_tier_1_nanoseconds", inlinedTier1, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Runnable Time (Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total runnable time inlined in tier 1"), 2 | sumTotal, ElapsedTime.class, "total_time_runnable_inlined_tier_1_nanoseconds", inlinedTier1, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Runnable Time (Native Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self runnable time inlined in tier 1 calling native code"), 2 | sumSelf, ElapsedTime.class, "self_time_runnable_native_inlined_tier_1_nanoseconds", nativeInlinedTier1, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Runnable Time (Native Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total runnable time inlined in tier 1 calling native code"), 2 | sumTotal, ElapsedTime.class, "total_time_runnable_native_inlined_tier_1_nanoseconds", nativeInlinedTier1, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Basic Self Runnable Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The basic self distribution of the runnable time"), 2, BasicTimeDistributionEntry.class, "basic_self_runnable_time_distribution_nanoseconds", basicDist, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Basic Total Runnable Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The basic total distribution of the runnable time"), 2, BasicTimeDistributionEntry.class, "basic_total_runnable_time_distribution_nanoseconds", basicDist, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Detailed Self Runnable Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The detailed self distribution of the runnable time"), 2, DetailedTimeDistributionEntry.class, "detailed_self_runnable_time_distribution_nanoseconds", detailedDist, self, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Detailed Total Runnable Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The detailed total distribution of the runnable time"), 2, DetailedTimeDistributionEntry.class, "detailed_total_runnable_time_distribution_nanoseconds", detailedDist, total, runnableTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self CPU Time (Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self CPU time in the interpreter"), 2 | sumSelf, ElapsedTime.class, "self_cpu_time_interpreted_nanoseconds", interpreted, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total CPU Time (Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total CPU time in the interpreter"), 2 | sumTotal, ElapsedTime.class, "total_cpu_time_interpreted_nanoseconds", interpreted, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self CPU Time (Native Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self CPU time in the interpreter calling native code"), 2 | sumSelf, ElapsedTime.class, "self_cpu_time_native_interpreted_nanoseconds", nativeInterpreted, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total CPU Time (Native Interpreted)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total CPU time in the interpreter calling native code"), 2 | sumTotal, ElapsedTime.class, "total_cpu_time_native_interpreted_nanoseconds", nativeInterpreted, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self CPU Time (Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self CPU time compiled but not inlined"), 2 | sumSelf, ElapsedTime.class, "self_cpu_time_compiled_nanoseconds", compiled, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total CPU Time (Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total CPU time compiled but not inlined"), 2 | sumTotal, ElapsedTime.class, "total_cpu_time_compiled_nanoseconds", compiled, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self CPU Time (Native Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self CPU time compiled but not inlined calling native code"), 2 | sumSelf, ElapsedTime.class, "self_cpu_time_native_compiled_nanoseconds", nativeCompiled, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total CPU Time (Native Compiled)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total CPU time compiled but not inlined calling native code"), 2 | sumTotal, ElapsedTime.class, "total_cpu_time_native_compiled_nanoseconds", nativeCompiled, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self CPU Time (Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self CPU time inlined"), 2 | sumSelf, ElapsedTime.class, "self_cpu_time_inlined_nanoseconds", inlined, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total CPU Time (Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total CPU time inlined"), 2 | sumTotal, ElapsedTime.class, "total_cpu_time_inlined_nanoseconds", inlined, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self CPU Time (Native Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self CPU time inlined calling native code"), 2 | sumSelf, ElapsedTime.class, "self_cpu_time_native_inlined_nanoseconds", nativeInlined, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total CPU Time (Native Inlined)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total CPU time inlined calling native code"), 2 | sumTotal, ElapsedTime.class, "total_cpu_time_native_inlined_nanoseconds", nativeInlined, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self CPU Time (Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self CPU time compiled in tier 1 but not inlined"), 2 | sumSelf, ElapsedTime.class, "self_cpu_time_compiled_tier_1_nanoseconds", compTier1, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total CPU Time (Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total CPU time compiled in tier 1 but not inlined"), 2 | sumTotal, ElapsedTime.class, "total_cpu_time_compiled_tier_1_nanoseconds", compTier1, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self CPU Time (Native Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self CPU time compiled in tier 1 but not inlined calling native code"), 2 | sumSelf, ElapsedTime.class, "self_cpu_time_native_compiled_tier_1_nanoseconds", nativeCompTier1, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total CPU Time (Native Compiled Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total CPU time compiled in tier 1 but not inlined calling native code"), 2 | sumTotal, ElapsedTime.class, "total_cpu_time_native_compiled_tier_1_nanoseconds", nativeCompTier1, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self CPU Time (Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self CPU time inlined in tier 1"), 2 | sumSelf, ElapsedTime.class, "self_cpu_time_inlined_tier_1_nanoseconds", inlinedTier1, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total CPU Time (Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total CPU time inlined in tier 1"), 2 | sumTotal, ElapsedTime.class, "total_cpu_time_inlined_tier_1_nanoseconds", inlinedTier1, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self CPU Time (Native Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The self CPU time inlined in tier 1 calling native code"), 2 | sumSelf, ElapsedTime.class, "self_cpu_time_native_inlined_tier_1_nanoseconds", nativeInlinedTier1, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total CPU Time (Native Inlined Tier 1)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total CPU time inlined in tier 1 calling native code"), 2 | sumTotal, ElapsedTime.class, "total_cpu_time_native_inlined_tier_1_nanoseconds", nativeInlinedTier1, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Basic Self CPU Time Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The basic self distribution of the CPU time"), 2, BasicTimeDistributionEntry.class, "basic_self_cpu_time_distribution_nanoseconds", basicDist, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Basic Total CPU Time Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The basic total distribution of the CPU time"), 2, BasicTimeDistributionEntry.class, "basic_total_cpu_time_distribution_nanoseconds", basicDist, total, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Detailed Self CPU Time Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The detailed self distribution of the CPU time"), 2, DetailedTimeDistributionEntry.class, "detailed_self_cpu_time_distribution_nanoseconds", detailedDist, self, cpuTime);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Detailed Total CPU Time Distribution"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The detailed total distribution of the CPU time"), 2, DetailedTimeDistributionEntry.class, "detailed_total_cpu_time_distribution_nanoseconds", detailedDist, total, cpuTime);
        return ProviderUtils.disableUnneededColumns(name, spec, new SortOrder(sortBySelf ? 0 : 1), new SortOrder(sortBySelf ? 2 : 3));
    }

    private static TypedColumnSpec disableUnneededColumns(ResourceName name, TypedColumnSpec spec, SortOrder runnable, SortOrder cpuTime) {
        PerformanceHotspotSnapshot snapshot = (PerformanceHotspotSnapshot)SnapshotResourceManagerFactory.get(name.getSession()).getExplicitSnapshot(name);
        ProfilingCapabilities capabilities = name.getSession().getCapabilities();
        boolean sleepingThreadSupport = capabilities.hasSleepingThreadSupportInTimeBasedSampling();
        boolean ignoreSleepingThreads = snapshot.getConfig().ignoreSleepingThreads() || !sleepingThreadSupport;
        boolean hasDistribution = capabilities.hasInterpreterInformationInTBS();
        boolean hasCpuTime = capabilities.getSystemInfo().tbsSupportsCpuTime();
        boolean hasTier1Info = name.getSession().getSystemInfo().tbsSupportsTierInformation();
        if (ignoreSleepingThreads) {
            spec.disableVisibilitySets("SleepingTime");
        }
        if (!hasDistribution) {
            spec.disableVisibilitySets("InterpreterTime|NativeInterpreterTime|CompiledTime|NativeCompiledTime|InlinedTime|NativeInlinedTime|BasicDistribution|DetailedDistribution");
        }
        if (!ignoreSleepingThreads) {
            spec.setDefaultVisibleSets(spec.getDefaultVisibleSets() + "|SleepingTime");
        }
        if (!hasCpuTime) {
            spec.disableVisibilitySets("CPUTime");
            spec.setDefaultVisibleSets(spec.getDefaultVisibleSets() + "|RunnableTime");
            spec.setDefaultSortOrder(runnable);
        } else {
            spec.setDefaultVisibleSets(spec.getDefaultVisibleSets() + "|CPUTime");
            spec.setDefaultSortOrder(cpuTime);
        }
        if (!hasTier1Info) {
            spec.disableVisibilitySets("CompiledTier1Time|NativeCompiledTier1Time|InlinedTier1Time|NativeInlinedTier1Time");
        }
        return spec;
    }
}

