/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.thread;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MonitorObjectUsage;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.BooleanType;
import com.sap.jvm.profiling.presentation.typed.entries.DeadlockCycleEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.MixedProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.MonitorObjectEntry;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassLoader;
import com.sap.jvm.profiling.presentation.typed.entries.NormalString;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadDumpAlertType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadDumpLink;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfInvocations;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjects;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOpenedFiles;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOpenedSockets;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfThreads;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.SocketObjectEntry;
import com.sap.jvm.profiling.presentation.typed.entries.StackFrameEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadDumpCPUGrowth;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadDumpNrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadDumpThreadStates;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadStatusEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Timestamp;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItem;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItemType;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpItem;

public class ProviderUtils {
    private static final int DYNAMIC_OFFSET = 10;

    public static TypedColumnSpec getThreadDumpsSpec() {
        TypedColumnSpec spec = new TypedColumnSpec("");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Thread Dump"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Name of the thread dump"), 257, NormalThreadDumpLink.class, "thread_dump_name", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Timestamp"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Timestamp the thread dump was triggered"), 1, Timestamp.class, "file_io", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"CPU time consumed since last thread dump"), 1, ThreadDumpCPUGrowth.class, "cpu_time_nanoseconds", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"File I/O"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of bytes read/written in file operations since the last thread dump"), 1, ThreadDumpNrOfBytes.class, "file_io", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Network I/O"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of bytes read/written in network operations since the last thread dump"), 1, ThreadDumpNrOfBytes.class, "file_io", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Threads"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of threads in the thread dump"), 1, NrOfThreads.class, "thread_count", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Thread States"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Distribution of thread states in the thread dump"), 1, ThreadDumpThreadStates.class, "file_io", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Deadlock"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates deadlocks"), 1, NormalThreadDumpAlertType.class, "thread_dump_name", new VisibilitySet[0]);
        return spec;
    }

    public static ProviderEntry getEntry(ThreadDumpSnapshot snp, int column, int idx) {
        assert (snp != null);
        switch (column) {
            case 0: {
                return new NormalThreadDumpLink(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Thread Dump {0}", (Object[])new Object[]{idx + 1}), idx);
            }
            case 1: {
                return new Timestamp(snp.getTimestampThreadDump(idx));
            }
            case 2: {
                return ThreadDumpCPUGrowth.PROTOTYPE.create(snp.getCPUTimeThreadDump(idx), snp.getTotalCPUTime(), true);
            }
            case 3: {
                return ThreadDumpNrOfBytes.PROTOTYPE.create(snp.getFileIOThreadDump(idx), snp.getTotalFileIO(), true);
            }
            case 4: {
                return ThreadDumpNrOfBytes.PROTOTYPE.create(snp.getSocketIOThreadDump(idx), snp.getTotalSocketIO(), true);
            }
            case 5: {
                return NrOfThreads.PROTOTYPE.create(snp.getNumThreadsInDump(idx));
            }
            case 6: {
                return new ThreadDumpThreadStates(snp.getNumOfRunningThreadsInDump(idx), snp.getNumOfWaitingThreadsInDump(idx), snp.getNumOfSleepingThreadsInDump(idx), snp.getNumOfBlockedThreadsInDump(idx), snp.getNumOfIOThreadsInDump(idx), snp.getMaxNumThreads());
            }
            case 7: {
                return new NormalThreadDumpAlertType(snp.isThreadDumpDeadlocked(idx) ? NormalThreadDumpAlertType.AlertType.DEADLOCK : NormalThreadDumpAlertType.AlertType.NONE);
            }
        }
        return null;
    }

    private static void appendCommonThreadDumpSpecColumns(TypedColumnSpec spec, boolean differences, boolean sortCPU) {
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Java Id"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The Java thread id"), 1, NormalThreadId.class, "thread_id", new VisibilitySet("JavaThreadId", "1-Basic", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Java Thread Id"), "decorators/id.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The Java thread id"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Kernel Id"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The kernel id of the thread"), 1, NormalThreadId.class, "thread_kernel_id", new VisibilitySet("NativeThreadId", "1-Basic", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Kernel Thread Id"), "decorators/id.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The native id of the thread"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Pthread Id"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The pthread id"), 1, NormalThreadId.class, "thread_pthread_id", new VisibilitySet("PthreadId", "1-Basic", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Pthread Id"), "decorators/id.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The Pthread id"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Thread Group"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Name of the thread group"), 2, NormalString.class, "thread_group_name", new VisibilitySet("Threadgroup", "1-Basic", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Thread Group"), "vm_monitor/process.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Name of the thread group"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Thread State"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The state of the thread"), 16386, ThreadStatusEntry.class, "thread_status", new VisibilitySet("ThreadState", "1-Basic", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Thread State"), "vm_monitor/process.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The state of the thread"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Daemon"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates daemon threads"), 16386, BooleanType.class, "thread_daemon", new VisibilitySet("DaemonThread", "1-Basic", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Daemon Thread"), "vm_monitor/process.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates daemon threads"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Priority"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The priority of the thread"), 16386, NormalString.class, "thread_priority", new VisibilitySet("Priority", "1-Basic", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Priority"), "vm_monitor/process.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The priority of the thread"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Deadlock"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates deadlocks by their cycle number"), 2, DeadlockCycleEntry.class, "deadlock_cycle_number", new VisibilitySet("DeadlockCycle", "1-Basic", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Deadlock"), "types/deadlock_cycle.png", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates deadlocks by their cycle number"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Classloader"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The current context classloader object"), 2, NormalClassLoader.class, "class_loader", new VisibilitySet("ContextClassloader", "1-Basic", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Context Classloader"), "types/class_loader.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The current context classloader object"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Top Method"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Method executed top on stack"), 2, StackFrameEntry.class, "method", new VisibilitySet("TopMethod", "1-Basic", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Top Method"), "types/method.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Method executed top on stack"), new Integer[0]));
        VisibilitySet difference = null;
        VisibilitySet absolute = null;
        if (differences) {
            difference = new VisibilitySet("Difference", "5-mode", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Difference"), "types/thread_running.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Difference"), new Integer[0]);
            absolute = new VisibilitySet("Absolute", "5-mode", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Absolute"), "vm_monitor/process.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Absolute"), new Integer[0]);
        }
        int sumFlag = 12294;
        VisibilitySet definedClasses = new VisibilitySet("DefinedClasses", "2-misc-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Defined Classes"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of defined classes"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Defined Classes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of defined classes"), 12294, NrOfObjects.class, "number_defined_classes", definedClasses, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Defined Classes (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Defined classes since last dump"), 12294, NrOfObjects.class, "number_defined_classes", definedClasses, difference);
        }
        VisibilitySet cpuTime = new VisibilitySet("CPUTime", "2-misc-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time"), "tables/col_cpu_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"CPU time consumed by thread"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"CPU time consumed by thread"), sortCPU ? 12550 : 12294, ElapsedTime.class, "total_cpu_time_nanoseconds", cpuTime, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"CPU time consumed since last dump"), 12294, ElapsedTime.class, "total_cpu_time_nanoseconds", cpuTime, difference);
        }
        VisibilitySet elapsedTime = new VisibilitySet("ElapsedTime", "2-misc-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Elapsed Time"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Elapsed time since thread started"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Elapsed Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Elapsed time since thread started"), 2, ElapsedTime.class, "elapsed_time_nanoseconds", elapsedTime, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Elapsed Time (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Elapsed time since last thread dump"), 2, ElapsedTime.class, "elapsed_time_nanoseconds", elapsedTime, difference);
        }
        VisibilitySet allocatedBytes = new VisibilitySet("AllocatedBytes", "2-misc-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Allocated Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes allocated by thread"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Allocated Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes allocated by thread"), 12294, NrOfBytes.class, "total_bytes", allocatedBytes, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Allocated Bytes (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes allocated by thread since last thread dump"), 12294, NrOfBytes.class, "total_bytes", allocatedBytes, difference);
        }
        VisibilitySet fileBytesRead = new VisibilitySet("FileBytesRead", "3-IO-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"File Bytes Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes read from files"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"File Bytes Read"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes read from files"), 12294, NrOfBytes.class, "read_bytes", fileBytesRead, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"File Bytes Read (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes read from files since last thread dump"), 12294, NrOfBytes.class, "read_bytes", fileBytesRead, difference);
        }
        VisibilitySet fileBytesWritten = new VisibilitySet("FileBytesWritten", "3-IO-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"File Bytes Written"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes written to files"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"File Bytes Written"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes written to files"), 12294, NrOfBytes.class, "written_bytes", fileBytesWritten, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"File Bytes Written (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes written to files since last thread dump"), 12294, NrOfBytes.class, "written_bytes", fileBytesWritten, difference);
        }
        VisibilitySet networkBytesRead = new VisibilitySet("NetworkBytesRead", "3-IO-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Network Bytes Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes read from network"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Network Bytes Read"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes read from network"), 12294, NrOfBytes.class, "read_bytes", networkBytesRead, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Network Bytes Read (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes read from network since last thread dumps"), 12294, NrOfBytes.class, "read_bytes", networkBytesRead, difference);
        }
        VisibilitySet networkBytesWritten = new VisibilitySet("NetworkBytesWritten", "3-IO-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Network Bytes Written"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes written to network"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Network Bytes Written"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes written to network"), 12294, NrOfBytes.class, "written_bytes", networkBytesWritten, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Network Bytes Written (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of bytes written to network since last thread dump"), 12294, NrOfBytes.class, "written_bytes", networkBytesWritten, difference);
        }
        VisibilitySet numFileOpen = new VisibilitySet("NumOpenFiles", "3-IO-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number Opened Files"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of opened files"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number Opened Files"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of opened files"), 12294, NrOfOpenedFiles.class, "nr_opened_files", numFileOpen, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number Opened Files (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of opened files since last thread dump"), 12294, NrOfOpenedFiles.class, "nr_opened_files", numFileOpen, difference);
        }
        VisibilitySet numOpenSockets = new VisibilitySet("NumOpenSockets", "3-IO-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number Opened Sockets"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of opened sockets"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number Opened Sockets"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of opened sockets"), 12294, NrOfOpenedSockets.class, "nr_opened_sockets", numOpenSockets, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number Opened Sockets (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of opened sockets since last thread dump"), 12294, NrOfOpenedSockets.class, "nr_opened_sockets", numOpenSockets, difference);
        }
        VisibilitySet numMonitorEnter = new VisibilitySet("NumContentedMonitorEnter", "4-Monitor-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Num Monitor Enter"), "tables/col_blocking_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of contented monitors to enter"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Num Monitor Enter"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of contented monitors to enter"), 12294, NrOfInvocations.class, "thread_num_monitor_enter", numMonitorEnter, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Num Monitor Enter (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of contented monitors to enter since last thread dump"), 12294, NrOfInvocations.class, "thread_num_monitor_enter", numMonitorEnter, difference);
        }
        VisibilitySet timeMonitorEnter = new VisibilitySet("TimeContentedMonitorEnter", "4-Monitor-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time Monitor Enter"), "tables/col_blocking_count.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Overall time to enter contented monitors"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time Monitor Enter"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Overall time to enter contented monitors"), 12294, ElapsedTime.class, "thread_time_monitor_enter", timeMonitorEnter, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time Monitor Enter (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Overall time to enter contented monitors since last thread dump"), 12294, ElapsedTime.class, "thread_time_monitor_enter", timeMonitorEnter, difference);
        }
        VisibilitySet numObjWait = new VisibilitySet("NumObjectWait", "4-Monitor-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Num Object.wait()"), "tables/col_waiting_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of Object.wait() calls"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Num Object.wait()"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of Object.wait() calls"), 12294, NrOfInvocations.class, "thread_num_wait", numObjWait, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Num Object.wait() (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of Object.wait() calls since last thread dump"), 12294, NrOfInvocations.class, "thread_num_wait", numObjWait, difference);
        }
        VisibilitySet monitorWaitTime = new VisibilitySet("MonitorWaitTime", "4-Monitor-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time Object.wait()"), "tables/col_waiting_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Overall time spent in Object.wait()"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time Object.wait()"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Overall time spent in Object.wait()"), 12294, ElapsedTime.class, "thread_time_wait", monitorWaitTime, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time Object.wait() (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Overall time spent in Object.wait() since last thread dump"), 12294, ElapsedTime.class, "thread_time_wait", monitorWaitTime, difference);
        }
        VisibilitySet numThreadSleep = new VisibilitySet("NumThreadSleep", "4-Monitor-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Num Thread.sleep()"), "tables/col_sleeping_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of Thread.sleep() calls"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Num Thread.sleep()"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of Thread.sleep() calls"), 12294, NrOfInvocations.class, "thread_num_sleep", numThreadSleep, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Num Thread.sleep() (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total number of Thread.sleep() calls since last thread dump"), 12294, NrOfInvocations.class, "thread_num_sleep", numThreadSleep, difference);
        }
        VisibilitySet timeThreadSleep = new VisibilitySet("TimeThreadSleep", "4-Monitor-Footprint", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time Thread.sleep()"), "tables/col_sleepingl_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Overall time spent in Thread.sleep()"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time Thread.sleep()"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Overall time spent in Thread.sleep()"), 12294, ElapsedTime.class, "thread_time_sleep", timeThreadSleep, absolute);
        if (differences) {
            spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time Thread.sleep() (Difference)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Overall time spent in Thread.sleep() since last thread dump"), 12294, ElapsedTime.class, "thread_time_sleep", timeThreadSleep, difference);
        }
    }

    public static TypedColumnSpec getThreadDumpSpec(boolean hasJavaIds) {
        String visibleSet = "ThreadState|CPUTime|ElapsedTime|AllocatedBytes";
        visibleSet = hasJavaIds ? "JavaThreadId|" + visibleSet : "NativeThreadId|" + visibleSet;
        TypedColumnSpec spec = new TypedColumnSpec(visibleSet);
        spec.prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Thread Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The name of the thread"), 9, MixedProviderEntry.class, "thread_entry");
        ProviderUtils.appendCommonThreadDumpSpecColumns(spec, false, true);
        return spec;
    }

    public static ProviderEntry getThreadDumpTreeEntry(ThreadDumpItem threadItem, int column, ThreadDumpValue totalValue, ProfilingSession session) {
        return ProviderUtils.getCommonThreadDumpEntry(true, false, threadItem, null, column - 1, totalValue, session);
    }

    public static TypedColumnSpec getThreadRunSpec(boolean hasElapsedData) {
        String visibleSet = "DumpIndex|Timestamp|TopMethod|ThreadState|CPUTime";
        if (hasElapsedData) {
            visibleSet = visibleSet + "|ElapsedTime";
        }
        visibleSet = visibleSet + "|AllocatedBytes|Difference";
        TypedColumnSpec spec = new TypedColumnSpec(visibleSet);
        spec.prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Thread Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The name of the thread"), 8, MixedProviderEntry.class, "thread_entry");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Dump Index"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The index of the thread dump in the sequence"), 257, NrOfObjects.class, "thread_dump_index", new VisibilitySet("DumpIndex", "0-ThreadRun", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Dump Index"), "vm_monitor/vm_tag.png", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The index of the thread dump in the sequence"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Timestamp"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Timestamp of the thread dump"), 1, Timestamp.class, "thread_dump_timestamp", new VisibilitySet("Timestamp", "0-ThreadRun", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Timestamp"), "decorators/dates.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Timestamp of the thread dump"), new Integer[0]));
        ProviderUtils.appendCommonThreadDumpSpecColumns(spec, true, false);
        return spec;
    }

    public static ProviderEntry getThreadRunEntry(ThreadDumpItem threadItem, ThreadDumpItem prevThreadItem, ThreadDump threadDump, int column, int dumpIndex, ProfilingSession session) {
        if (column == 1) {
            return NrOfObjects.PROTOTYPE.create(dumpIndex + 1);
        }
        if (column == 2) {
            return new Timestamp(threadDump.getTimeStamp());
        }
        assert (column >= 3);
        return ProviderUtils.getCommonThreadDumpEntry(true, true, threadItem, prevThreadItem, column - 3, null, session);
    }

    private static ProviderEntry getCommonThreadDumpEntry(boolean absoluteMode, boolean differenceMode, ThreadDumpItem threadItem, ThreadDumpItem prevThreadItem, int column, ThreadDumpValue totalValue, ProfilingSession session) {
        boolean regardDiffValue = !absoluteMode && differenceMode || absoluteMode && differenceMode && (column - 10) % 2 == 1;
        int effectiveColumn = column;
        if (absoluteMode && differenceMode && column > 10) {
            effectiveColumn = 10 + (column - 10) / 2;
        }
        assert (threadItem != null);
        switch (effectiveColumn) {
            case 0: {
                return new NormalThreadId(threadItem.getJavaThreadId());
            }
            case 1: {
                return new NormalThreadId(threadItem.getKernelId());
            }
            case 2: {
                return new NormalThreadId(threadItem.getPthreadId());
            }
            case 3: {
                return new NormalString(threadItem.getThreadGroupName().toString());
            }
            case 4: {
                return new ThreadStatusEntry(threadItem.getStatus());
            }
            case 5: {
                return new BooleanType(threadItem.isDaemon(), BooleanType.Type.YES_NO);
            }
            case 6: {
                return new NormalString(threadItem.getPriority().getDisplayText());
            }
            case 7: {
                if (threadItem.isDeadlocked()) {
                    assert (threadItem.getBlockedDeadlockCycleIndex() > 0 || threadItem.getDeadlockCycleIndex() > 0);
                    if (threadItem.getBlockedDeadlockCycleIndex() > 0) {
                        return new DeadlockCycleEntry(threadItem.getBlockedDeadlockCycleIndex(), true);
                    }
                    return new DeadlockCycleEntry(threadItem.getDeadlockCycleIndex(), false);
                }
                return null;
            }
            case 8: {
                if (threadItem.getContextClassLoader() != null) {
                    return new NormalClassLoader(threadItem.getContextClassLoader());
                }
                return new NormalString("");
            }
            case 9: {
                StackFrames stacktrace = session.getStackTraceManager().getStackFramesObject(false);
                stacktrace.fillIn(threadItem.getStackTraceIndex());
                MethodLocation topLocation = stacktrace.getMethodLocation(stacktrace.getNrOfFrames() - 1);
                return new StackFrameEntry(topLocation, true);
            }
            case 10: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getNumDefinedClasses();
                        long diff = threadItem.getNumDefinedClasses() - oldValue;
                        return NrOfObjects.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                return NrOfObjects.PROTOTYPE.create(threadItem.getNumDefinedClasses());
            }
            case 11: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getCpuTime(false);
                        long diff = threadItem.getCpuTime(false) - oldValue;
                        return ElapsedTime.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                if (totalValue != null) {
                    long totalCPU = totalValue.getThreadDumpItem().getCpuTime(false);
                    return ElapsedTime.PROTOTYPE.create(threadItem.getCpuTime(false), totalCPU);
                }
                return ElapsedTime.PROTOTYPE.create(threadItem.getCpuTime(false), false);
            }
            case 12: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getElapsedTime(false);
                        long diff = threadItem.getElapsedTime(false) - oldValue;
                        return ElapsedTime.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                return ElapsedTime.PROTOTYPE.create(threadItem.getElapsedTime(false), false);
            }
            case 13: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getMemoryConsumption(false);
                        long diff = threadItem.getMemoryConsumption(false) - oldValue;
                        return NrOfBytes.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                if (totalValue != null) {
                    long totalAllocated = totalValue.getThreadDumpItem().getMemoryConsumption(false);
                    return NrOfBytes.PROTOTYPE.create(threadItem.getMemoryConsumption(false), totalAllocated);
                }
                return NrOfBytes.PROTOTYPE.create(threadItem.getMemoryConsumption(false));
            }
            case 14: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getFileBytesRead(false);
                        long diff = threadItem.getFileBytesRead(false) - oldValue;
                        return NrOfBytes.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                if (totalValue != null) {
                    long total = totalValue.getThreadDumpItem().getFileBytesRead(false);
                    return NrOfBytes.PROTOTYPE.create(threadItem.getFileBytesRead(false), total);
                }
                return NrOfBytes.PROTOTYPE.create(threadItem.getFileBytesRead(false));
            }
            case 15: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getFileBytesWritten(false);
                        long diff = threadItem.getFileBytesWritten(false) - oldValue;
                        return NrOfBytes.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                if (totalValue != null) {
                    long total = totalValue.getThreadDumpItem().getFileBytesWritten(false);
                    return NrOfBytes.PROTOTYPE.create(threadItem.getFileBytesWritten(false), total);
                }
                return NrOfBytes.PROTOTYPE.create(threadItem.getFileBytesWritten(false));
            }
            case 16: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getSocketBytesRead(false);
                        long diff = threadItem.getSocketBytesRead(false) - oldValue;
                        return NrOfBytes.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                if (totalValue != null) {
                    long total = totalValue.getThreadDumpItem().getSocketBytesRead(false);
                    return NrOfBytes.PROTOTYPE.create(threadItem.getSocketBytesRead(false), total);
                }
                return NrOfBytes.PROTOTYPE.create(threadItem.getSocketBytesRead(false));
            }
            case 17: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getSocketBytesWritten(false);
                        long diff = threadItem.getSocketBytesWritten(false) - oldValue;
                        return NrOfBytes.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                if (totalValue != null) {
                    long total = totalValue.getThreadDumpItem().getSocketBytesWritten(false);
                    return NrOfBytes.PROTOTYPE.create(threadItem.getSocketBytesWritten(false), total);
                }
                return NrOfBytes.PROTOTYPE.create(threadItem.getSocketBytesWritten(false));
            }
            case 18: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getNumFilesOpen(false);
                        long diff = threadItem.getNumFilesOpen(false) - oldValue;
                        return NrOfOpenedFiles.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                return NrOfOpenedFiles.PROTOTYPE.create(threadItem.getNumFilesOpen(false));
            }
            case 19: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getNumSocketsOpen(false);
                        long diff = threadItem.getNumSocketsOpen(false) - oldValue;
                        return NrOfOpenedSockets.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                return NrOfOpenedSockets.PROTOTYPE.create(threadItem.getNumSocketsOpen(false));
            }
            case 20: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getContentedEnterCount();
                        long diff = threadItem.getContentedEnterCount() - oldValue;
                        return NrOfInvocations.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                return NrOfInvocations.PROTOTYPE.create(threadItem.getContentedEnterCount());
            }
            case 21: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getContentedEnterTime() * 1000L * 1000L;
                        long diff = threadItem.getContentedEnterTime() * 1000L * 1000L - oldValue;
                        return ElapsedTime.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                return ElapsedTime.PROTOTYPE.create(threadItem.getContentedEnterTime() * 1000L * 1000L, true);
            }
            case 22: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getMonitorWaitCount();
                        long diff = threadItem.getMonitorWaitCount() - oldValue;
                        return NrOfInvocations.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                return NrOfInvocations.PROTOTYPE.create(threadItem.getMonitorWaitCount());
            }
            case 23: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getMonitorWaitTime() * 1000L * 1000L;
                        long diff = threadItem.getMonitorWaitTime() * 1000L * 1000L - oldValue;
                        return ElapsedTime.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                return ElapsedTime.PROTOTYPE.create(threadItem.getMonitorWaitTime() * 1000L * 1000L, true);
            }
            case 24: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getSleepCount();
                        long diff = threadItem.getSleepCount() - oldValue;
                        return NrOfInvocations.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                return NrOfInvocations.PROTOTYPE.create(threadItem.getSleepCount());
            }
            case 25: {
                if (regardDiffValue) {
                    if (prevThreadItem != null) {
                        long oldValue = prevThreadItem.getSleepTime() * 1000L * 1000L;
                        long diff = threadItem.getSleepTime() * 1000L * 1000L - oldValue;
                        return ElapsedTime.PROTOTYPE.createDiff(oldValue, diff);
                    }
                    return null;
                }
                return ElapsedTime.PROTOTYPE.create(threadItem.getSleepTime() * 1000L * 1000L, true);
            }
        }
        assert (false);
        return null;
    }

    public static MixedProviderEntry getThreadDumpEntry(ThreadDumpTreeItem item) {
        ProviderEntry entry = null;
        if (item.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_ROOT_DESCRIPTION || item.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_SUB_DESCRIPTION) {
            entry = new NormalThreadName(item.getValue().getThreadDumpItem().getName(), true);
        } else if (item.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_STACKFRAME) {
            entry = new StackFrameEntry(item.getMethodLocation(), false);
        } else if (item.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_WAITING) {
            entry = new MonitorObjectEntry(item.getMonitorObject(), MonitorObjectUsage.WAITING);
        } else if (item.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_LOCKED) {
            entry = new MonitorObjectEntry(item.getMonitorObject(), MonitorObjectUsage.LOCKED);
        } else if (item.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_BLOCKED) {
            entry = new MonitorObjectEntry(item.getMonitorObject(), MonitorObjectUsage.BLOCKED);
        } else if (item.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_SOCKETINFO) {
            item.getSocketInfo().resolveHostnames(item.getSession().getHostNameManager());
            entry = new SocketObjectEntry(item.getSocketInfo());
        }
        return new MixedProviderEntry(entry);
    }
}

