/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.thread;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportHintClass;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintImportanceComparator;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintTypeComparator;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgencyComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class ThreadDumpReportHintClasses
implements Iterable<ThreadDumpReportHintClass> {
    static ImportanceClass minImportanceClass = System.getProperty("com.sap.jvm.profiling.ThreadDumpReport.ImportanceClass") != null ? ImportanceClass.VERY_LOW : ImportanceClass.MEDIUM;
    private Map<ImportanceClass, List<ThreadDumpHint>> classifiedHints = new HashMap<ImportanceClass, List<ThreadDumpHint>>();
    private ImportanceClass classIter = null;

    public ThreadDumpReportHintClasses(List<ThreadDumpHint> hints) {
        ThreadDumpHint[] sortedHints = hints.toArray(new ThreadDumpHint[0]);
        Arrays.sort(sortedHints, new ThreadDumpHintImportanceComparator(new ThreadDumpHintUrgencyComparator(new ThreadDumpHintTypeComparator())));
        for (ThreadDumpHint hint : sortedHints) {
            List<ThreadDumpHint> classHints;
            ImportanceClass impClass = ImportanceClass.getImportanceClass(hint.getImportance());
            if (impClass.getLimit() < minImportanceClass.getLimit()) continue;
            if (this.classIter == null) {
                this.classIter = impClass;
            }
            if ((classHints = this.classifiedHints.get((Object)impClass)) == null) {
                classHints = new ArrayList<ThreadDumpHint>();
                this.classifiedHints.put(impClass, classHints);
            }
            classHints.add(hint);
        }
    }

    @Override
    public Iterator<ThreadDumpReportHintClass> iterator() {
        return new HintClassIterator();
    }

    private final class HintClassIterator
    implements Iterator<ThreadDumpReportHintClass> {
        private HintClassIterator() {
        }

        @Override
        public boolean hasNext() {
            return ThreadDumpReportHintClasses.this.classIter != null;
        }

        @Override
        public ThreadDumpReportHintClass next() {
            ThreadDumpReportHintClass result = null;
            List classHints = (List)ThreadDumpReportHintClasses.this.classifiedHints.get((Object)ThreadDumpReportHintClasses.this.classIter);
            if (classHints != null && ThreadDumpReportHintClasses.this.classIter != null) {
                String className = ThreadDumpReportHintClasses.this.classIter.getDescription();
                ThreadDumpHint[] arrayHints = classHints.toArray(new ThreadDumpHint[0]);
                result = new ThreadDumpReportHintClass(className, arrayHints);
                ThreadDumpReportHintClasses.this.classIter = null;
                for (int nextOrder = ThreadDumpReportHintClasses.this.classIter.getOrder() + 1; ThreadDumpReportHintClasses.this.classIter == null && nextOrder < ImportanceClass.values().length; ++nextOrder) {
                    ImportanceClass nextClass = ImportanceClass.values()[nextOrder];
                    if (ThreadDumpReportHintClasses.this.classifiedHints.get((Object)nextClass) == null) continue;
                    ThreadDumpReportHintClasses.this.classIter = nextClass;
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static enum ImportanceClass {
        VERY_HIGH(0, I18n._ts((I18n.TextType)I18n.TextType.XGRP, (String)"Hints with Very High Relevance"), 0.9),
        HIGH(1, I18n._ts((I18n.TextType)I18n.TextType.XGRP, (String)"Hints with High Relevance"), 0.7),
        MEDIUM(2, I18n._ts((I18n.TextType)I18n.TextType.XGRP, (String)"Hints with Medium Relevance"), 0.5),
        LOW(3, I18n._ts((I18n.TextType)I18n.TextType.XGRP, (String)"Hints with Low Relevance"), 0.2),
        VERY_LOW(4, I18n._ts((I18n.TextType)I18n.TextType.XGRP, (String)"Hints with Very Low Relevance"), 0.0);

        private final String description;
        private final double limit;
        private final int order;

        private ImportanceClass(int order, String description, double limit) {
            this.description = description;
            this.limit = limit;
            this.order = order;
        }

        public String getDescription() {
            return this.description;
        }

        public double getLimit() {
            return this.limit;
        }

        public int getOrder() {
            return this.order;
        }

        public static ImportanceClass getImportanceClass(double value) {
            for (ImportanceClass testClass : ImportanceClass.values()) {
                if (!(testClass.getLimit() <= value)) continue;
                return testClass;
            }
            return VERY_LOW;
        }
    }
}

