/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.thread;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.icons.ImageRepository;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.description.renderer.ExpandNode;
import com.sap.jvm.profiling.presentation.description.renderer.Margin;
import com.sap.jvm.profiling.presentation.description.renderer.MarginNode;
import com.sap.jvm.profiling.presentation.description.renderer.RendererStyle;
import com.sap.jvm.profiling.presentation.description.renderer.StyleNode;
import com.sap.jvm.profiling.presentation.description.renderer.ToggleNode;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReport;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportBlockedThread;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportBusyLoop;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportDeadlock;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportHintInfo;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportHotspot;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportInactiveThread;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportLockContention;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportNodes;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportResourceLeak;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportSummary;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportTopConsumer;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportHintClass;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportHintClasses;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.TypedReportProvider;
import com.sap.jvm.profiling.presentation.typed.thread.ThreadDumpReportProvider;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.thread.Elements;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import com.sap.jvm.profiling.snapshot.thread.compare.ThreadDumpCompareResult;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintBlockedThread;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintBusyLoop;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintDeadlock;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintHotspot;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintInactiveThread;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintLockContention;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintResourceLeak;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintTopConsumer;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import com.sap.jvm.profiling.viewer.renderer.MultiChildNode;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.report.ReportLinkHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public final class ThreadDumpReportProviderImpl
extends TypedReportProvider
implements ThreadDumpReportProvider {
    private ThreadDumpCompareResult compareResult;
    private final ThreadDumpLinkHandler linkHandler = new ThreadDumpLinkHandler();
    private final EntryContext entryContext;
    private boolean firstSection = false;
    private static final int MAX_THREADNAME_LENGTH = 60;

    public ThreadDumpReportProviderImpl(ResourceName name) throws IOException {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Thread Dump Report"), "views/report_view.gif");
        this.entryContext = new EntryContext(name.getSession());
    }

    @Override
    public RendererNode getReport(DescriptionViewer viewer, ProgressReporter reporter) throws IOException {
        ThreadDumpSnapshot snapshot = (ThreadDumpSnapshot)SnapshotResourceManagerFactory.get(this.getResourceName().getSession()).getSnapshot(this.getResourceName());
        this.compareResult = (ThreadDumpCompareResult)this.getResourceName().getResourceManager().get(snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateThreadDumpCompareResult()), reporter);
        ThreadDumpReportNodes nodes = new ThreadDumpReportNodes(viewer, this.getEntryContext());
        List<ThreadDumpHint> hints = this.compareResult.getHints();
        ArrayList<RendererNode> reportNodes = new ArrayList<RendererNode>();
        ThreadDumpReportSummary overview = new ThreadDumpReportSummary(this, nodes);
        RendererNode summarySection = overview.createSummarySection(this.compareResult.getSummary());
        reportNodes.add(this.createReportSection(summarySection, I18n._s((String)"Thread Dumps Overview"), nodes));
        RendererNode connectionSection = overview.createConnectionsSection(this.compareResult.getSummary());
        if (connectionSection != null) {
            reportNodes.add(this.createReportSection(connectionSection, I18n._s((String)"Network Connections"), nodes));
        }
        int layerIndex = reportNodes.size();
        reporter.setWork(I18n._s((String)"Generating thread dump hint UI (<%>% done)"), (long)hints.size());
        HintRenderer hintGenerator = new HintRenderer(viewer, this, nodes);
        ThreadDumpReportHintClasses hintClasses = new ThreadDumpReportHintClasses(hints);
        for (ThreadDumpReportHintClass hintClass : hintClasses) {
            ArrayList<RendererNode> hintsNodes = new ArrayList<RendererNode>();
            for (ThreadDumpHint hint : hintClass.getHints()) {
                RendererNode node = hintGenerator.generateHint(hint);
                hintsNodes.add(node);
                reporter.reportNextOrThrow();
            }
            MultiChildNode<? extends RendererNode> sectionContent = viewer.newMultiChildNode(hintsNodes.toArray(new RendererNode[0]));
            RendererNode hintClassSection = this.createReportSection(sectionContent, hintClass.getTitle(), nodes);
            reportNodes.add(hintClassSection);
        }
        RendererNode toggleLayers = hintGenerator.generateHintClassToggles();
        RendererNode layerSection = this.createReportSection(toggleLayers, I18n._s((String)"Hints Overview"), nodes);
        reportNodes.add(layerIndex, layerSection);
        return viewer.newMultiChildNode(reportNodes.toArray(new RendererNode[0]));
    }

    public ThreadDumpsSummary getSummary() {
        return this.compareResult.getSummary();
    }

    private RendererNode createReportSection(RendererNode section, String sectionTitle, ThreadDumpReportNodes nodes) {
        DescriptionViewer viewer = nodes.getViewer();
        RendererStyle styleActive = this.firstSection ? RendererStyle.TITLE : RendererStyle.FIRST_TITLE;
        RendererStyle stylePassive = this.firstSection ? RendererStyle.TITLE_PASSIVE : RendererStyle.FIRST_TITLE_PASSIVE;
        this.firstSection = true;
        StyleNode<?> titleOpen = nodes.line(nodes.getDirectoryIcon()[0], viewer.newSpaceNode(2), sectionTitle);
        titleOpen = viewer.newStyleNode(titleOpen, styleActive);
        StyleNode<?> titleClosed = nodes.line(nodes.getDirectoryIcon()[1], viewer.newSpaceNode(2), sectionTitle, "[...]");
        titleClosed = viewer.newStyleNode(titleClosed, stylePassive);
        MarginNode<?> childSection = viewer.newMarginNode(section, new Margin(15, 0));
        return nodes.toggleNode(titleOpen, childSection, titleClosed, viewer.newNopNode());
    }

    public RendererNode threadLink(int threadIndex, DescriptionViewer viewer) {
        ThreadDumpItem item = this.compareResult.getSummary().getThreadDumps().getThreadRunHead(threadIndex);
        return this.threadLink(item, threadIndex, viewer);
    }

    public RendererNode threadLink(ThreadDumpItem item, DescriptionViewer viewer) {
        ThreadDumps dumps = this.compareResult.getSummary().getThreadDumps();
        int dumpIndex = dumps.threadDumpItem2DumpIndex(item);
        int threadIndex = dumps.threadIndex2ThreadRunIndex(dumpIndex, item.getThreadIndex());
        return this.threadLink(item, threadIndex, viewer);
    }

    public RendererNode threadLink(ThreadDumpItem item, int threadIndex, DescriptionViewer viewer) {
        assert (viewer != null);
        String threadName = item.getName().toString();
        String shortName = threadName;
        if (shortName.length() > 60) {
            shortName = shortName.substring(0, 60) + "...";
        }
        if (item.getJavaThreadId() > 0L) {
            shortName = String.format("%s, id = %d", shortName, item.getJavaThreadId());
        }
        RendererNode threadNode = viewer.newTextNode(shortName);
        String tooltip = String.format(I18n._s((String)"Thread '%s'"), threadName);
        if (item.getJavaThreadId() > 0L) {
            tooltip = String.format(I18n._s((String)"Thread '%s', Java Id: %d"), threadName, item.getJavaThreadId());
        } else if (item.getNativeId() > 0L) {
            tooltip = String.format(I18n._s((String)"Thread '%s', Native Id: %d"), threadName, item.getNativeId());
        }
        threadNode = viewer.newToolTipNode(threadNode, tooltip);
        return this.link(viewer, "thread-run-lookup", Integer.toString(threadIndex), threadNode);
    }

    public RendererNode dumpLink(int dumpIndex, DescriptionViewer viewer) {
        ThreadDumps dumps = this.compareResult.getSummary().getThreadDumps();
        String dumpName = dumps.getDumpName(dumpIndex);
        String timestamp = DataFormatter.getTimeStampLong((long)dumps.getTimeStamp(dumpIndex), (TimeZone)this.getResourceName().getSession().getTimeZone());
        String tooltip = String.format(I18n._s((String)"Thread dump with index %d at %s"), dumpIndex + 1, timestamp);
        RendererNode dumpNode = viewer.newTextNode(dumpName);
        dumpNode = viewer.newToolTipNode(dumpNode, tooltip);
        return this.link(viewer, "thread-dump-lookup", Integer.toString(dumpIndex), dumpNode);
    }

    @Override
    public void addMethodLink(MethodObject method) {
        this.linkHandler.add(method);
    }

    @Override
    public ReportLinkHandler getLinkHandler() {
        return this.linkHandler;
    }

    @Override
    public EntryContext getEntryContext() {
        return this.entryContext;
    }

    @Override
    public ThreadDumpCompareResult getCompareResult() {
        return this.compareResult;
    }

    private static final class ThreadDumpLinkHandler
    implements ReportLinkHandler {
        private final Map<Long, MethodObject> methods = new HashMap<Long, MethodObject>();

        private ThreadDumpLinkHandler() {
        }

        @Override
        public boolean handleLink(ReportLinkHandler.LinkVisualizer visualizer, String location, String options) {
            assert ("method-source-lookup".equals(location));
            if (options == null) {
                return false;
            }
            MethodObject m = this.methods.get(Long.parseLong(options));
            return visualizer.showSource(m, m.getSession());
        }

        private void add(MethodObject method) {
            this.methods.put(method.getId(), method);
        }
    }

    static final class HintRenderer {
        private DescriptionViewer viewer;
        private Map<String, ThreadDumpReport> reporter;
        private ThreadDumpReportNodes rendererNodes;
        private Map<ThreadDumpReportHintInfo, List<ToggleNode<?>>> hintLayers;

        public HintRenderer(DescriptionViewer viewer, ThreadDumpReportProviderImpl provider, ThreadDumpReportNodes rendererNodes) {
            this.viewer = viewer;
            this.rendererNodes = rendererNodes;
            this.reporter = new HashMap<String, ThreadDumpReport>();
            this.reporter.put(this.normalize(ThreadDumpHintTopConsumer.class.getName()), new ThreadDumpReportTopConsumer(viewer, provider, rendererNodes));
            this.reporter.put(this.normalize(ThreadDumpHintHotspot.class.getName()), new ThreadDumpReportHotspot(viewer, provider, rendererNodes));
            this.reporter.put(this.normalize(ThreadDumpHintBusyLoop.class.getName()), new ThreadDumpReportBusyLoop(viewer, provider, rendererNodes));
            this.reporter.put(this.normalize(ThreadDumpHintResourceLeak.class.getName()), new ThreadDumpReportResourceLeak(viewer, provider, rendererNodes));
            this.reporter.put(this.normalize(ThreadDumpHintLockContention.class.getName()), new ThreadDumpReportLockContention(viewer, provider, rendererNodes));
            this.reporter.put(this.normalize(ThreadDumpHintBlockedThread.class.getName()), new ThreadDumpReportBlockedThread(viewer, provider, rendererNodes));
            this.reporter.put(this.normalize(ThreadDumpHintDeadlock.class.getName()), new ThreadDumpReportDeadlock(viewer, provider, rendererNodes));
            this.reporter.put(this.normalize(ThreadDumpHintInactiveThread.class.getName()), new ThreadDumpReportInactiveThread(viewer, provider, rendererNodes));
            this.hintLayers = new HashMap();
        }

        private String normalize(String className) {
            int index = className.lastIndexOf(46);
            int index2 = className.indexOf("Impl");
            if (index >= 0) {
                return className.substring(index + 1, index2 > 1 ? index2 : className.length());
            }
            return className;
        }

        public RendererNode generateHint(ThreadDumpHint hint) {
            String hintClassName = hint.getClass().getName();
            ThreadDumpReport report = this.reporter.get(hintClassName = this.normalize(hintClassName));
            if (report != null) {
                ThreadDumpReportHintInfo hintInfo = report.getHintInfo(hint);
                List<ToggleNode<?>> toggleNodes = this.hintLayers.get(hintInfo);
                if (toggleNodes == null) {
                    toggleNodes = new ArrayList(10);
                    this.hintLayers.put(hintInfo, toggleNodes);
                }
                RendererNode hintNode = report.generateHint(hint);
                ToggleNode<?> toggleHint = this.viewer.newToggleNode(hintNode, this.viewer.newNopNode());
                toggleNodes.add(toggleHint);
                return toggleHint;
            }
            return null;
        }

        public RendererNode generateHintClassToggles() {
            ArrayList<RendererNode> classToggleNodes = new ArrayList<RendererNode>();
            for (Map.Entry<ThreadDumpReportHintInfo, List<ToggleNode<?>>> entry : this.hintLayers.entrySet()) {
                ThreadDumpReportHintInfo hintInfo = entry.getKey();
                List<ToggleNode<?>> classToggles = entry.getValue();
                ToggleNode[] toggles = new ToggleNode[classToggles.size() + 2];
                for (int i = 0; i < classToggles.size(); ++i) {
                    toggles[i + 2] = classToggles.get(i);
                }
                RendererNode[] icons = new RendererNode[]{this.rendererNodes.image(ImageRepository.getImageURI(hintInfo.getEnableIcon()), String.format("Show %s hints", hintInfo.getTitle())), this.rendererNodes.image(ImageRepository.getImageURI(hintInfo.getDisableIcon()), String.format("Hide %s hints", hintInfo.getTitle()))};
                toggles[0] = this.rendererNodes.expandCollapseToggle(icons, false);
                toggles[1] = this.viewer.newToggleNode(this.rendererNodes.getCheckboxIcon()[0], this.rendererNodes.getCheckboxIcon()[1]);
                RendererNode titleText = this.viewer.newChangeBoldNode(false, this.rendererNodes.text(hintInfo.getTitle()));
                int num = classToggles.size();
                titleText = num > 1 ? this.rendererNodes.replace(I18n._s((String)"{0} ({1} hints)"), titleText, classToggles.size()) : this.rendererNodes.replace(I18n._s((String)"{0} ({1} hint)"), titleText, classToggles.size());
                titleText = this.rendererNodes.largeFont(titleText);
                StyleNode<?> icon = this.viewer.newStyleNode(toggles[0], RendererStyle.IMG);
                StyleNode<?> checkBox = this.viewer.newStyleNode(toggles[1], RendererStyle.IMG);
                ExpandNode<?> layerCheck = this.rendererNodes.line(icon, checkBox);
                layerCheck = this.viewer.newExpandNode((RendererNode)layerCheck, toggles);
                RendererNode titleLine = this.rendererNodes.line(layerCheck, titleText, this.viewer.newSpaceNode(10));
                titleLine = this.viewer.newExpandNode(titleLine, toggles);
                titleLine = this.viewer.newNoLineBreakNode(titleLine);
                classToggleNodes.add(titleLine);
            }
            classToggleNodes.add(this.rendererNodes.lineBreak());
            return this.rendererNodes.line(classToggleNodes);
        }
    }
}

