/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.thread;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ProviderUtils;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpTableProvider;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.thread.Elements;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpStatistic;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class ThreadDumpStatisticProvider
extends ThreadDumpTableProvider<ThreadDumpStatistic> {
    public ThreadDumpStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Thread Statistic"), "views/thread_statistic.gif", ProviderUtils.getThreadDumpSpec(true));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        ThreadDumpValue val = (ThreadDumpValue)((ThreadDumpStatistic)this.statistic).getValue(entryId);
        ProfilingSession session = this.getResourceName().getSession();
        return ProviderUtils.getThreadDumpTreeEntry(val.getThreadDumpItem(), column, (ThreadDumpValue)((ThreadDumpStatistic)this.statistic).getValue(), session);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((ThreadDumpStatistic)this.statistic).getKeyColumn();
        }
        return null;
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateThreadDumpStatistic());
    }

    @Override
    public long getNumThreads() {
        return ((ThreadDumpStatistic)this.statistic).size();
    }
}

