/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.thread;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ProviderUtils;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpValueTreeProvider;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.thread.Elements;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.thread.Elements;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTree;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItem;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItemType;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValueTreeNode;
import java.io.IOException;

public final class ThreadDumpTreeProvider
extends ThreadDumpValueTreeProvider<ThreadDumpValueTreeNode, ThreadDumpTree> {
    private int dumpIndex;

    public ThreadDumpTreeProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Thread Dump Tree"), "views/thread_dump_view.png", ProviderUtils.getThreadDumpSpec(true));
        Elements.CreateThreadDumpTreeProvider provider = (Elements.CreateThreadDumpTreeProvider)this.getResourceName().getLastElement();
        this.dumpIndex = provider.getId();
        ThreadDumpSnapshot threadDumpSnapshot = (ThreadDumpSnapshot)this.getSnapshot();
        if (!threadDumpSnapshot.hasJavaThreadIdData()) {
            super.setColumnSpec(ProviderUtils.getThreadDumpSpec(false));
        }
        this.title = I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Thread Dump {0}", (Object[])new Object[]{this.dumpIndex + 1});
    }

    @Override
    public void createChildren(Object node, ProgressReporter reporter) throws IOException {
        ((ThreadDumpTree)this.tree).createChildren((ThreadDumpValueTreeNode)this.toNode(node), reporter);
    }

    @Override
    protected ResourceName getTreeName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateThreadDumpTree(this.dumpIndex));
    }

    @Override
    public ProviderEntry getEntry(Object node, int column) {
        ThreadDumpTreeItem keyEntry = (ThreadDumpTreeItem)((ThreadDumpValueTreeNode)this.toNode(node)).getKey();
        ThreadDumpValue val = keyEntry.getValue();
        if (column == 0) {
            return ProviderUtils.getThreadDumpEntry(keyEntry);
        }
        if (keyEntry.isRootItem()) {
            return ProviderUtils.getThreadDumpTreeEntry(val.getThreadDumpItem(), column, (ThreadDumpValue)((ThreadDumpTree)this.tree).getTotal(), keyEntry.getSession());
        }
        if (column == 1 && keyEntry.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_SUB_DESCRIPTION) {
            return ProviderUtils.getThreadDumpTreeEntry(val.getThreadDumpItem(), column, (ThreadDumpValue)((ThreadDumpTree)this.tree).getTotal(), keyEntry.getSession());
        }
        return null;
    }

    @Override
    public void createSubNodes(Object node, ProgressReporter reporter) throws IOException {
        ((ThreadDumpTree)this.tree).createSubNodes((ThreadDumpValueTreeNode)this.toNode(node), reporter);
    }
}

