/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.thread;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ProviderUtils;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpValueTreeProvider;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.thread.Elements;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.thread.Elements;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTree;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItem;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItemType;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValueTreeNode;
import java.io.IOException;

public final class ThreadRunTreeProvider
extends ThreadDumpValueTreeProvider<ThreadDumpValueTreeNode, ThreadDumpTree> {
    private int threadIndex;

    public ThreadRunTreeProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Thread Run Statistic"), "views/thread_run_view.gif", ProviderUtils.getThreadRunSpec(true));
        Elements.CreateThreadRunTreeProvider provider = (Elements.CreateThreadRunTreeProvider)this.getResourceName().getLastElement();
        this.threadIndex = provider.getId();
        ThreadDumpSnapshot threadDumpSnapshot = (ThreadDumpSnapshot)this.getSnapshot();
        if (!threadDumpSnapshot.hasElapsedTimeData()) {
            super.setColumnSpec(ProviderUtils.getThreadRunSpec(false));
        }
        this.title = I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Thread Run");
    }

    @Override
    public void createChildren(Object node, ProgressReporter reporter) throws IOException {
        ((ThreadDumpTree)this.tree).createChildren((ThreadDumpValueTreeNode)this.toNode(node), reporter);
    }

    @Override
    protected ResourceName getTreeName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateThreadRunTree(this.threadIndex));
    }

    @Override
    public ProviderEntry getEntry(Object node, int column) {
        ThreadDumpTreeItem keyEntry = (ThreadDumpTreeItem)((ThreadDumpValueTreeNode)this.toNode(node)).getKey();
        if (column == 0) {
            return ProviderUtils.getThreadDumpEntry(keyEntry);
        }
        if (keyEntry.isRootItem()) {
            ThreadDumpValue value = keyEntry.getValue();
            return ProviderUtils.getThreadRunEntry(value.getThreadDumpItem(), value.getPrevThreadDumpItem(), value.getThreadDump(), column, value.getDumpIndex(), this.getResourceName().getSession());
        }
        if (column == 1 && keyEntry.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_SUB_DESCRIPTION) {
            return null;
        }
        return null;
    }

    @Override
    public void createSubNodes(Object node, ProgressReporter reporter) throws IOException {
        ((ThreadDumpTree)this.tree).createSubNodes((ThreadDumpValueTreeNode)this.toNode(node), reporter);
    }
}

