/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.xml;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XMLElementConstants;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlSink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;

public class MappingInfoCollector
implements XMLElementConstants {
    private final HashSet<MethodObject> methodObjects = new HashSet();
    private final HashSet<ClassObject> classObjects = new HashSet();
    private final HashSet<ClassLoaderObject> classLoaders = new HashSet();

    public void addMappingInfo(MethodObject method) {
        if (this.methodObjects.add(method)) {
            this.addMappingInfo((ClassObject)method.getMethodClass());
        }
    }

    public void addMappingInfo(ClassObject classObj) {
        if (this.classObjects.add(classObj)) {
            this.addMappingInfo(classObj.getClassLoader());
        }
    }

    public void addMappingInfo(ClassLoaderObject classLoader) {
        if (this.classLoaders.add(classLoader)) {
            int nrParents = classLoader.getNrOfParents();
            for (int i = 0; i < nrParents; ++i) {
                this.addMappingInfo(classLoader.getParent(i));
            }
            ClassObject loaderClazz = classLoader.getClassObject();
            if (loaderClazz != null) {
                this.addMappingInfo(loaderClazz);
            }
        }
    }

    public void exportMappingInfo(XmlSink sink) {
        this.exportClassLoaderInfo(sink);
        this.exportClassInfo(sink);
        this.exportMethodInfo(sink);
    }

    public void clear() {
        this.classLoaders.clear();
        this.classObjects.clear();
        this.methodObjects.clear();
    }

    private void exportMethodInfo(XmlSink sink) {
        if (this.methodObjects.size() == 0) {
            return;
        }
        sink.writeComment("Method definitions");
        ArrayList<MethodObject> sortedMethods = new ArrayList<MethodObject>(this.methodObjects);
        Collections.sort(sortedMethods, new Comparator<MethodObject>(){

            @Override
            public int compare(MethodObject m1, MethodObject m2) {
                long id2;
                long id1 = m1.getId();
                return id1 < (id2 = m2.getId()) ? -1 : (id1 == id2 ? 0 : 1);
            }
        });
        for (MethodObject method : sortedMethods) {
            sink.emptyElement("method-def", sink.newAttribute("id", method.getIndex()), sink.newAttribute("return-type", method.getReturnType()), sink.newAttribute("class-id", method.getMethodClass().getIndex()), sink.newAttribute("name", method.getName()), sink.newAttribute("signature", method.getSignature()));
        }
    }

    private void exportClassInfo(XmlSink sink) {
        if (this.classObjects.size() == 0) {
            return;
        }
        sink.writeComment("Class definitions");
        ArrayList<ClassObject> sortedClasses = new ArrayList<ClassObject>(this.classObjects);
        Collections.sort(sortedClasses, new Comparator<ClassObject>(){

            @Override
            public int compare(ClassObject c1, ClassObject c2) {
                long id2;
                long id1 = c1.getId();
                return id1 < (id2 = c2.getId()) ? -1 : (id1 == id2 ? 0 : 1);
            }
        });
        for (ClassObject classObj : sortedClasses) {
            sink.emptyElement("class-def", sink.newAttribute("id", classObj.getIndex()), sink.newAttribute("name", classObj.getName()), sink.newAttribute("package", classObj.getPackageName()), sink.newAttribute("loader-id", classObj.getClassLoader().getIndex()));
        }
    }

    private void exportClassLoaderInfo(XmlSink sink) {
        if (this.classLoaders.size() == 0) {
            return;
        }
        sink.writeComment("Class loader definitions");
        ArrayList<ClassLoaderObject> sortedClassLoaders = new ArrayList<ClassLoaderObject>(this.classLoaders);
        Collections.sort(sortedClassLoaders, new Comparator<ClassLoaderObject>(){

            @Override
            public int compare(ClassLoaderObject cl1, ClassLoaderObject cl2) {
                long id2;
                long id1 = cl1.getId();
                return id1 < (id2 = cl2.getId()) ? -1 : (id1 == id2 ? 0 : 1);
            }
        });
        for (ClassLoaderObject classLoader : sortedClassLoaders) {
            if (classLoader.getClassObject() == null) {
                sink.beginElement("loader-def", sink.newAttribute("id", classLoader.getIndex()), sink.newAttribute("name", classLoader.getName()));
            } else {
                sink.beginElement("loader-def", sink.newAttribute("id", classLoader.getIndex()), sink.newAttribute("name", classLoader.getName()), sink.newAttribute("class-id", classLoader.getClassObject().getIndex()));
            }
            for (int parent = 0; parent < classLoader.getNrOfParents(); ++parent) {
                String parentId = Integer.toString(classLoader.getParent(parent).getIndex());
                sink.inlineElement("parent", parentId);
            }
            for (int urlId = 0; urlId < classLoader.getNrOfURLs(); ++urlId) {
                sink.inlineElement("url", classLoader.getURLString(urlId));
            }
            sink.endElement("loader-def");
        }
    }
}

