/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.xml;

import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.pair.ObjectPair;
import java.io.IOException;
import java.io.Writer;

public class XmlSink {
    private static final char APOS = '\'';
    private static final char QUOTE = '\"';
    private static final int MAX_WRITE_SEGMENT = 102400;
    private StringBuilder out = new StringBuilder();
    private StringBuilder indent = new StringBuilder();
    private String indentStep = "  ";

    public void beginElement(String elementName) {
        this.out.append((CharSequence)this.indent);
        this.out.append("<").append(elementName).append(">\n");
        this.indent.append(this.indentStep);
    }

    public void beginElement(String elementName, ObjectPair<String, Object> ... attributes) {
        this.out.append((CharSequence)this.indent);
        this.out.append("<").append(elementName);
        this.appendAttributes(attributes);
        this.out.append(">\n");
        this.indent.append(this.indentStep);
    }

    public void endElement(String elementName) {
        this.indent.setLength(this.indent.length() - this.indentStep.length());
        this.out.append((CharSequence)this.indent);
        this.out.append("</").append(elementName).append(">\n");
    }

    public void emptyElement(String elementName) {
        this.out.append((CharSequence)this.indent);
        this.out.append("<").append(elementName).append(" />\n");
    }

    public void emptyElement(String elementName, ObjectPair<String, Object> ... attributes) {
        this.out.append((CharSequence)this.indent);
        this.out.append("<").append(elementName);
        this.appendAttributes(attributes);
        this.out.append(" />\n");
    }

    public void inlineElement(String elementName, String content) {
        this.out.append((CharSequence)this.indent);
        this.out.append("<").append(elementName).append(">");
        this.out.append(XmlSink.escapeSpecialChars(content));
        this.out.append("</").append(elementName).append(">\n");
    }

    public ObjectPair<String, Object> newAttribute(String name, Object value) {
        return new ObjectPair((Object)name, value);
    }

    public ObjectPair<String, Object> newAttribute(String name, long value) {
        return new ObjectPair((Object)name, (Object)Long.toString(value));
    }

    public void writeComment(String commentText) {
        this.out.append("\n");
        this.out.append((CharSequence)this.indent);
        this.out.append("<!-- ");
        this.indent.append("     ");
        int lineStart = 0;
        int lineEnd = commentText.indexOf(10, lineStart);
        while (lineEnd >= 0) {
            String commentLine = XmlSink.escapeSpecialChars(commentText.substring(lineStart, lineEnd + 1));
            this.out.append(commentLine);
            this.out.append((CharSequence)this.indent);
            lineStart = lineEnd + 1;
            lineEnd = commentText.indexOf(10, lineStart);
        }
        this.out.append(XmlSink.escapeSpecialChars(commentText.substring(lineStart)));
        this.out.append(" -->\n");
        this.indent.setLength(this.indent.length() - 5);
        this.out.append("\n");
    }

    public String getOutput() {
        return this.out.toString();
    }

    public void writeContent(Writer writer) throws IOException {
        int size;
        int start = 0;
        int remaining = this.out.length();
        do {
            size = remaining > 102400 ? 102400 : remaining;
            writer.write(this.out.substring(start, start + size));
            start += size;
        } while ((remaining -= size) > 0);
    }

    public void clear() {
        this.out.setLength(0);
    }

    private void appendAttributes(ObjectPair<String, Object> ... attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            String attributeName = (String)attributes[i].getFirst();
            Object value = attributes[i].getSecond();
            if (value == null) {
                value = "null";
                Trace.warn(() -> "Null value for attribute " + attributeName + " in XML export");
            }
            String attributeValue = XmlSink.escapeSpecialChars(value.toString());
            this.out.append(' ').append(attributeName).append('=');
            XmlSink.escapeAttribute(attributeValue, this.out);
        }
    }

    public static String escapeAttribute(String attr) {
        StringBuilder out = new StringBuilder();
        XmlSink.escapeAttribute(attr, out);
        return out.toString();
    }

    private static void escapeAttribute(String attr, StringBuilder out) {
        String escape;
        String quote_regex;
        int apos_pos = attr.indexOf(39);
        int quote_pos = attr.indexOf(34);
        if (apos_pos < 0 && quote_pos < 0) {
            out.append('\'').append(attr).append('\'');
            return;
        }
        if (quote_pos == -1 || apos_pos != -1 && apos_pos < quote_pos) {
            quote_regex = String.valueOf('\"');
            escape = "&quot;";
        } else {
            quote_regex = String.valueOf('\'');
            escape = "&apos;";
        }
        out.append(quote_regex).append(attr.replaceAll(quote_regex, escape)).append(quote_regex);
    }

    private static String escapeSpecialChars(String input) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '<') {
                result.append("&lt;");
                continue;
            }
            if (c == '>') {
                result.append("&gt;");
                continue;
            }
            if (c == '&') {
                result.append("&amp;");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        XmlSink sink = new XmlSink();
        sink.appendAttributes(sink.newAttribute("\ntest1", "Test mit <APOS> (') Zeichen"), sink.newAttribute("\ntest2", "Test mit <QUOTE> (\") Zeichen"), sink.newAttribute("\ntest3", "Test mit beiden (' & \") Zeichen"), sink.newAttribute("\ntest4", "Test mit beiden (\" & ') Zeichen"));
        System.out.println(sink.getOutput());
    }
}

