/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.xml;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.TypedTableModelImpl;
import com.sap.jvm.profiling.presentation.impl.typed.xml.MappingInfoCollector;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XMLElementConstants;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlModelViewer;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlSink;
import com.sap.jvm.profiling.presentation.impl.typed.xml.exporter.EntryExporter;
import com.sap.jvm.profiling.presentation.impl.typed.xml.exporter.IgnoreExporter;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.XmlModelExporter;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ProgressReporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class XmlTableExporter
implements XmlModelExporter,
XMLElementConstants {
    private final TypedTableModelImpl model;
    private EntryExporter[] entryExporters;
    private final boolean selectedOnly;

    public XmlTableExporter(TypedTableModelImpl model, boolean selectedOnly) {
        this.model = model;
        this.selectedOnly = selectedOnly;
        this.entryExporters = XmlModelViewer.createExporters(model.getSpec());
    }

    @Override
    public void writeXml(File file, ProgressReporter reporter) throws IOException {
        reporter.setMessage(I18n._s((String)"Exporting table to XML format ..."));
        XmlSink sink = new XmlSink();
        MappingInfoCollector mapping = new MappingInfoCollector();
        this.writeContent(sink, mapping, reporter, null);
        XmlSink mappingSink = new XmlSink();
        mappingSink.writeComment("Mapping information");
        mappingSink.beginElement("mappings");
        mapping.exportMappingInfo(mappingSink);
        mapping.clear();
        mappingSink.endElement("mappings");
        if (reporter.isCancelled()) {
            return;
        }
        File directory = file.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fileOut, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<body>");
        mappingSink.writeContent(out);
        sink = new XmlSink();
        this.writeContent(sink, mapping, reporter, out);
        out.write("</body>");
        out.flush();
        out.close();
    }

    private void writeContent(XmlSink sink, MappingInfoCollector mapping, ProgressReporter reporter, Writer writer) throws IOException {
        sink.writeComment("Column headers and entry type descriptions");
        sink.beginElement("headers");
        TypedColumnSpec spec = this.model.getSpec();
        for (int column : this.model.getColumnOrder()) {
            if (this.entryExporters[column] instanceof IgnoreExporter || !this.model.isColumnVisible(column)) continue;
            this.model.getSpec().getColumnToolTip(column);
            sink.emptyElement("column", sink.newAttribute("tag", spec.getColumnTag(column)), sink.newAttribute("title", this.model.getColumnText(column)), sink.newAttribute("info", this.model.getColumnToolTip(column)));
        }
        sink.endElement("headers");
        sink.writeComment("The table rows");
        sink.beginElement("root");
        this.writeRows(sink, mapping, reporter, writer);
        sink.endElement("root");
        if (writer != null) {
            sink.writeContent(writer);
        }
        sink.clear();
    }

    private void writeRows(XmlSink sink, MappingInfoCollector mapping, ProgressReporter reporter, Writer writer) throws IOException {
        for (int i = 0; i < this.model.getNrOfItems(); ++i) {
            int itemId = this.model.getItemId(i);
            if (this.model.isSelected(itemId) || !this.selectedOnly) {
                sink.beginElement("row");
                this.writeItem(itemId, sink, mapping);
                sink.endElement("row");
                if (writer != null) {
                    sink.writeContent(writer);
                }
                sink.clear();
            }
            if (!reporter.reportNext()) break;
        }
    }

    private void writeItem(int itemId, XmlSink sink, MappingInfoCollector mapping) {
        for (int column : this.model.getColumnOrder()) {
            ProviderEntry entry;
            if (!this.model.isColumnVisible(column) || (entry = this.model.getEntryForItem(itemId, column)) == null) continue;
            this.entryExporters[column].exportEntry(entry, sink, mapping);
        }
    }
}

