/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.xml;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlSink;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.presentation.typed.XmlModelExporter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotation;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotationSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphVirtualDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.viewer.series.TimeSeriesModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.Iterator;

public class XmlTimeSeriesExporter
implements XmlModelExporter {
    private final TimeSeriesModel model;

    public XmlTimeSeriesExporter(TimeSeriesModel model) {
        this.model = model;
    }

    @Override
    public void writeXml(File file, ProgressReporter reporter) throws IOException {
        long overallWork = 0L;
        TypedTimeSeriesModel typedModel = null;
        if (this.model instanceof TypedTimeSeriesModel) {
            typedModel = (TypedTimeSeriesModel)this.model;
        }
        for (int i = 0; i < this.model.getNrOfAreas(); ++i) {
            if (!this.model.isAreaVisible(i)) continue;
            for (int j = 0; j < this.model.getAreaSize(i); ++j) {
                Object dataSet;
                Object graph = this.model.getGraph(i, j, 0L);
                if (graph instanceof LineGraphVirtualDataSet) {
                    dataSet = (LineGraphVirtualDataSet)graph;
                    overallWork += ((LineGraphVirtualDataSet)dataSet).getSize();
                    continue;
                }
                if (!(graph instanceof LineGraphAnnotationSet)) continue;
                dataSet = (LineGraphAnnotationSet)graph;
                overallWork += (long)((LineGraphAnnotationSet)dataSet).getSize();
            }
        }
        reporter.setWork(I18n._s((String)"Exporting to XML... (<%> done)"), overallWork);
        File directory = file.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOut, "UTF-8"));
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<!--\n");
        out.write("  <area> elements represent set of graphs displayed together\n");
        out.write("  <graph> represents a graph. Depending on the type, it contains 3 elements:\n");
        out.write("  <point> is a point in a line graph with a time stamp in seconds\n");
        out.write("  <event> is a single event with a time stamp in seconds and a message\n");
        out.write("  <range> is a ranged event with a start and end time in seconds and a message\n");
        out.write("-->\n");
        out.write("<body>\n");
        for (int i = 0; i < this.model.getNrOfAreas(); ++i) {
            if (!this.model.isAreaVisible(i)) continue;
            out.write("  <area name=\"");
            out.write(this.model.getAreaName(i));
            out.write("\">\n");
            for (int j = 0; j < this.model.getAreaSize(i); ++j) {
                Object dataSet;
                Object graph = this.model.getGraph(i, j, 0L);
                if (graph instanceof LineGraphVirtualDataSet) {
                    dataSet = (LineGraphVirtualDataSet)graph;
                    out.write("    <graph name=");
                    out.write(XmlSink.escapeAttribute(this.model.getGraphName(i, j)));
                    out.write(">\n");
                    Iterator<Value2D> it = ((LineGraphVirtualDataSet)dataSet).iterator();
                    double scale = 1.0;
                    if (typedModel != null) {
                        scale = typedModel.getYAxisModel(i, j).getScale();
                    }
                    while (it.hasNext()) {
                        Value2D val = it.next();
                        double x = val.x * 1.0E-6;
                        double y = val.y * scale;
                        out.write("      <point timestamp=\"");
                        out.write(new BigDecimal(x).toPlainString());
                        out.write("\" value=\"");
                        out.write(new BigDecimal(y).toPlainString());
                        out.write("\"/>\n");
                    }
                    out.write("    </graph>\n");
                    continue;
                }
                if (!(graph instanceof LineGraphAnnotationSet)) continue;
                dataSet = (LineGraphAnnotationSet)graph;
                out.write("    <graph name=");
                out.write(XmlSink.escapeAttribute(this.model.getGraphName(i, j)));
                out.write(">\n");
                for (LineGraphAnnotation ann : ((LineGraphAnnotationSet)dataSet).getAllAnnotations()) {
                    double end = ann.getEndValue();
                    double start = ann.getValue() * 1.0E-6;
                    if (end != -1.0) {
                        out.write("      <range from=\"");
                        out.write(new BigDecimal(start).toPlainString());
                        out.write("\" to=\"");
                        out.write(new BigDecimal(end * 1.0E-6).toPlainString());
                    } else {
                        out.write("      <event timestamp=\"");
                        out.write(new BigDecimal(start).toPlainString());
                    }
                    out.write("\" message=");
                    out.write(XmlSink.escapeAttribute(ann.getMessage()));
                    out.write("/>\n");
                }
                out.write("    </graph>\n");
            }
            out.write("  </area>\n");
        }
        out.write("</body>\n");
        out.close();
    }
}

