/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.xml;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.TreeModelItemImpl;
import com.sap.jvm.profiling.presentation.impl.typed.TypedTreeModelImpl;
import com.sap.jvm.profiling.presentation.impl.typed.xml.MappingInfoCollector;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XMLElementConstants;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlModelViewer;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlSink;
import com.sap.jvm.profiling.presentation.impl.typed.xml.exporter.EntryExporter;
import com.sap.jvm.profiling.presentation.impl.typed.xml.exporter.IgnoreExporter;
import com.sap.jvm.profiling.presentation.tree.TreeUtils;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.XmlModelExporter;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.viewer.tree.MultiItem;
import com.sap.jvm.profiling.viewer.tree.NormalItem;
import com.sap.jvm.profiling.viewer.tree.PlaceholderItem;
import com.sap.jvm.profiling.viewer.tree.SkippedChildrenItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class XmlTreeExporter
implements XmlModelExporter,
XMLElementConstants {
    private final TypedTreeModelImpl model;
    private EntryExporter[] entryExporters;
    private final boolean selectedOnly;

    public XmlTreeExporter(TypedTreeModelImpl model, boolean selectedOnly) {
        this.model = model;
        this.selectedOnly = selectedOnly;
        this.entryExporters = XmlModelViewer.createExporters(model.getSpec());
    }

    @Override
    public void writeXml(File file, ProgressReporter reporter) throws IOException {
        reporter.setMessage(I18n._s((String)"Exporting tree to XML format ..."));
        XmlSink sink = new XmlSink();
        MappingInfoCollector mapping = new MappingInfoCollector();
        this.writeContent(sink, mapping, reporter, null);
        XmlSink mappingSink = new XmlSink();
        mappingSink.writeComment("Mapping information");
        mappingSink.beginElement("mappings");
        mapping.exportMappingInfo(mappingSink);
        mapping.clear();
        mappingSink.endElement("mappings");
        if (reporter.isCancelled()) {
            return;
        }
        File directory = file.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fileOut, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<body>");
        mappingSink.writeContent(out);
        sink = new XmlSink();
        this.writeContent(sink, mapping, reporter, out);
        out.write("</body>");
        out.flush();
        out.close();
    }

    private void writeContent(XmlSink sink, MappingInfoCollector mapping, ProgressReporter reporter, Writer writer) throws IOException {
        sink.writeComment("Column headers and entry type descriptions");
        sink.beginElement("headers");
        TypedColumnSpec spec = this.model.getSpec();
        for (int column : this.model.getColumnOrder()) {
            if (this.entryExporters[column] instanceof IgnoreExporter || !this.model.isColumnVisible(column)) continue;
            sink.emptyElement("column", sink.newAttribute("tag", spec.getColumnTag(column)), sink.newAttribute("title", this.model.getColumnText(column)), sink.newAttribute("info", this.model.getColumnToolTip(column)));
        }
        sink.endElement("headers");
        TreeUtils.prepareForExport(this.model, this.selectedOnly);
        sink.writeComment("The tree items");
        sink.beginElement("root");
        this.writeItems(this.model.getRootItems(), 0, sink, mapping, reporter, writer);
        sink.endElement("root");
        if (writer != null) {
            sink.writeContent(writer);
        }
        sink.clear();
    }

    private int writeItems(TreeModelItemImpl[] items, int parentId, XmlSink sink, MappingInfoCollector mapping, ProgressReporter reporter, Writer writer) throws IOException {
        int rowId = parentId;
        for (TreeModelItemImpl item : items) {
            if (reporter.isCancelled()) {
                return 0;
            }
            if (item instanceof PlaceholderItem) continue;
            if (item.isSelected()) {
                if (item instanceof MultiItem) {
                    int startRow = rowId + 1;
                    MultiItem multiItem = (MultiItem)((Object)item);
                    boolean skipped = item instanceof SkippedChildrenItem;
                    this.writeMultiRow(sink, startRow, parentId, skipped, multiItem, mapping, writer);
                    rowId += multiItem.getNodes().length;
                } else {
                    this.writeSingleRow(sink, ++rowId, parentId, item, mapping);
                }
                if (item.isExpanded()) {
                    rowId = this.writeItems(item.getSubsOrChildren(), rowId, sink, mapping, reporter, writer);
                }
            }
            if (writer != null) {
                sink.writeContent(writer);
            }
            sink.clear();
        }
        return rowId;
    }

    private void writeMultiRow(XmlSink sink, int startRow, int startParent, boolean skipped, MultiItem item, MappingInfoCollector mapping, Writer writer) throws IOException {
        ProviderEntry[][] entries = new ProviderEntry[this.model.getNrOfColumns()][];
        for (int column : this.model.getColumnOrder()) {
            if (!this.model.isColumnVisible(column)) continue;
            entries[column] = this.model.getEntriesForMultiItem(item, column);
        }
        int nrOfNodes = item.getNodes().length;
        int lastRow = startParent;
        for (int i = 0; i < nrOfNodes; ++i) {
            int row = startRow + i;
            int parent = skipped ? lastRow : startParent;
            sink.beginElement("row", sink.newAttribute("index", row), sink.newAttribute("parent", parent));
            for (int column : this.model.getColumnOrder()) {
                if (entries[column] == null || entries[column][i] == null) continue;
                this.entryExporters[column].exportEntry(entries[column][i], sink, mapping);
            }
            sink.endElement("row");
            lastRow = row;
            if (writer != null) {
                sink.writeContent(writer);
            }
            sink.clear();
        }
    }

    private void writeSingleRow(XmlSink sink, int row, int parent, TreeModelItemImpl item, MappingInfoCollector mapping) {
        if (parent <= 0) {
            sink.beginElement("row", sink.newAttribute("index", row));
        } else {
            sink.beginElement("row", sink.newAttribute("index", row), sink.newAttribute("parent", parent));
        }
        for (int column : this.model.getColumnOrder()) {
            ProviderEntry entry;
            if (!this.model.isColumnVisible(column) || (entry = this.model.getEntryForNormalItem((NormalItem)((Object)item), column)) == null) continue;
            this.entryExporters[column].exportEntry(entry, sink, mapping);
        }
        sink.endElement("row");
    }
}

