/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.xml;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlSink;
import com.sap.jvm.profiling.presentation.typed.XmlModelExporter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.viewer.graph.ValueSetModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;

public class XmlValueSetExporter
implements XmlModelExporter {
    private final ValueSetModel model;

    public XmlValueSetExporter(ValueSetModel model) {
        this.model = model;
    }

    @Override
    public void writeXml(File file, ProgressReporter reporter) throws IOException {
        int i;
        reporter.setWork(I18n._s((String)"Exporting to XML... (<%> done)"), (long)this.model.getNrOfRows());
        File directory = file.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOut, "UTF-8"));
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<body>\n");
        out.write("  <headers>\n");
        for (i = 0; i < this.model.getNrOfColumns(); ++i) {
            if (!this.model.isColumnVisible(i)) continue;
            out.write("    <column name=");
            out.write(XmlSink.escapeAttribute(this.model.getColumnName(i)));
            out.write("/>\n");
        }
        out.write("  </headers>\n");
        out.write("  <root>\n");
        for (i = 0; i < this.model.getNrOfRows(); ++i) {
            out.write("    <row name=");
            out.write(XmlSink.escapeAttribute(this.model.getRowName(i)));
            out.write(">\n");
            for (int j = 0; j < this.model.getNrOfColumns(); ++j) {
                if (!this.model.isColumnVisible(j)) continue;
                long value = this.model.getValue(i, j);
                out.write("      <quantity value=");
                out.write(XmlSink.escapeAttribute(new BigDecimal(value).toPlainString()));
                out.write("/>\n");
            }
            out.write("    </row>\n");
        }
        out.write("  </root>\n");
        out.write("</body>\n");
        out.close();
    }
}

