/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.xml.exporter;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.presentation.impl.typed.xml.MappingInfoCollector;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XMLElementConstants;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlSink;
import com.sap.jvm.profiling.presentation.impl.typed.xml.exporter.EntryExporter;
import com.sap.jvm.profiling.presentation.typed.entries.CalledMethod;
import com.sap.jvm.profiling.presentation.typed.entries.CallingMethod;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethod;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodPers;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;

public class MethodExporter
implements EntryExporter,
XMLElementConstants {
    @Override
    public void exportEntry(ProviderEntry entry, XmlSink sink, MappingInfoCollector mapping) {
        if (entry instanceof NormalMethodPers) {
            this.exportImpl((NormalMethodPers)entry, sink);
        } else {
            this.exportImpl(entry, sink, mapping);
        }
    }

    private void exportImpl(ProviderEntry entry, XmlSink sink, MappingInfoCollector mapping) {
        MethodObject method = null;
        int line = 0;
        if (entry instanceof CalledMethod) {
            MethodLocation methodLoc = ((CalledMethod)entry).getLocation();
            method = methodLoc.getMethod();
            line = methodLoc.getLineNumber();
        } else if (entry instanceof CallingMethod) {
            MethodLocation methodLoc = ((CallingMethod)entry).getLocation();
            method = methodLoc.getMethod();
            line = methodLoc.getLineNumber();
        } else if (entry instanceof NormalMethod) {
            method = ((NormalMethod)entry).getMethod();
        }
        assert (method != null);
        mapping.addMappingInfo(method);
        if (line != 0) {
            sink.emptyElement("method", sink.newAttribute("id", method.getIndex()), sink.newAttribute("line", line));
        } else {
            sink.emptyElement("method", sink.newAttribute("id", method.getIndex()));
        }
    }

    private void exportImpl(NormalMethodPers entry, XmlSink sink) {
        sink.inlineElement("method-name", entry.getFullName());
    }
}

