/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.xml.exporter;

import com.sap.jvm.profiling.presentation.impl.typed.xml.MappingInfoCollector;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XMLElementConstants;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlSink;
import com.sap.jvm.profiling.presentation.impl.typed.xml.exporter.EntryExporter;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntry;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntryPers;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.snapshot.filter.ProfilingFilterStoreEntry;

public class NormalFilterEntryExporter
implements EntryExporter,
XMLElementConstants {
    @Override
    public void exportEntry(ProviderEntry entry, XmlSink sink, MappingInfoCollector mapping) {
        if (entry instanceof NormalFilterEntryPers) {
            this.exportImpl((NormalFilterEntryPers)entry, sink);
        } else {
            this.exportImpl((NormalFilterEntry)entry, sink);
        }
    }

    private void exportImpl(NormalFilterEntry filterEntry, XmlSink sink) {
        ProfilingFilterStoreEntry entry = filterEntry.getEntry();
        if (entry == null) {
            sink.emptyElement("filter-entry", sink.newAttribute("name", "[none]"));
            return;
        }
        String name = entry.getName();
        String type = "";
        type = entry.isDirectory() ? "directory" : (entry.isClassFilter() ? "classFilter" : "methodFilter");
        sink.emptyElement("filter-entry", sink.newAttribute("name", name), sink.newAttribute("type", type));
    }

    private void exportImpl(NormalFilterEntryPers entry, XmlSink sink) {
        String name = entry.getEntryName();
        if (name == null) {
            sink.emptyElement("filter-entry", sink.newAttribute("name", "[none]"));
            return;
        }
        String type = "";
        type = entry.isDirectory() ? "directory" : (entry.isClassFilter() ? "classFilter" : "methodFilter");
        sink.emptyElement("filter-entry", sink.newAttribute("name", name), sink.newAttribute("type", type));
    }
}

