/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.xml.exporter;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.method.parameters.ClassParameter;
import com.sap.jvm.profiling.method.parameters.MethodParameter;
import com.sap.jvm.profiling.presentation.impl.typed.xml.MappingInfoCollector;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XMLElementConstants;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlSink;
import com.sap.jvm.profiling.presentation.impl.typed.xml.exporter.EntryExporter;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterValue;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;

public class NormalParameterValueExporter
implements EntryExporter,
XMLElementConstants {
    @Override
    public void exportEntry(ProviderEntry entry, XmlSink sink, MappingInfoCollector mapping) {
        NormalParameterValue paramEntry = (NormalParameterValue)entry;
        if (paramEntry.getValue() instanceof ClassParameter) {
            ClassObject classObj = ((ClassParameter)paramEntry.getValue()).getValue();
            mapping.addMappingInfo(classObj);
            sink.emptyElement("parameter-value", sink.newAttribute("class-id", classObj.getIndex()));
        } else if (paramEntry.getValue() instanceof MethodParameter) {
            MethodParameter param = (MethodParameter)paramEntry.getValue();
            MethodObject methodObj = param.getMethod();
            ClassObject receiver = param.getReceiverClass();
            mapping.addMappingInfo(methodObj);
            mapping.addMappingInfo(receiver);
            sink.emptyElement("parameter-value", sink.newAttribute("method-id", methodObj.getIndex()), sink.newAttribute("reciever-class-id", receiver.getIndex()));
        } else {
            String value = paramEntry.getDisplayValue();
            sink.emptyElement("parameter-value", sink.newAttribute("value", value));
        }
    }
}

