/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.resource;

import com.sap.jvm.profiling.presentation.impl.resource.CreationContextProviderImpl;
import com.sap.jvm.profiling.presentation.impl.resource.context.NullCreationContext;
import com.sap.jvm.profiling.presentation.resource.CreationContext;
import com.sap.jvm.profiling.presentation.resource.CreationContextProvider;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreatorFactory;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.lang.ref.WeakReference;

public final class CreationContextFactory {
    private static WeakReference<CreationContextProvider> providerRef = new WeakReference<Object>(null);
    private static WeakReference<ModelViewer> viewerRef = new WeakReference<Object>(null);
    private static WeakReference<RendererThemeSpec> themeRef = new WeakReference<Object>(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CreationContextProvider getProvider(ModelViewer viewer, RendererThemeSpec theme) {
        Class<CreationContextFactory> clazz = CreationContextFactory.class;
        synchronized (CreationContextFactory.class) {
            CreationContextProvider lastProvider = (CreationContextProvider)providerRef.get();
            ModelViewer lastViewer = (ModelViewer)viewerRef.get();
            RendererThemeSpec lastTheme = (RendererThemeSpec)themeRef.get();
            if (lastProvider != null && lastViewer == viewer && theme.equals(lastTheme)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return lastProvider;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                CreationContextProviderImpl provider = new CreationContextProviderImpl(viewer, theme);
                Class<CreationContextFactory> clazz2 = CreationContextFactory.class;
                synchronized (CreationContextFactory.class) {
                    providerRef = new WeakReference<CreationContextProviderImpl>(provider);
                    viewerRef = new WeakReference<ModelViewer>(viewer);
                    themeRef = new WeakReference<RendererThemeSpec>(theme);
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return provider;
                }
            }
            catch (IOException e) {
                Trace.error((Throwable)e, (String)"Could not create creation context provider");
                return new CreationContextProvider(){

                    @Override
                    public CreationContext get(Snapshot snapshot, ResourceName sourceName, ResourceName destName) {
                        return new NullCreationContext();
                    }
                };
            }
        }
    }

    public static void registerElementContextCreatorFactory(ElementContextCreatorFactory factory) {
        CreationContextProviderImpl.registerElementContextCreatorFactory(factory);
    }
}

