/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.table;

import com.sap.jvm.profiling.presentation.impl.csv.CSVModelViewer;
import com.sap.jvm.profiling.presentation.impl.csv.CSVTableExporter;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelModelViewer;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelTableExporter;
import com.sap.jvm.profiling.presentation.impl.html.HTMLModelViewer;
import com.sap.jvm.profiling.presentation.impl.html.HTMLTableExporter;
import com.sap.jvm.profiling.presentation.impl.typed.TypedTableModelImpl;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTableProvider;
import com.sap.jvm.profiling.viewer.CSVModelExporter;
import com.sap.jvm.profiling.viewer.ExcelModelExporter;
import com.sap.jvm.profiling.viewer.HTMLModelExporter;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.profiling.viewer.table.TableModel;
import java.util.ArrayList;

public class TableUtils {
    public static HTMLModelExporter getHTMLExporter(TableModel model, OSThemeSpec osTheme, boolean selectedOnly, int[] columnsToSum) {
        HTMLModelViewer viewer = new HTMLModelViewer();
        TableModel copy = model.copy(viewer);
        return new HTMLTableExporter(copy, osTheme, selectedOnly, columnsToSum);
    }

    public static CSVModelExporter getCSVExporter(TableModel model, boolean selectedOnly) {
        CSVModelViewer viewer = new CSVModelViewer();
        TableModel copy = model.copy(viewer);
        return new CSVTableExporter(copy, selectedOnly);
    }

    public static ExcelModelExporter getExcelExporter(TableModel model, boolean selectedOnly) {
        ExcelModelViewer viewer = new ExcelModelViewer();
        TableModel copy = model.copy(viewer);
        return new ExcelTableExporter(copy, selectedOnly);
    }

    public static TypedTableModel forProvider(TypedTableProvider<?> provider) {
        return new TypedTableModelImpl(provider, provider.getResourceName());
    }

    public static int[] getVisibleColumns(TableModel model) {
        int nrOfVisible = 0;
        for (int i = 0; i < model.getNrOfColumns(); ++i) {
            if (!model.isColumnVisible(i)) continue;
            ++nrOfVisible;
        }
        int[] result = new int[nrOfVisible];
        int offset = 0;
        for (int i = 0; i < model.getNrOfColumns(); ++i) {
            if (!model.isColumnVisible(i)) continue;
            result[offset] = i;
            ++offset;
        }
        return result;
    }

    public static String getSelectionAsText(TableModel model, int[] columns, boolean asValue, boolean includeColumnTitles) {
        StringBuilder text = new StringBuilder();
        String lineSep = System.getProperty("line.separator", "\n");
        ArrayList<String> entries = new ArrayList<String>();
        if (includeColumnTitles) {
            for (int i = 0; i < columns.length; ++i) {
                entries.add(model.getColumnText(columns[i]));
            }
        }
        for (int itemId : model.getSelectedItemIds()) {
            for (int i = 0; i < columns.length; ++i) {
                if (asValue) {
                    entries.add(model.getRendererForItem(itemId, columns[i]).asValueString().trim());
                    continue;
                }
                entries.add(model.getRendererForItem(itemId, columns[i]).asString().trim());
            }
        }
        int[] maxWiths = new int[columns.length];
        for (int i = 0; i < maxWiths.length; ++i) {
            for (int j = 0; j < entries.size(); j += maxWiths.length) {
                maxWiths[i] = Math.max(maxWiths[i], ((String)entries.get(i + j)).length());
            }
        }
        for (int j = 0; j < entries.size(); j += maxWiths.length) {
            for (int i = 0; i < maxWiths.length; ++i) {
                String str = (String)entries.get(i + j);
                entries.set(i + j, null);
                text.append(str);
                if (i == maxWiths.length - 1) {
                    text.append(lineSep);
                    continue;
                }
                for (int k = str.length(); k <= maxWiths[i]; ++k) {
                    text.append(' ');
                }
            }
        }
        entries.clear();
        return text.toString();
    }
}

