/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.tree;

import com.sap.jvm.profiling.presentation.impl.csv.CSVModelViewer;
import com.sap.jvm.profiling.presentation.impl.csv.CSVTreeExporter;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelModelViewer;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelTreeExporter;
import com.sap.jvm.profiling.presentation.impl.html.HTMLModelViewer;
import com.sap.jvm.profiling.presentation.impl.html.HTMLTreeExporter;
import com.sap.jvm.profiling.viewer.CSVModelExporter;
import com.sap.jvm.profiling.viewer.ExcelModelExporter;
import com.sap.jvm.profiling.viewer.HTMLModelExporter;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.profiling.viewer.tree.TreeModel;
import com.sap.jvm.profiling.viewer.tree.TreeModelForwardIterator;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import java.util.ArrayList;

public class TreeUtils {
    public static CSVModelExporter getCSVExporter(TreeModel model, boolean selectedOnly) {
        CSVModelViewer viewer = new CSVModelViewer();
        TreeModel copy = model.copy(viewer);
        return new CSVTreeExporter(copy, selectedOnly);
    }

    public static HTMLModelExporter getHTMLExporter(TreeModel model, OSThemeSpec osTheme, boolean selectedOnly) {
        HTMLModelViewer viewer = new HTMLModelViewer();
        TreeModel copy = model.copy(viewer);
        return new HTMLTreeExporter(copy, osTheme, selectedOnly);
    }

    public static ExcelModelExporter getExcelExporter(TreeModel model, boolean selectedOnly) {
        ExcelModelViewer viewer = new ExcelModelViewer();
        TreeModel copy = model.copy(viewer);
        return new ExcelTreeExporter(copy, selectedOnly);
    }

    public static void prepareForExport(TreeModel model, boolean selectedOnly) {
        ArrayList<TreeModelItem> selected = new ArrayList<TreeModelItem>();
        if (selectedOnly) {
            for (TreeModelItem root : model.getRootItems()) {
                TreeUtils.closeNonSelected(model, root, selected);
            }
        } else {
            TreeModelForwardIterator it = new TreeModelForwardIterator(model);
            while (it.hasNext()) {
                selected.add(it.next());
            }
        }
        model.setSelection(selected.toArray(new TreeModelItem[selected.size()]));
    }

    private static boolean closeNonSelected(TreeModel model, TreeModelItem item, ArrayList<TreeModelItem> selected) {
        boolean result = item.isSelected();
        if (result) {
            selected.add(item);
        }
        for (TreeModelItem child : item.getSubsOrChildren()) {
            if (!TreeUtils.closeNonSelected(model, child, selected)) continue;
            selected.add(item);
            result = true;
        }
        if (!result) {
            model.collapseItem(item);
        }
        return result;
    }

    public static int[] getVisibleColumns(TreeModel model) {
        int nrOfVisible = 0;
        for (int i = 0; i < model.getNrOfColumns(); ++i) {
            if (!model.isColumnVisible(i)) continue;
            ++nrOfVisible;
        }
        int[] result = new int[nrOfVisible];
        int offset = 0;
        for (int i = 0; i < model.getNrOfColumns(); ++i) {
            if (!model.isColumnVisible(i)) continue;
            result[offset] = i;
            ++offset;
        }
        return result;
    }

    public static String getSelectionAsText(TreeModel model, int[] columns, boolean asValue, boolean includeColumnTitles) {
        StringBuilder text = new StringBuilder();
        String lineSep = System.getProperty("line.separator", "\n");
        ArrayList<String> entries = new ArrayList<String>();
        if (includeColumnTitles) {
            for (int i = 0; i < columns.length; ++i) {
                entries.add(model.getColumnText(columns[i]));
            }
        }
        for (TreeModelItem item : model.getSelectedItems()) {
            for (int i = 0; i < columns.length; ++i) {
                String str = asValue ? model.getRendererForItem(item, columns[i]).asValueString().trim() : model.getRendererForItem(item, columns[i]).asString().trim();
                if (i == 0) {
                    StringBuilder prefix = new StringBuilder();
                    for (TreeModelItem parent = item.getParent(); parent != null; parent = parent.getParent()) {
                        prefix.append(' ');
                    }
                    entries.add(prefix + str);
                    continue;
                }
                entries.add(str);
            }
        }
        int[] maxWiths = new int[columns.length];
        for (int i = 0; i < maxWiths.length; ++i) {
            for (int j = 0; j < entries.size(); j += maxWiths.length) {
                maxWiths[i] = Math.max(maxWiths[i], ((String)entries.get(i + j)).length());
            }
        }
        for (int j = 0; j < entries.size(); j += maxWiths.length) {
            for (int i = 0; i < maxWiths.length; ++i) {
                String str = (String)entries.get(i + j);
                entries.set(i + j, null);
                text.append(str);
                if (i == maxWiths.length - 1) {
                    text.append(lineSep);
                    continue;
                }
                for (int k = str.length(); k <= maxWiths[i]; ++k) {
                    text.append(' ');
                }
            }
        }
        entries.clear();
        return text.toString();
    }
}

