/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.ProviderResource;
import com.sap.jvm.profiling.presentation.typed.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.entries.CpuTime;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.FileDescriptor;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsage;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytesPerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfClosedFiles;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfClosedSockets;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfInvocations;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjects;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOpenedFiles;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOpenedSockets;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfReadWriteRoundtrips;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfRoundtrips;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfWriteReadRoundtrips;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.util.column.Column;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;

public abstract class AbstractTableBasedProvider
extends ProviderResource {
    private final EntryContext context;
    private ColumnContext[] columnContexts;

    protected AbstractTableBasedProvider(ResourceName name) {
        super(name);
        this.context = new EntryContext(name.getSession());
    }

    public abstract TypedColumnSpec getColumnSpec();

    public abstract ProviderEntry getEntry(int var1, int var2);

    public abstract int getNrOfRows();

    public abstract Snapshot getSnapshot();

    public Column getColumn(int columnIndex) {
        return null;
    }

    protected final void initializeContext(ProgressReporter reporter) throws OperationCanceledException {
        this.columnContexts = new ColumnContext[this.getColumnSpec().getNrOfColumns()];
        long maxBytes = -1L;
        long maxObjects = -1L;
        long maxInvocations = -1L;
        long maxOpenedFiles = -1L;
        long maxClosedFiles = -1L;
        long maxOpenedSockets = -1L;
        long maxClosedSockets = -1L;
        long maxFd = -1L;
        long maxBytesPerSecond = -1L;
        long maxCpuTime = -1L;
        long maxElapsedTime = -1L;
        long maxReadWriteRoundtrips = -1L;
        long maxWriteReadRoundtrips = -1L;
        long maxRoundtrips = -1L;
        long maxMemoryUsage = -1L;
        for (int i = 0; i < this.getColumnSpec().getNrOfColumns(); ++i) {
            reporter.reportNextOrThrow();
            this.columnContexts[i] = new ColumnContext();
            this.columnContexts[i].column = this.getColumn(i);
            this.columnContexts[i].noPercentageBars = this.getColumnSpec().getNoPercentageBarsFlag(i);
            maxBytes = Math.max(maxBytes, this.getMaxQuantity(i, NrOfBytes.class));
            maxObjects = Math.max(maxObjects, this.getMaxQuantity(i, NrOfObjects.class));
            maxInvocations = Math.max(maxInvocations, this.getMaxQuantity(i, NrOfInvocations.class));
            maxOpenedFiles = Math.max(maxOpenedFiles, this.getMaxQuantity(i, NrOfOpenedFiles.class));
            maxClosedFiles = Math.max(maxClosedFiles, this.getMaxQuantity(i, NrOfClosedFiles.class));
            maxOpenedSockets = Math.max(maxOpenedSockets, this.getMaxQuantity(i, NrOfOpenedSockets.class));
            maxClosedSockets = Math.max(maxClosedSockets, this.getMaxQuantity(i, NrOfClosedSockets.class));
            maxFd = Math.max(maxFd, this.getMaxQuantity(i, FileDescriptor.class));
            maxBytesPerSecond = Math.max(maxBytesPerSecond, this.getMaxQuantity(i, NrOfBytesPerSecond.class));
            maxCpuTime = Math.max(maxCpuTime, this.getMaxQuantity(i, CpuTime.class));
            maxElapsedTime = Math.max(maxElapsedTime, this.getMaxQuantity(i, ElapsedTime.class));
            maxReadWriteRoundtrips = Math.max(maxReadWriteRoundtrips, this.getMaxQuantity(i, NrOfReadWriteRoundtrips.class));
            maxWriteReadRoundtrips = Math.max(maxWriteReadRoundtrips, this.getMaxQuantity(i, NrOfWriteReadRoundtrips.class));
            maxRoundtrips = Math.max(maxRoundtrips, this.getMaxQuantity(i, NrOfRoundtrips.class));
            maxMemoryUsage = Math.max(maxMemoryUsage, this.getMaxQuantity(i, MemoryUsage.class));
        }
        this.context.setMaxBytes(maxBytes);
        this.context.setMaxObjects(maxObjects);
        this.context.setMaxInvocations(maxInvocations);
        this.context.setMaxOpenedFiles(maxOpenedFiles);
        this.context.setMaxClosedFiles(maxOpenedFiles);
        this.context.setMaxOpenedSockets(maxOpenedSockets);
        this.context.setMaxClosedSockets(maxOpenedSockets);
        this.context.setMaxFd(maxFd);
        this.context.setMaxBytesPerSecond(maxBytesPerSecond);
        this.context.setMaxCpuTime(maxCpuTime);
        this.context.setMaxElapsedTime(maxElapsedTime);
        this.context.setTracedMethods(ProviderUtils.getTraceMethods(this.getSnapshot()));
        this.context.setMaxReadWriteRoundtrips(maxReadWriteRoundtrips);
        this.context.setMaxWriteReadRoundtrips(maxWriteReadRoundtrips);
        this.context.setMaxRoundtrips(maxRoundtrips);
        this.context.setMaxMemoryUsage(maxMemoryUsage);
    }

    private long getMaxQuantity(int columnIndex, Class<? extends Quantity> clazz) {
        long max = 0L;
        if (this.getColumnSpec().getColumnType(columnIndex) == clazz) {
            Column column = this.getColumn(columnIndex);
            if (column instanceof LongValueColumn) {
                return ((LongValueColumn)column).getMaxValue();
            }
            for (int i = this.getNrOfRows() - 1; i >= 0; --i) {
                Quantity quantity = (Quantity)this.getEntry(i, columnIndex);
                if (quantity == null) continue;
                max = Math.max(max, quantity.getQuantity());
            }
        }
        return max;
    }

    @Override
    public final EntryContext getEntryContext() {
        assert (this.context != null);
        return this.context;
    }

    public ColumnContext getColumnContext(int column) {
        return this.columnContexts[column];
    }

    public ColumnContext[] getColumnContexts() {
        return (ColumnContext[])this.columnContexts.clone();
    }

    public void setColumnContext(int column, ColumnContext columnContext) {
        this.columnContexts[column] = columnContext;
    }
}

