/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.SessionAssociated;
import com.sap.jvm.profiling.core.type.MethodObject;
import java.util.HashSet;

public final class EntryContext
implements SessionAssociated {
    private long maxBytes;
    private long maxObjects;
    private long maxInvocations;
    private long maxOpenedFiles;
    private long maxClosedFiles;
    private long maxOpenedSockets;
    private long maxClosedSockets;
    private long maxFd;
    private long maxBytesPerSecond;
    private long maxCpuTime;
    private long maxElapsedTime;
    private long maxMonitorBlockedTime;
    private long maxReadWriteRoundtrips;
    private long maxWriteReadRoundtrips;
    private long maxRoundtrips;
    private long maxMemoryUsage;
    private HashSet<MethodObject> tracedMethods;
    private long maxMonitorBlockedEvents;
    private final ProfilingSession session;

    public EntryContext(ProfilingSession session) {
        this.session = session;
        this.maxBytes = -1L;
        this.maxObjects = -1L;
        this.maxInvocations = -1L;
        this.maxOpenedFiles = -1L;
        this.maxClosedFiles = -1L;
        this.maxOpenedSockets = -1L;
        this.maxClosedSockets = -1L;
        this.maxFd = -1L;
        this.maxBytesPerSecond = -1L;
        this.maxCpuTime = -1L;
        this.maxElapsedTime = -1L;
        this.maxMonitorBlockedTime = -1L;
        this.maxMonitorBlockedEvents = -1L;
        this.maxReadWriteRoundtrips = -1L;
        this.maxWriteReadRoundtrips = -1L;
        this.maxRoundtrips = -1L;
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    public void setMaxBytes(long maxBytes) {
        this.maxBytes = maxBytes;
    }

    public long getMaxObjects() {
        return this.maxObjects;
    }

    public void setMaxObjects(long maxObjects) {
        this.maxObjects = maxObjects;
    }

    public long getMaxInvocations() {
        return this.maxInvocations;
    }

    public void setMaxInvocations(long maxInvocations) {
        this.maxInvocations = maxInvocations;
    }

    public long getMaxOpenedFiles() {
        return this.maxOpenedFiles;
    }

    public void setMaxOpenedFiles(long maxOpenedFiles) {
        this.maxOpenedFiles = maxOpenedFiles;
    }

    public long getMaxClosedFiles() {
        return this.maxClosedFiles;
    }

    public void setMaxClosedFiles(long maxClosedFiles) {
        this.maxClosedFiles = maxClosedFiles;
    }

    public long getMaxOpenedSockets() {
        return this.maxOpenedSockets;
    }

    public void setMaxOpenedSockets(long maxOpenedSockets) {
        this.maxOpenedSockets = maxOpenedSockets;
    }

    public long getMaxClosedSockets() {
        return this.maxClosedSockets;
    }

    public void setMaxClosedSockets(long maxClosedSockets) {
        this.maxClosedSockets = maxClosedSockets;
    }

    public long getMaxFd() {
        return this.maxFd;
    }

    public void setMaxFd(long maxFd) {
        this.maxFd = maxFd;
    }

    public long getMaxBytesPerSecond() {
        return this.maxBytesPerSecond;
    }

    public void setMaxBytesPerSecond(long maxBytesPerSecond) {
        this.maxBytesPerSecond = maxBytesPerSecond;
    }

    public long getMaxCpuTime() {
        return this.maxCpuTime;
    }

    public void setMaxCpuTime(long maxCpuTime) {
        this.maxCpuTime = maxCpuTime;
    }

    public long getMaxElapsedTime() {
        return this.maxElapsedTime;
    }

    public void setMaxElapsedTime(long maxElapsedTime) {
        this.maxElapsedTime = maxElapsedTime;
    }

    public long getMaxBlockedTime() {
        return this.maxMonitorBlockedTime;
    }

    public void setMaxBlockedTime(long maxMonitorBlockedTime) {
        this.maxMonitorBlockedTime = maxMonitorBlockedTime;
    }

    public boolean isTraceMethod(MethodObject method) {
        if (this.tracedMethods != null) {
            return this.tracedMethods.contains(method);
        }
        return false;
    }

    public void setTracedMethods(HashSet<MethodObject> tracedMethods) {
        this.tracedMethods = tracedMethods;
    }

    public long getMaxMonitorBlockedEvents() {
        return this.maxMonitorBlockedEvents;
    }

    public void setMaxMonitorBlockedEvents(long maxMonitorBlockedEvents) {
        this.maxMonitorBlockedEvents = maxMonitorBlockedEvents;
    }

    public long getMaxReadWriteRoundtrips() {
        return this.maxReadWriteRoundtrips;
    }

    public void setMaxReadWriteRoundtrips(long maxReadWriteRoundtrips) {
        this.maxReadWriteRoundtrips = maxReadWriteRoundtrips;
    }

    public long getMaxWriteReadRoundtrips() {
        return this.maxWriteReadRoundtrips;
    }

    public void setMaxWriteReadRoundtrips(long maxWriteReadRoundtrips) {
        this.maxWriteReadRoundtrips = maxWriteReadRoundtrips;
    }

    public long getMaxRoundtrips() {
        return this.maxRoundtrips;
    }

    public void setMaxRoundtrips(long maxRoundtrips) {
        this.maxRoundtrips = maxRoundtrips;
    }

    public long getMaxMemoryUsage() {
        return this.maxMemoryUsage;
    }

    public void setMaxMemoryUsage(long maxMemoryUsage) {
        this.maxMemoryUsage = maxMemoryUsage;
    }

    public ProfilingSession getSession() {
        return this.session;
    }
}

