/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.i18n.DurationFormat;
import com.sap.jvm.profiling.presentation.typed.MethodFormat;
import com.sap.jvm.profiling.presentation.typed.MethodIconFormat;
import com.sap.jvm.profiling.presentation.typed.NrOfBytesFormat;
import com.sap.jvm.profiling.viewer.OSThemeSpec;

public final class RendererThemeSpec {
    private final String name;
    private final OSThemeSpec osTheme;
    private MethodIconFormat methodIconFormat;
    private NrOfBytesFormat nrOfBytesFormat;
    private DurationFormat elapsedTimeFormat;
    private DurationFormat blockedTimeFormat;
    private DurationFormat cpuTimeFormat;
    private DurationFormat sampleTimeFormat;
    private MethodFormat methodFormat;
    private boolean hasSourceCode;

    public RendererThemeSpec(OSThemeSpec osTheme) {
        this("default", osTheme);
    }

    public RendererThemeSpec(String name, OSThemeSpec osTheme) {
        this.name = name;
        this.osTheme = osTheme;
        this.nrOfBytesFormat = NrOfBytesFormat.BEST_UNIT;
        this.elapsedTimeFormat = DurationFormat.TOTAL_ADAPITVE;
        this.blockedTimeFormat = DurationFormat.TOTAL_ADAPITVE;
        this.cpuTimeFormat = DurationFormat.TOTAL_ADAPITVE;
        this.sampleTimeFormat = DurationFormat.TOTAL_ADAPITVE;
        this.methodFormat = MethodFormat.SHORT_SIGNATURE_AND_RETURN_TYPE;
    }

    public String getName() {
        return this.name;
    }

    public OSThemeSpec getOsTheme() {
        return this.osTheme;
    }

    public MethodIconFormat getMethodIconFormat() {
        return this.methodIconFormat;
    }

    public void setMethodIconFormat(MethodIconFormat methodIconFormat) {
        this.methodIconFormat = methodIconFormat;
    }

    public NrOfBytesFormat getNrOfBytesFormat() {
        return this.nrOfBytesFormat;
    }

    public void setNrOfBytesFormat(NrOfBytesFormat nrOfBytesFormat) {
        this.nrOfBytesFormat = nrOfBytesFormat;
    }

    public DurationFormat getElapsedTimeFormat() {
        return this.elapsedTimeFormat;
    }

    public void setElapsedTimeFormat(DurationFormat elapsedTimeFormat) {
        this.elapsedTimeFormat = elapsedTimeFormat;
    }

    public DurationFormat getBlockedTimeFormat() {
        return this.blockedTimeFormat;
    }

    public void setBlockedTimeFormat(DurationFormat blockedTimeFormat) {
        this.blockedTimeFormat = blockedTimeFormat;
    }

    public DurationFormat getCpuTimeFormat() {
        return this.cpuTimeFormat;
    }

    public void setCpuTimeFormat(DurationFormat cpuTimeFormat) {
        this.cpuTimeFormat = cpuTimeFormat;
    }

    public DurationFormat getSampleTimeFormat() {
        return this.sampleTimeFormat;
    }

    public void setSampleTimeFormat(DurationFormat sampleTimeFormat) {
        this.sampleTimeFormat = sampleTimeFormat;
    }

    public MethodFormat getMethodFormat() {
        return this.methodFormat;
    }

    public void setMethodFormat(MethodFormat methodFormat) {
        this.methodFormat = methodFormat;
    }

    public RendererThemeSpec copy() {
        RendererThemeSpec result = new RendererThemeSpec(this.name, this.osTheme);
        result.setMethodIconFormat(this.methodIconFormat);
        result.setNrOfBytesFormat(this.nrOfBytesFormat);
        result.setElapsedTimeFormat(this.elapsedTimeFormat);
        result.setBlockedTimeFormat(this.blockedTimeFormat);
        result.setCpuTimeFormat(this.cpuTimeFormat);
        result.setSampleTimeFormat(this.sampleTimeFormat);
        result.setMethodFormat(this.methodFormat);
        result.setHasSourceCode(this.hasSourceCode);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RendererThemeSpec)) {
            return false;
        }
        RendererThemeSpec other = (RendererThemeSpec)obj;
        if (this.methodIconFormat != other.methodIconFormat) {
            return false;
        }
        if (this.nrOfBytesFormat != other.nrOfBytesFormat) {
            return false;
        }
        if (this.elapsedTimeFormat != other.elapsedTimeFormat) {
            return false;
        }
        if (this.blockedTimeFormat != other.blockedTimeFormat) {
            return false;
        }
        if (this.cpuTimeFormat != other.cpuTimeFormat) {
            return false;
        }
        if (this.sampleTimeFormat != other.sampleTimeFormat) {
            return false;
        }
        if (this.methodFormat != other.methodFormat) {
            return false;
        }
        if (!this.osTheme.equals(other.osTheme)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Renderer theme: " + this.name;
    }

    public boolean hasSourceCode() {
        return this.hasSourceCode;
    }

    public void setHasSourceCode(boolean hasSourceCode) {
        this.hasSourceCode = hasSourceCode;
    }
}

