/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadAnnotationContext;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.resource.SnapshotResouceUtil;

public final class ThreadAnnotationUtil {
    public static ThreadAnnotationContext getContext(ResourceName name) {
        int slot = SnapshotResouceUtil.getAnnotationSlot(name);
        ProfilingSession session = name.getSession();
        UTF8String key = session.getAnnotationKey(slot);
        UTF8String desc = session.getAnnotationDescription(slot);
        return new ThreadAnnotationContext(slot, key == null ? null : key.toString(), desc == null ? null : desc.toString());
    }

    public static String getKey(ResourceName name) {
        ProfilingSession session = name.getSession();
        int slot = SnapshotResouceUtil.getAnnotationSlot(name);
        return session.getAnnotationKey(slot).toString();
    }

    public static String getAnnotationTitle(ResourceName name) {
        return ThreadAnnotationUtil.getAnnotationTitle(SnapshotResouceUtil.getAnnotationSlot(name), ThreadAnnotationUtil.getKey(name));
    }

    public static String getAnnotationTitle(int slot, String key) {
        switch (slot) {
            case 0: {
                return I18n._s((String)"Users");
            }
            case 3: {
                return I18n._s((String)"Applications");
            }
            case 1: {
                return I18n._s((String)"Sessions");
            }
            case 2: {
                return I18n._s((String)"Requests");
            }
            case 5: {
                return I18n._s((String)"Tenants");
            }
        }
        return I18n._ss((String)"A statistic on {0}s. Ex: Requests Statistic", (String)"{0} Statistic", (Object[])new Object[]{key});
    }

    public static String getBlockedAnnotationTitle(ResourceName name) {
        return ThreadAnnotationUtil.getBlockedAnnotationTitle(SnapshotResouceUtil.getAnnotationSlot(name), ThreadAnnotationUtil.getKey(name));
    }

    public static String getBlockedAnnotationTitle(int slot, String key) {
        switch (slot) {
            case 0: {
                return I18n._s((String)"Blocked Users");
            }
            case 3: {
                return I18n._s((String)"Blocked Applications");
            }
            case 1: {
                return I18n._s((String)"Blocked Sessions");
            }
            case 2: {
                return I18n._s((String)"Blocked Requests");
            }
            case 5: {
                return I18n._s((String)"Blocked Tenants");
            }
        }
        return I18n._ss((String)"A statistic on blocked {0}s. Ex: Blocked Requests Statistic", (String)"Blocked {0} Statistic", (Object[])new Object[]{key});
    }

    public static String getBlockingAnnotationTitle(ResourceName name) {
        return ThreadAnnotationUtil.getBlockingAnnotationTitle(SnapshotResouceUtil.getAnnotationSlot(name), ThreadAnnotationUtil.getKey(name));
    }

    public static String getBlockingAnnotationTitle(int slot, String key) {
        switch (slot) {
            case 0: {
                return I18n._s((String)"Blocking Users");
            }
            case 3: {
                return I18n._s((String)"Blocking Applications");
            }
            case 1: {
                return I18n._s((String)"Blocking Sessions");
            }
            case 2: {
                return I18n._s((String)"Blocking Requests");
            }
            case 5: {
                return I18n._s((String)"Blocking Tenants");
            }
        }
        return I18n._ss((String)"A statistic on blocking {0}s. Ex: Blocking Requests Statistic", (String)"Blocking {0} Statistic", (Object[])new Object[]{key});
    }

    public static String getAnnotationIconKey(ResourceName name) {
        return ThreadAnnotationUtil.getAnnotationIconKey(SnapshotResouceUtil.getAnnotationSlot(name));
    }

    public static String getAnnotationIconKey(int slot) {
        switch (slot) {
            case 0: {
                return "views/user_statistic.gif";
            }
            case 3: {
                return "views/application_statistic.gif";
            }
            case 1: {
                return "views/session_statistic.gif";
            }
            case 2: {
                return "views/request_statistic.gif";
            }
            case 5: {
                return "views/tenant_statistic.png";
            }
        }
        return "views/generic_annotation_statistic.gif";
    }
}

