/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.presentation.typed.SortOrder;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class TypedColumnSpec {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int SUM = 4;
    public static final int SEARCH = 8;
    public static final int FIFTH_SORT = 16;
    public static final int THIRD_SORT = 32;
    public static final int SECOND_SORT = 64;
    public static final int FOURTH_SORT = 128;
    public static final int FIRST_SORT = 256;
    public static final int FIXED = 512;
    public static final int COMPARE_KEY = 1024;
    public static final int NO_PERCENTAGE_BARS = 2048;
    public static final int AVERAGE = 4096;
    public static final int MIN_MAX = 8192;
    public static final int ENUMERABLE = 16384;
    public static final int NON_ZERO = 32768;
    private static final int SORT_COLUMN_MASK = 496;
    private final List<String> columnTexts = new ArrayList<String>();
    private final List<String> columnToolTips = new ArrayList<String>();
    private final List<Direction> defaultSortDirections = new ArrayList<Direction>();
    private final List<SortOrderHelper> defaultSortOrder = new ArrayList<SortOrderHelper>();
    private final List<Class<?>> columnTypes = new ArrayList();
    private final List<Boolean> noPercentageBars = new ArrayList<Boolean>();
    private final List<String> columnTags = new ArrayList<String>();
    private final List<Integer> columnsToSum = new ArrayList<Integer>();
    private final List<Integer> columnsToAverage = new ArrayList<Integer>();
    private final List<Integer> columnsToMinMax = new ArrayList<Integer>();
    private final List<Integer> columnsToNonZero = new ArrayList<Integer>();
    private final List<Integer> columnsToEnumerate = new ArrayList<Integer>();
    private final List<Integer> columnsToSearch = new ArrayList<Integer>();
    private final List<Integer> columnsFixed = new ArrayList<Integer>();
    private int[] compareKeyColumns;
    private final Map<String, VisibilitySet> visibilitySets = new LinkedHashMap<String, VisibilitySet>();
    private String defaultVisibleSets;

    public TypedColumnSpec(String defaultVisibleSets) {
        this.defaultVisibleSets = defaultVisibleSets;
    }

    public TypedColumnSpec(TypedColumnSpec toCopy) {
        this.columnTexts.addAll(toCopy.columnTexts);
        this.columnToolTips.addAll(toCopy.columnToolTips);
        this.defaultSortDirections.addAll(toCopy.defaultSortDirections);
        this.defaultSortOrder.addAll(toCopy.defaultSortOrder);
        this.columnTypes.addAll(toCopy.columnTypes);
        this.noPercentageBars.addAll(toCopy.noPercentageBars);
        this.columnTags.addAll(toCopy.columnTags);
        this.columnsToSum.addAll(toCopy.columnsToSum);
        this.columnsToAverage.addAll(toCopy.columnsToAverage);
        this.columnsToMinMax.addAll(toCopy.columnsToMinMax);
        this.columnsToNonZero.addAll(toCopy.columnsToNonZero);
        this.columnsToEnumerate.addAll(toCopy.columnsToEnumerate);
        this.columnsToSearch.addAll(toCopy.columnsToSearch);
        this.columnsFixed.addAll(toCopy.columnsFixed);
        this.compareKeyColumns = this.compareKeyColumns == null ? null : (int[])this.compareKeyColumns.clone();
        this.visibilitySets.putAll(toCopy.visibilitySets);
        this.defaultVisibleSets = toCopy.defaultVisibleSets;
    }

    public TypedColumnSpec(String[] columnTexts, String[] columnToolTips, int[] defaultSortDirection, int[] defaultSortOrder, Class<?>[] columnTypes, String[] columnTags, int[] columnsToSum, int[] columnsToSearch, int[] compareKeyColumns, boolean[] noPercentageBars, VisibilitySet[] visibilitySets, String defaultVisibleSets) {
        assert (columnTexts.length == columnToolTips.length);
        assert (columnTypes.length == columnTexts.length);
        assert (defaultSortDirection.length == columnTexts.length);
        this.columnTexts.addAll(Arrays.asList(columnTexts));
        this.columnToolTips.addAll(Arrays.asList(columnToolTips));
        for (int n : defaultSortDirection) {
            this.defaultSortDirections.add(Direction.get(n));
        }
        for (int n : defaultSortOrder) {
            this.defaultSortOrder.add(new SortOrderHelper(n, 0));
        }
        this.columnTypes.addAll(Arrays.asList(columnTypes));
        this.columnTags.addAll(Arrays.asList(columnTags));
        for (int n : columnsToSum) {
            this.columnsToSum.add(n);
        }
        for (VisibilitySet visibilitySet : visibilitySets) {
            assert (!this.visibilitySets.containsKey(visibilitySet.getId()));
            this.visibilitySets.put(visibilitySet.getId(), visibilitySet);
        }
        this.defaultVisibleSets = defaultVisibleSets;
        for (int n : columnsToSearch) {
            this.columnsToSearch.add(n);
        }
        for (boolean bl : noPercentageBars) {
            this.noPercentageBars.add(bl);
        }
        this.compareKeyColumns = compareKeyColumns;
    }

    public int getNrOfColumns() {
        return this.columnTexts.size();
    }

    public String getColumnText(int column) {
        return this.columnTexts.get(column);
    }

    public String getColumnToolTip(int column) {
        return this.columnToolTips.get(column);
    }

    public int getDefaultSortDirection(int column) {
        return this.defaultSortDirections.get(column).toValue();
    }

    public int getNrOfDefaultSorts() {
        return this.defaultSortOrder.size();
    }

    public int getDefaultSortColumn(int index) {
        return this.defaultSortOrder.get(index).columnIndex;
    }

    public void setDefaultSortOrder(SortOrder sortOrder) {
        this.defaultSortOrder.clear();
        for (int column : sortOrder.getColumns()) {
            this.defaultSortOrder.add(new SortOrderHelper(column, 0));
        }
    }

    public Class<?> getColumnType(int column) {
        return this.columnTypes.get(column);
    }

    public boolean getNoPercentageBarsFlag(int column) {
        return this.noPercentageBars.get(column);
    }

    public String getColumnTag(int column) {
        return this.columnTags.get(column);
    }

    public int[] getColumnsToSum() {
        int[] result = new int[this.columnsToSum.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.columnsToSum.get(i);
        }
        return result;
    }

    public int[] getColumnsToAverage() {
        int[] result = new int[this.columnsToAverage.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.columnsToAverage.get(i);
        }
        return result;
    }

    public int[] getColumnsToMinMax() {
        int[] result = new int[this.columnsToMinMax.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.columnsToMinMax.get(i);
        }
        return result;
    }

    public int[] getColumnsToNonZero() {
        int[] result = new int[this.columnsToNonZero.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.columnsToNonZero.get(i);
        }
        return result;
    }

    public int[] getColumnsToEnumerate() {
        int[] result = new int[this.columnsToEnumerate.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.columnsToEnumerate.get(i);
        }
        return result;
    }

    public int[] getCompareKeyColumns() {
        if (this.compareKeyColumns == null) {
            return new int[]{this.columnsToSearch.size() > 0 ? this.columnsToSearch.get(0) : 0};
        }
        return this.compareKeyColumns;
    }

    public void setCompareKeyColumns(int ... columnsToCompare) {
        this.compareKeyColumns = columnsToCompare;
    }

    public boolean isComparableWith(TypedColumnSpec otherSpec) {
        if (this.getNrOfColumns() != otherSpec.getNrOfColumns()) {
            return false;
        }
        for (int i = 0; i < this.getNrOfColumns(); ++i) {
            if (!this.getColumnType(i).equals(otherSpec.getColumnType(i))) {
                return false;
            }
            if (this.getColumnText(i).equals(otherSpec.getColumnText(i))) continue;
            return false;
        }
        return true;
    }

    public boolean shouldSumColumn(int column) {
        for (int toSum : this.columnsToSum) {
            if (column != toSum) continue;
            return true;
        }
        return false;
    }

    public boolean isColumnFixed(int column) {
        for (int fixed : this.columnsFixed) {
            if (column != fixed) continue;
            return true;
        }
        return false;
    }

    public VisibilitySet[] getColumnVisibilitySets() {
        HashMap visibilityByGroup = new HashMap();
        for (VisibilitySet set : this.visibilitySets.values()) {
            if (!visibilityByGroup.containsKey(set.getGroupId())) {
                visibilityByGroup.put(set.getGroupId(), new ArrayList());
            }
            ((List)visibilityByGroup.get(set.getGroupId())).add(set);
        }
        ArrayList keys = new ArrayList(visibilityByGroup.keySet());
        Collections.sort(keys);
        VisibilitySet[] result = new VisibilitySet[this.visibilitySets.size()];
        int i = 0;
        for (String k : keys) {
            for (VisibilitySet set : (List)visibilityByGroup.get(k)) {
                result[i++] = set;
            }
        }
        return result;
    }

    public String getDefaultVisibleSets() {
        return this.defaultVisibleSets;
    }

    public void setDefaultVisibleSets(String sets) {
        this.defaultVisibleSets = sets;
    }

    /*
     * WARNING - void declaration
     */
    public boolean[] getColumnVisibility(String sets) {
        int nrOfColumns = this.columnTypes.size();
        boolean[] result = new boolean[nrOfColumns];
        HashMap groups = new HashMap();
        for (VisibilitySet set : this.visibilitySets.values()) {
            Set set2 = (Set)groups.get(set.getGroupId());
            if (set2 == null) {
                HashSet hashSet = new HashSet();
                groups.put(set.getGroupId(), hashSet);
            }
            for (int column : set.getColumns()) {
                void var7_9;
                var7_9.add(column);
            }
        }
        HashSet<String> visibleSetNames = new HashSet<String>(Arrays.asList(sets.split("\\|")));
        for (int i = 0; i < nrOfColumns; ++i) {
            result[i] = true;
        }
        for (VisibilitySet visibilitySet : this.visibilitySets.values()) {
            if (visibilitySet.isDisabled() || !visibleSetNames.contains(visibilitySet.getId()) && !visibilitySet.isAlwaysActive()) continue;
            Set columns = (Set)groups.get(visibilitySet.getGroupId());
            for (int column : visibilitySet.getColumns()) {
                columns.remove(column);
            }
        }
        for (Set set : groups.values()) {
            Object object = set.iterator();
            while (object.hasNext()) {
                int column = (Integer)object.next();
                result[column] = false;
            }
        }
        return result;
    }

    public String getAllVisibilitySets() {
        StringBuilder result = new StringBuilder();
        for (VisibilitySet set : this.visibilitySets.values()) {
            if (result.length() > 0) {
                result.append('|');
            }
            result.append(set.getId());
        }
        return result.toString();
    }

    public int[] getUniqueColumns() {
        ArrayList<Integer> columns = new ArrayList<Integer>();
        for (int i = 0; i < this.getNrOfColumns(); ++i) {
            if (!UniqueEntry.class.isAssignableFrom(this.getColumnType(i))) continue;
            columns.add(i);
        }
        int[] result = new int[columns.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)columns.get(i);
        }
        return result;
    }

    public int[] getSearchColumns() {
        if (this.columnsToSearch.size() > 0) {
            int[] result = new int[this.columnsToSearch.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.columnsToSearch.get(i);
            }
            return result;
        }
        return null;
    }

    public void disableVisibilitySets(String toDisable) {
        for (String string : toDisable.split(Pattern.quote("|"))) {
            for (Map.Entry<String, VisibilitySet> entry : this.visibilitySets.entrySet()) {
                if (!entry.getKey().equals(string)) continue;
                this.visibilitySets.put(entry.getKey(), entry.getValue().getDisabled());
            }
        }
        HashMap groups = new HashMap();
        for (VisibilitySet set : this.visibilitySets.values()) {
            if (set.isDisabled()) continue;
            String string = set.getGroupId();
            if (!groups.containsKey(string)) {
                groups.put(string, new ArrayList());
            }
            ((ArrayList)groups.get(string)).add(set);
        }
        for (ArrayList group : groups.values()) {
            if (group.size() != 1) continue;
            VisibilitySet visibilitySet = (VisibilitySet)group.get(0);
            this.visibilitySets.put(visibilitySet.getId(), visibilitySet.getAlwaysActive());
        }
    }

    private static int getTypeDiff(Class<?> clazz1, Class<?> clazz2) {
        if (clazz1 == clazz2) {
            return 0;
        }
        HashSet supers = new HashSet();
        supers.add(clazz1);
        supers.add(clazz2);
        Class<?> super1 = clazz1;
        Class<?> super2 = clazz2;
        int result = 1;
        while ((super1 = super1.getSuperclass()) != null && supers.add(super1)) {
            if ((super2 = super2.getSuperclass()) == null || !supers.add(super2)) {
                return result;
            }
            ++result;
        }
        return result;
    }

    private HashSet<String> getTagsForColumns(int column) {
        HashSet<String> result = new HashSet<String>();
        for (VisibilitySet set : this.getColumnVisibilitySets()) {
            for (int c : set.getColumns()) {
                if (c != column) continue;
                result.add(set.getId());
            }
        }
        return result;
    }

    public int getDependentSortColumn(String parentSortColumnVisibilitySets, Class<?> parentSortColumnType) {
        if (parentSortColumnVisibilitySets.length() == 0) {
            if (parentSortColumnType == null) {
                return -1;
            }
            HashSet<Integer> allColumns = new HashSet<Integer>();
            for (int i = 0; i < this.getNrOfColumns(); ++i) {
                allColumns.add(i);
            }
            for (VisibilitySet set : this.getColumnVisibilitySets()) {
                HashSet<Integer> columns = new HashSet<Integer>();
                for (int column : set.getColumns()) {
                    columns.add(column);
                }
                allColumns.removeAll(columns);
            }
            if (UniqueEntry.class.isAssignableFrom(parentSortColumnType)) {
                HashSet<Integer> uniqueColumns = new HashSet<Integer>();
                Iterator iterator = allColumns.iterator();
                while (iterator.hasNext()) {
                    int column = (Integer)iterator.next();
                    Class<?> type = this.getColumnType(column);
                    if (!UniqueEntry.class.isAssignableFrom(type)) continue;
                    uniqueColumns.add(column);
                }
                if (uniqueColumns.size() == 1) {
                    return (Integer)uniqueColumns.iterator().next();
                }
            }
            int minDiff = Integer.MAX_VALUE;
            int result = -1;
            Iterator column = allColumns.iterator();
            while (column.hasNext()) {
                int column2 = (Integer)column.next();
                Class<?> type = this.getColumnType(column2);
                int diff = TypedColumnSpec.getTypeDiff(type, parentSortColumnType);
                if (diff == minDiff) {
                    result = -1;
                    continue;
                }
                if (diff >= minDiff) continue;
                minDiff = diff;
                result = column2;
            }
            return result;
        }
        HashSet<Integer> validColumns = null;
        for (String tag : parentSortColumnVisibilitySets.split("[|]")) {
            VisibilitySet set = this.getSetForTag(tag);
            if (set == null) continue;
            HashSet<Integer> columns = new HashSet<Integer>();
            for (int column : set.getColumns()) {
                columns.add(column);
            }
            if (validColumns == null) {
                validColumns = columns;
                continue;
            }
            validColumns.retainAll(columns);
        }
        if (validColumns != null && validColumns.size() == 1) {
            return (Integer)validColumns.iterator().next();
        }
        if (validColumns != null) {
            int defaultColumn = this.getDefaultSortColumn(this.getNrOfDefaultSorts() - 1);
            HashSet<String> defaultTags = this.getTagsForColumns(defaultColumn);
            HashSet<Integer> bestMatches = new HashSet<Integer>();
            int max = 0;
            Iterator iterator = validColumns.iterator();
            while (iterator.hasNext()) {
                int column = (Integer)iterator.next();
                HashSet<String> tags = this.getTagsForColumns(column);
                tags.retainAll(defaultTags);
                if (tags.size() > max) {
                    bestMatches = new HashSet();
                    bestMatches.add(column);
                    max = tags.size();
                    continue;
                }
                if (tags.size() != max) continue;
                bestMatches.add(column);
            }
            if (bestMatches.size() == 1) {
                return (Integer)bestMatches.iterator().next();
            }
        }
        return -1;
    }

    public String getDependentVisibility(String parentVisibility) {
        if (parentVisibility == null) {
            return this.getDefaultVisibleSets();
        }
        HashSet<VisibilitySet> sets = new HashSet<VisibilitySet>();
        HashSet<String> parentGroups = new HashSet<String>();
        for (String tag : parentVisibility.split("[|]")) {
            VisibilitySet set = this.getSetForTag(tag);
            if (set == null) continue;
            sets.add(set);
            parentGroups.add(set.getGroupId());
        }
        HashSet<String> additionalGroups = new HashSet<String>();
        for (VisibilitySet set : this.visibilitySets.values()) {
            if (parentGroups.contains(set.getGroupId())) continue;
            additionalGroups.add(set.getGroupId());
        }
        for (String tag : this.defaultVisibleSets.split("[|]")) {
            for (VisibilitySet set : this.visibilitySets.values()) {
                if (!set.getId().equals(tag) || !additionalGroups.contains(set.getGroupId())) continue;
                sets.add(set);
            }
        }
        StringBuilder result = new StringBuilder();
        for (VisibilitySet set : sets) {
            if (result.length() > 0) {
                result.append('|');
            }
            result.append(set.getId());
        }
        return result.toString();
    }

    public VisibilitySet getSetForTag(String tag) {
        return this.visibilitySets.get(tag);
    }

    public TypedColumnSpec prepend(String name, String toolTip, int flags, Class<?> columnType, String columnTag) {
        int i;
        int i2;
        assert (name != null);
        this.columnTexts.add(0, name);
        this.columnToolTips.add(0, toolTip);
        assert (this.defaultSortDirections.size() == this.columnTexts.size() - 1);
        if ((flags & 1) != 0) {
            this.defaultSortDirections.add(0, Direction.ASCENDING_DIRECTION);
        } else if ((flags & 2) != 0) {
            this.defaultSortDirections.add(0, Direction.DESCENDING_DIRECTION);
        } else {
            this.defaultSortDirections.add(0, Direction.NOT_SORTABLE);
        }
        this.columnTypes.add(0, columnType);
        this.columnTags.add(0, columnTag);
        this.noPercentageBars.add(0, (flags & 0x800) != 0);
        for (i2 = 0; i2 < this.defaultSortOrder.size(); ++i2) {
            this.defaultSortOrder.set(i2, this.defaultSortOrder.get(i2).inc());
        }
        if ((flags & 0x1F0) != 0) {
            this.defaultSortOrder.add(0, new SortOrderHelper(0, flags & 0x1F0));
        }
        for (i2 = 0; i2 < this.columnsToSum.size(); ++i2) {
            this.columnsToSum.set(i2, this.columnsToSum.get(i2) + 1);
        }
        if ((flags & 4) != 0) {
            this.columnsToSum.add(0, 0);
        }
        if (this.compareKeyColumns != null) {
            int[] newCompareKeyColumns = new int[this.compareKeyColumns.length];
            for (int i3 = 0; i3 < this.compareKeyColumns.length; ++i3) {
                newCompareKeyColumns[i3] = this.compareKeyColumns[i3] + 1;
            }
            this.compareKeyColumns = newCompareKeyColumns;
        }
        if ((flags & 0x400) != 0) {
            if (this.compareKeyColumns == null) {
                this.compareKeyColumns = new int[]{0};
            } else {
                int[] old = this.compareKeyColumns;
                this.compareKeyColumns = new int[old.length + 1];
                System.arraycopy(old, 0, this.compareKeyColumns, 1, old.length);
                this.compareKeyColumns[0] = 0;
            }
        }
        for (i = 0; i < this.columnsToSearch.size(); ++i) {
            this.columnsToSearch.set(i, this.columnsToSearch.get(i) + 1);
        }
        if ((flags & 8) != 0) {
            this.columnsToSearch.add(0, 0);
        }
        for (i = 0; i < this.columnsToAverage.size(); ++i) {
            this.columnsToAverage.set(i, this.columnsToAverage.get(i) + 1);
        }
        if ((flags & 0x1000) != 0) {
            this.columnsToAverage.add(0);
        }
        for (i = 0; i < this.columnsToMinMax.size(); ++i) {
            this.columnsToMinMax.set(i, this.columnsToMinMax.get(i) + 1);
        }
        if ((flags & 0x2000) != 0) {
            this.columnsToMinMax.add(0);
        }
        for (i = 0; i < this.columnsToNonZero.size(); ++i) {
            this.columnsToNonZero.set(i, this.columnsToNonZero.get(i) + 1);
        }
        if ((flags & 0x8000) != 0) {
            this.columnsToNonZero.add(0);
        }
        for (i = 0; i < this.columnsToEnumerate.size(); ++i) {
            this.columnsToEnumerate.set(i, this.columnsToEnumerate.get(i) + 1);
        }
        if ((flags & 0x4000) != 0) {
            this.columnsToEnumerate.add(0);
        }
        for (i = 0; i < this.columnsFixed.size(); ++i) {
            this.columnsFixed.set(i, this.columnsFixed.get(i) + 1);
        }
        this.columnsFixed.add(0, 0);
        LinkedHashMap<String, VisibilitySet> newVisibilitySets = new LinkedHashMap<String, VisibilitySet>();
        for (VisibilitySet set : this.visibilitySets.values()) {
            int[] columns = set.getColumns();
            Integer[] newColumns = new Integer[columns.length];
            for (int j = 0; j < columns.length; ++j) {
                newColumns[j] = columns[j] + 1;
            }
            assert (!newVisibilitySets.containsKey(set.getId()));
            newVisibilitySets.put(set.getId(), new VisibilitySet(set.getId(), set.getGroupId(), set.getDisplayName(), set.getIconName(), set.getToolTip(), newColumns));
            if (set.isDisabled()) {
                newVisibilitySets.put(set.getId(), ((VisibilitySet)newVisibilitySets.get(set.getId())).getDisabled());
            }
            if (!set.isAlwaysActive()) continue;
            newVisibilitySets.put(set.getId(), ((VisibilitySet)newVisibilitySets.get(set.getId())).getAlwaysActive());
        }
        this.visibilitySets.clear();
        this.visibilitySets.putAll(newVisibilitySets);
        return this;
    }

    public void removeDefaultSorting() {
        this.defaultSortOrder.clear();
        this.defaultSortDirections.clear();
    }

    public void makeInvisible(int column) {
        this.columnTexts.set(column, "invisible " + column);
        VisibilitySet newVisibilitySet = new VisibilitySet("invisible" + this.visibilitySets.size(), "invisible" + this.visibilitySets.size(), "", "", "", column);
        this.visibilitySets.put(newVisibilitySet.getId(), newVisibilitySet.getDisabled());
    }

    public TypedColumnSpec appendInvisible(Class<?> columnType) {
        this.columnTexts.add("invisible " + this.columnTexts.size());
        this.columnToolTips.add("");
        this.defaultSortDirections.add(Direction.DESCENDING_DIRECTION);
        this.columnTypes.add(columnType);
        this.columnTags.add("");
        this.noPercentageBars.add(false);
        VisibilitySet newVisibilitySet = new VisibilitySet("invisible" + this.visibilitySets.size(), "invisible" + this.visibilitySets.size(), "", "", "", this.columnTexts.size());
        this.visibilitySets.put(newVisibilitySet.getId(), newVisibilitySet.getDisabled());
        return this;
    }

    public int appendColumn(String name, String toolTip, int flags, Class<?> type, String tag, VisibilitySet ... sets) {
        assert (name != null);
        int index = this.columnTexts.size();
        this.columnTexts.add(name);
        this.columnToolTips.add(toolTip);
        this.columnTypes.add(type);
        this.columnTags.add(tag);
        this.noPercentageBars.add((flags & 0x800) != 0);
        assert (this.defaultSortDirections.size() == index);
        if ((flags & 1) != 0) {
            this.defaultSortDirections.add(Direction.ASCENDING_DIRECTION);
        } else if ((flags & 2) != 0) {
            this.defaultSortDirections.add(Direction.DESCENDING_DIRECTION);
        } else {
            this.defaultSortDirections.add(Direction.NOT_SORTABLE);
        }
        int sortColumn = flags & 0x1F0;
        if (sortColumn != 0) {
            int i;
            for (i = 0; i < this.defaultSortOrder.size() && (this.defaultSortOrder.get(i).flag & 0x1F0) >= sortColumn; ++i) {
            }
            this.defaultSortOrder.add(i, new SortOrderHelper(index, sortColumn));
        }
        if ((flags & 4) != 0) {
            this.columnsToSum.add(index);
        }
        if ((flags & 8) != 0) {
            this.columnsToSearch.add(index);
        }
        if ((flags & 0x200) != 0) {
            this.columnsFixed.add(index);
        }
        if ((flags & 0x1000) != 0) {
            this.columnsToAverage.add(index);
        }
        if ((flags & 0x2000) != 0) {
            this.columnsToMinMax.add(index);
        }
        if ((flags & 0x8000) != 0) {
            this.columnsToNonZero.add(index);
        }
        if ((flags & 0x4000) != 0) {
            this.columnsToEnumerate.add(index);
        }
        for (VisibilitySet set : sets) {
            if (set == null) continue;
            VisibilitySet oldSet = this.visibilitySets.get(set.getId());
            if (oldSet == null) {
                oldSet = set;
            }
            int[] oldColumns = oldSet.getColumns();
            Integer[] newColumns = new Integer[oldColumns.length + 1];
            for (int i = 0; i < oldColumns.length; ++i) {
                newColumns[i] = oldColumns[i];
            }
            newColumns[oldColumns.length] = index;
            this.visibilitySets.put(oldSet.getId(), new VisibilitySet(oldSet.getId(), oldSet.getGroupId(), oldSet.getDisplayName(), oldSet.getIconName(), oldSet.getToolTip(), newColumns));
        }
        return index;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("TypedColumnSpec with " + this.visibilitySets.size() + " VisibilitySet objects:\n");
        for (VisibilitySet set : this.visibilitySets.values()) {
            result.append(set.toString());
        }
        return result.toString();
    }

    private static final class SortOrderHelper {
        private final int columnIndex;
        private final int flag;

        private SortOrderHelper(int columnIndex, int flag) {
            this.columnIndex = columnIndex;
            this.flag = flag;
        }

        private SortOrderHelper inc() {
            return new SortOrderHelper(this.columnIndex + 1, this.flag);
        }
    }

    private static enum Direction {
        NOT_SORTABLE,
        ASCENDING_DIRECTION,
        DESCENDING_DIRECTION;


        public static Direction get(int value) {
            return value < 0 ? DESCENDING_DIRECTION : (value == 0 ? NOT_SORTABLE : ASCENDING_DIRECTION);
        }

        public int toValue() {
            return this == DESCENDING_DIRECTION ? -1 : (this == NOT_SORTABLE ? 0 : 1);
        }
    }
}

