/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.presentation.impl.typed.TypedModelRendererImpl;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.TypedModelRenderer;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.lang.ref.SoftReference;
import java.util.HashMap;

public class TypedModelRendererFactory {
    private static TypedModelRendererImpl impl;
    private static HashMap<Key, SoftReference<TypedModelRenderer>> cache;

    public static synchronized TypedModelRenderer get(ModelViewer viewer, RendererThemeSpec spec) {
        if (impl == null) {
            impl = new TypedModelRendererImpl();
        }
        Key key = new Key(viewer, spec.getName());
        SoftReference<TypedModelRenderer> resultRef = cache.get(key);
        TypedModelRenderer result = null;
        if (resultRef != null) {
            result = resultRef.get();
        }
        if (result == null) {
            result = impl.getForViewer(viewer, spec);
            cache.put(key, new SoftReference<TypedModelRenderer>(result));
        }
        return result;
    }

    public static EntryRenderer getRenderer(ModelViewer viewer, RendererThemeSpec spec, ProviderEntry entry) {
        if (impl == null) {
            impl = new TypedModelRendererImpl();
        }
        Class<?> entryClass = entry.getClass();
        return impl.getForViewer(viewer, spec, entryClass).getRenderer(entryClass);
    }

    public static RendererNode getNode(ModelViewer viewer, RendererThemeSpec spec, ProviderEntry entry) {
        return TypedModelRendererFactory.getRenderer(viewer, spec, entry).getRenderer(entry, null, null);
    }

    static {
        cache = new HashMap();
    }

    private static class Key {
        private final ModelViewer viewer;
        private final String theme;

        public Key(ModelViewer viewer, String theme) {
            this.viewer = viewer;
            this.theme = theme == null ? "" : theme;
        }

        public int hashCode() {
            return this.viewer.hashCode() ^ this.theme.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return other.viewer.equals(this.viewer) && this.theme.equals(other.theme);
            }
            return false;
        }
    }
}

