/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.presentation.description.DescriptionProvider;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.description.DescriptionWriter;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.ProviderResource;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.viewer.renderer.MultiChildNode;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class TypedReportProvider
extends ProviderResource
implements DescriptionProvider {
    private static volatile int instanceCounter = 0;
    public static final String PROFILER_RESOURCE_URI_SCHEME = "profiler";
    private final String title;
    private final String iconKey;
    private RendererThemeSpec themeSpec;
    private File reportDir;

    public TypedReportProvider(ResourceName name, String title, String iconKey) {
        super(name);
        this.title = title;
        this.iconKey = iconKey;
    }

    public String getIconKey() {
        return this.iconKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createReportData(ProgressReporter reporter) throws IOException {
        TypedReportProvider typedReportProvider = this;
        synchronized (typedReportProvider) {
            if (this.reportDir != null) {
                return;
            }
            ResourceName name = this.getResourceName();
            File tmpDir = name.getResourceManager().getTempDirectory();
            int id = instanceCounter++;
            File directory = new File(tmpDir, "report_" + id);
            assert (!directory.isFile());
            directory.mkdirs();
            DescriptionWriter.writeAsHtmlToDirectory(name, "", this, this.themeSpec, directory, reporter);
            this.reportDir = directory;
        }
    }

    @Override
    public RendererNode getDescription(ResourceName dummy, String kind, DescriptionViewer viewer, ProgressReporter reporter) throws IOException {
        return this.getReport(viewer, reporter);
    }

    public abstract RendererNode getReport(DescriptionViewer var1, ProgressReporter var2) throws IOException;

    public final ResourceName[] getDependents() {
        return null;
    }

    public final String getTitle() {
        return this.title;
    }

    @Override
    public EntryContext getEntryContext() {
        return null;
    }

    public void setTheme(RendererThemeSpec spec) {
        this.themeSpec = spec;
    }

    public File getReportDataDirectory() {
        return this.reportDir;
    }

    public RendererNode link(DescriptionViewer viewer, String location, RendererNode child) {
        return this.link(viewer, location, null, child);
    }

    public RendererNode link(DescriptionViewer viewer, String location, String options, RendererNode child) {
        URI target = null;
        try {
            target = new URI(PROFILER_RESOURCE_URI_SCHEME, location, options);
        }
        catch (URISyntaxException e) {
            Trace.error((Throwable)e, () -> "Could not create link target URI for location " + location + "!");
        }
        return viewer.newHyperLinkNode(child, target);
    }

    public RendererNode replace(DescriptionViewer viewer, String textPattern, RendererNode ... arguments) {
        int spacesCount;
        String pattern = textPattern;
        for (spacesCount = 0; spacesCount < pattern.length() && pattern.charAt(spacesCount) == ' '; ++spacesCount) {
        }
        if (spacesCount > 0) {
            if (spacesCount == textPattern.length()) {
                return viewer.newSpaceNode(spacesCount * 5);
            }
            pattern = pattern.substring(spacesCount);
        }
        ArrayList<ReplacementNode> replacements = new ArrayList<ReplacementNode>(arguments.length + 1);
        replacements.add(new ReplacementNode("\n", viewer.newLineBreakNode()));
        for (int i = 0; i < arguments.length; ++i) {
            replacements.add(new ReplacementNode("{" + i + "}", arguments[i]));
        }
        MultiChildNode<? extends RendererNode> result = this.replaceImpl(viewer, pattern, replacements);
        if (spacesCount > 0) {
            result = viewer.newMultiChildNode(viewer.newSpaceNode(spacesCount * 5), result);
        }
        return result;
    }

    private RendererNode replaceImpl(DescriptionViewer viewer, String textPattern, List<ReplacementNode> replacements) {
        ArrayList<Integer> cutPoints = new ArrayList<Integer>();
        for (ReplacementNode rep : replacements) {
            this.findMarker(textPattern, cutPoints, rep.marker, 0);
        }
        Collections.sort(cutPoints);
        if (cutPoints.size() == 0) {
            return viewer.newTextNode(textPattern);
        }
        ArrayList<String> parts = new ArrayList<String>(cutPoints.size() + 1);
        int lastPos = 0;
        for (int cutPoint : cutPoints) {
            if (cutPoint == lastPos) continue;
            parts.add(textPattern.substring(lastPos, cutPoint));
            lastPos = cutPoint;
        }
        if (lastPos != textPattern.length()) {
            parts.add(textPattern.substring(lastPos));
        }
        RendererNode[] result = new RendererNode[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            String part = (String)parts.get(i);
            boolean replaced = false;
            for (ReplacementNode rep : replacements) {
                if (!part.equals(rep.marker)) continue;
                result[i] = rep.replacement;
                replaced = true;
                break;
            }
            if (replaced) continue;
            result[i] = viewer.newTextNode(part);
        }
        return viewer.newMultiChildNode(result);
    }

    private void findMarker(String textPattern, ArrayList<Integer> cutPoints, String marker, int startPos) {
        int pos = textPattern.indexOf(marker, startPos);
        if (pos >= 0) {
            cutPoints.add(pos);
            cutPoints.add(pos + marker.length());
            this.findMarker(textPattern, cutPoints, marker, pos + marker.length());
        }
    }

    private static class ReplacementNode {
        public final String marker;
        public final RendererNode replacement;

        public ReplacementNode(String marker, RendererNode replacement) {
            this.marker = marker;
            this.replacement = replacement;
        }
    }
}

