/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.typed.AbstractTableBasedProvider;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import java.io.IOException;

public abstract class TypedTableProvider<T>
extends AbstractTableBasedProvider {
    private final String title;
    private final String iconKey;
    private final TypedColumnSpec columnSpec;
    protected T statistic;

    protected TypedTableProvider(ResourceName name, String title, String iconKey, TypedColumnSpec columnSpec) {
        super(name);
        this.title = title;
        this.iconKey = iconKey;
        this.columnSpec = columnSpec;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIconKey() {
        return this.iconKey;
    }

    @Override
    public TypedColumnSpec getColumnSpec() {
        return this.columnSpec;
    }

    public long getCreateTableWork() {
        return this.getColumnSpec().getNrOfColumns();
    }

    public final void tableCreated(ProgressReporter reporter) throws OperationCanceledException {
        this.initializeContext(reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(ProgressReporter reporter) throws IOException {
        TypedTableProvider typedTableProvider = this;
        synchronized (typedTableProvider) {
            if (this.statistic != null) {
                return;
            }
        }
        ProfilingSession session = this.getResourceName().getSession();
        ResourceManager manager = session.getResourceManager();
        ResourceName statisticName = this.getStatisticName();
        if (statisticName != null) {
            Resource result = manager.get(statisticName, reporter);
            TypedTableProvider typedTableProvider2 = this;
            synchronized (typedTableProvider2) {
                if (this.statistic == null) {
                    this.statistic = result;
                }
            }
        }
    }

    public final ResourceName[] getDependents() {
        ResourceName statisticName = this.getStatisticName();
        if (statisticName != null) {
            return new ResourceName[]{statisticName};
        }
        return new ResourceName[0];
    }

    protected abstract ResourceName getStatisticName();

    public String getToolTip(ProviderEntry entry, EntryRenderer renderer, int column) {
        if (entry == null) {
            return "";
        }
        return renderer.getToolTip(entry, this.getEntryContext(), this.getColumnContext(column));
    }

    public String getToolTipForCombinedItems(int[] itemIds, ProviderEntry[] entries, EntryRenderer renderer, int column) {
        return renderer.getToolTipForCombinedItems(entries, this.getEntryContext(), this.getColumnContext(column));
    }
}

