/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.presentation.impl.typed.thread.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;

public class TypedTableThreadDumps {
    private ThreadDumpSnapshot snp;
    private int[] rowToIndex;

    public TypedTableThreadDumps(ThreadDumpSnapshot snp) {
        this.snp = snp;
        this.rowToIndex = new int[snp.getNumThreadDumps()];
        for (int i = 0; i < this.rowToIndex.length; ++i) {
            this.rowToIndex[i] = i;
        }
    }

    public ResourceName getName() {
        return this.snp.asResourceName();
    }

    public String getTitle() {
        return this.snp.getName();
    }

    public TypedColumnSpec getColSpec() {
        return ProviderUtils.getThreadDumpsSpec();
    }

    public ProviderEntry getEntry(int row, int column) {
        return ProviderUtils.getEntry(this.snp, column, this.rowToIndex[row]);
    }

    public int getNrOfRows() {
        return this.snp.getNumThreadDumps();
    }
}

