/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.core.event.HeartBeatGCStatistic;
import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.graph.ProfilingColors;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.PercentageAxisModel;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.ProviderResource;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.LockContentionPerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytesPerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfLoadedArrayClasses;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfLoadedClasses;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfMethods;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOpenFiles;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOpenSockets;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfPageFaultsPerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfProcesses;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfSafepoints;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfThreads;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfUnloadedArrayClasses;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfUnloadedClasses;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfVmOperations;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.util.Elements;
import com.sap.jvm.profiling.snapshot.util.GeneralTimeSeries;
import com.sap.jvm.profiling.snapshot.util.TimeSeriesCollection;
import com.sap.jvm.profiling.snapshot.util.TimestampToBookmarkConverter;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionToolTipProvider;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotation;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotationSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphPresentationAdapter;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphVirtualDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.XYListValue2DStorage;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.geometry.Value2DExtended;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.ColorPool;
import com.sap.jvm.profiling.ui.graph.utils.GraphTools;
import com.sap.jvm.profiling.util.dataset.TimeSeries;
import com.sap.jvm.profiling.util.dataset.XEventList;
import com.sap.jvm.profiling.util.dataset.XEventListIterator;
import com.sap.jvm.profiling.util.dataset.XYList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;

public abstract class TypedTimeSeriesProvider
extends ProviderResource {
    protected static final int Y0_TO_105 = 0;
    protected static final int Y0_TO_105_PERCENT = 1;
    protected static final int FULL = 2;
    private static final int EVENT = 3;
    protected static final int PEAK = 0;
    protected static final int AVERAGE = 1;
    private static final int GC = 2;
    protected static final int POS_NEG_PEAK = 3;
    private final String title;
    private final String iconKey;
    private TimeSeriesCollection[] collections;
    private int currentOffset;
    private int nextOffset;
    private Entry currentTag;
    private final HashMap<ResourceName, Integer> offsets;
    private final ArrayList<String> areaTitles;
    private final ArrayList<ArrayList<Integer>> graphOffsets;
    private final ArrayList<ArrayList<Color>> graphColors;
    private final ArrayList<ArrayList<Color>> secondGraphColors;
    private final ArrayList<ArrayList<LineGraphDataSet.GraphStyle>> graphStyles;
    private final ArrayList<ArrayList<String>> graphLegends;
    private final ArrayList<ArrayList<Class<?>>> graphAxes;
    private final ArrayList<ArrayList<Boolean>> forcedPrimary;
    private final ArrayList<ArrayList<Boolean>> forcedSecondary;
    private final ArrayList<ArrayList<String>> eventIcons;
    private final ArrayList<ArrayList<Integer>> graphTypes;
    private final ArrayList<ArrayList<String>> graphTags;
    private final ArrayList<ArrayList<Integer>> graphAdaptors;
    private final ArrayList<Integer> globalGraphOffsets;
    private final ArrayList<Color> globalGraphColors;
    private final ArrayList<Color> globalSecondGraphColors;
    private final ArrayList<String> globalEventIcons;
    private final ArrayList<String> globalLegends;
    private final ArrayList<Integer> globalGraphTypes;
    private final ArrayList<String> globalGraphTags;
    private final ArrayList<Integer> globalGraphAdaptors;
    private int[] timeSeriesIndices;
    private int[] timeSeriesOffsets;
    private final String defaulVisibilitySet;
    private TimestampToBookmarkConverter converter;
    private final HashMap<String, DisplayGroup> groups;
    private final HashMap<String, Entry> entries;

    public TypedTimeSeriesProvider(ResourceName name, String title, String iconKey, String defaulVisibilitySet) {
        super(name);
        this.title = title;
        this.iconKey = iconKey;
        this.defaulVisibilitySet = defaulVisibilitySet;
        this.offsets = new HashMap();
        this.areaTitles = new ArrayList();
        this.graphTypes = new ArrayList();
        this.graphAdaptors = new ArrayList();
        this.graphOffsets = new ArrayList();
        this.graphColors = new ArrayList();
        this.secondGraphColors = new ArrayList();
        this.graphStyles = new ArrayList();
        this.graphLegends = new ArrayList();
        this.graphAxes = new ArrayList();
        this.forcedPrimary = new ArrayList();
        this.forcedSecondary = new ArrayList();
        this.eventIcons = new ArrayList();
        this.graphTags = new ArrayList();
        this.globalEventIcons = new ArrayList();
        this.globalLegends = new ArrayList();
        this.globalGraphColors = new ArrayList();
        this.globalGraphOffsets = new ArrayList();
        this.globalGraphTags = new ArrayList();
        this.globalSecondGraphColors = new ArrayList();
        this.globalGraphTypes = new ArrayList();
        this.globalGraphAdaptors = new ArrayList();
        this.groups = new LinkedHashMap<String, DisplayGroup>();
        this.entries = new LinkedHashMap<String, Entry>();
    }

    public void addGroup(String tag, String name) {
        assert (!this.groups.containsKey(tag));
        this.groups.put(tag, new DisplayGroup(tag, name));
    }

    public String getGroupName(String tag) {
        DisplayGroup result = this.groups.get(tag);
        return result == null ? tag : result.name;
    }

    protected void addGeneralTimeSeries() {
        this.setCurrent(this.getResourceName().addElement((ResourceNameElement)new Elements.CreateGeneralTimeSeries()), 49);
        this.addGroup("general", I18n._s((String)"General Information"));
        this.addArea(I18n._s((String)"General"), "general/cpu", I18n._s((String)"CPU and Java memory graphs"));
        this.addLine(0, 1, 1, I18n._s((String)"CPU Time"), ProfilingColors.CPU_USAGE_COLOR, PercentageAxisModel.class);
        this.addLine(1, 1, 2, I18n._s((String)"Java Memory"), new Color[]{ProfilingColors.MEMORY_USAGE_COLOR, ProfilingColors.GC_VALUE_COLOR}, PercentageAxisModel.class);
        this.addArea(I18n._s((String)"JIT"), "general/jit", I18n._s((String)"Shows JIT Compiler utilization"));
        this.addLine(0, 0, 1, I18n._s((String)"CPU Time"), ProfilingColors.CPU_USAGE_COLOR, PercentageAxisModel.class);
        this.addLine(2, 0, 1, I18n._s((String)"JIT usage"), ProfilingColors.JIT_CPU_GRAPH_COLOR, PercentageAxisModel.class);
        this.addArea(I18n._s((String)"I/O"), "general/io", I18n._s((String)"Shows overall IO activity for files and networks"));
        this.addLine(3, 0, 1, I18n._s((String)"File I/O"), (Object)ProfilingColors.FILE_IO_COLOR, LineGraphDataSet.GraphStyle.LINES_FILLED, NrOfBytesPerSecond.class);
        this.addLine(4, 0, 1, I18n._s((String)"Network I/O"), (Object)ProfilingColors.NETWORK_IO_COLOR, LineGraphDataSet.GraphStyle.LINES_FILLED, NrOfBytesPerSecond.class);
        if (!this.getResourceName().getSession().getSystemInfo().hasFullMonitoringBoardTrace()) {
            this.addArea(I18n._s((String)"Java Threads"), "general/threads", I18n._s((String)"Shows the number of Java threads"));
            this.addLine(10, 0, 1, I18n._s((String)"Nr of Java Threds"), (Object)ProfilingColors.THREAD_COUNT_COLOR, LineGraphDataSet.GraphStyle.LINES_FILLED, NrOfThreads.class);
        } else {
            this.addArea(I18n._s((String)"Detailed I/O"), "general/detailed_io", I18n._s((String)"Shows more detailed I/O statistics"));
            this.addLine(35, 0, 1, I18n._s((String)"File read throughput"), ColorPool.getPool().getColor(0, 27), NrOfBytesPerSecond.class);
            this.addLine(36, 0, 1, I18n._s((String)"File write throughput"), ColorPool.getPool().getColor(3, 15), NrOfBytesPerSecond.class);
            this.addLine(37, 0, 1, I18n._s((String)"Network read throughput"), ColorPool.getPool().getColor(4, 0), NrOfBytesPerSecond.class);
            this.addLine(38, 0, 1, I18n._s((String)"Network write throughput"), ColorPool.getPool().getColor(1, 6), NrOfBytesPerSecond.class);
            this.addLine(33, 0, 1, I18n._s((String)"Nr. of open files"), ColorPool.getPool().getColor(5, 11), NrOfOpenFiles.class);
            this.addLine(34, 0, 1, I18n._s((String)"Nr. of open sockets"), ColorPool.getPool().getColor(0, 0), NrOfOpenSockets.class);
            this.addArea(I18n._s((String)"Load Average"), "general/load_avg", I18n._s((String)"Shows the load averages"));
            this.addLine(11, 0, 1, I18n._s((String)"Load Average 1 minute"), ColorPool.getPool().getColor(1, 5), PercentageAxisModel.class);
            this.addLine(12, 0, 1, I18n._s((String)"Load Average 5 minute"), ColorPool.getPool().getColor(0, 9), PercentageAxisModel.class);
            this.addLine(13, 0, 1, I18n._s((String)"Load Average 15 minute"), ColorPool.getPool().getColor(3, 5), PercentageAxisModel.class);
            this.addArea(I18n._s((String)"Code Cache"), "general/code_cache", I18n._s((String)"Shows information about the code cache"));
            this.addLine(15, 0, 1, I18n._s((String)"Code cache occupancy"), ColorPool.getPool().getColor(0, 0), NrOfBytes.class);
            this.addLine(14, 0, 0, I18n._s((String)"Code cache max occupancy"), ColorPool.getPool().getColor(0, 27), NrOfBytes.class);
            this.addLine(18, 0, 1, I18n._s((String)"Nr of methods"), ColorPool.getPool().getColor(3, 14), NrOfMethods.class);
            this.addLine(16, 0, 1, I18n._s((String)"Nr of tier 1 methods"), ColorPool.getPool().getColor(4, 0), NrOfMethods.class);
            this.addLine(17, 0, 1, I18n._s((String)"Nr of tier 2 methods"), ColorPool.getPool().getColor(1, 6), NrOfMethods.class);
            this.addArea(I18n._s((String)"Java Threads"), "general/java_threads", I18n._s((String)"Shows information about the java threads"));
            this.addLine(19, 0, 1, I18n._s((String)"Nr of Java Threds"), ColorPool.getPool().getColor(0, 27), NrOfThreads.class);
            this.addLine(20, 0, 1, I18n._s((String)"Nr of running Java Threds"), ColorPool.getPool().getColor(3, 15), NrOfThreads.class);
            this.addLine(21, 0, 1, I18n._s((String)"Nr of sleeping Java Threds"), ColorPool.getPool().getColor(4, 0), NrOfThreads.class);
            this.addLine(22, 0, 1, I18n._s((String)"Nr of waiting Java Threds"), ColorPool.getPool().getColor(1, 6), NrOfThreads.class);
            this.addLineSecondary(23, 0, 0, I18n._s((String)"Cumulative nr of Java Threds"), ColorPool.getPool().getColor(5, 11), NrOfThreads.class);
            this.addArea(I18n._s((String)"Processes"), "general/processes", I18n._s((String)"Shows information about spawned processes"));
            this.addLine(24, 0, 1, I18n._s((String)"Nr of spawned processes"), ColorPool.getPool().getColor(0, 27), NrOfProcesses.class);
            this.addLineSecondary(25, 0, 1, I18n._s((String)"Nr of failed processes"), ColorPool.getPool().getColor(4, 0), NrOfProcesses.class);
            this.addArea(I18n._s((String)"Safepoints"), "general/safepoints", I18n._s((String)"Shows information about safepoints"));
            this.addLine(27, 0, 1, I18n._s((String)"Avg. time spent in safepoint"), ColorPool.getPool().getColor(0, 27), ElapsedTime.class);
            this.addLine(26, 0, 1, I18n._s((String)"Max. time spent in safepoint"), ColorPool.getPool().getColor(3, 15), ElapsedTime.class);
            this.addLine(28, 0, 1, I18n._s((String)"Avg. time spent in safepoint sync"), ColorPool.getPool().getColor(4, 0), ElapsedTime.class);
            this.addLine(29, 0, 1, I18n._s((String)"Max. time spent in safepoint sync"), ColorPool.getPool().getColor(1, 6), ElapsedTime.class);
            this.addLine(32, 0, 1, I18n._s((String)"Avg. time spent in VM operation"), ColorPool.getPool().getColor(5, 11), ElapsedTime.class);
            this.addLineSecondary(30, 0, 1, I18n._s((String)"Nr of safepoints"), ColorPool.getPool().getColor(0, 0), NrOfSafepoints.class);
            this.addLineSecondary(31, 0, 1, I18n._s((String)"Nr of VM operations"), ColorPool.getPool().getColor(2, 12), NrOfVmOperations.class);
            this.addArea(I18n._s((String)"Native Memory"), "general/native_memory", I18n._s((String)"Shows information about native memory consumption"));
            this.addLine(40, 0, 1, I18n._s((String)"Available memory"), ColorPool.getPool().getColor(0, 27), NrOfBytes.class);
            this.addLine(39, 0, 1, I18n._s((String)"Reserved memory"), ColorPool.getPool().getColor(3, 15), NrOfBytes.class);
            this.addLine(41, 0, 1, I18n._s((String)"Working set size"), ColorPool.getPool().getColor(4, 0), NrOfBytes.class);
            this.addLine(43, 0, 1, I18n._s((String)"Major page faults per second"), ColorPool.getPool().getColor(1, 6), NrOfPageFaultsPerSecond.class);
            this.addLine(42, 0, 1, I18n._s((String)"Minor page faults per second"), ColorPool.getPool().getColor(5, 11), NrOfPageFaultsPerSecond.class);
            this.addArea(I18n._s((String)"Class Loading"), "general/class_loading", I18n._s((String)"Shows information about class loading"));
            this.addLine(45, 0, 1, I18n._s((String)"Loaded classes"), ColorPool.getPool().getColor(0, 27), NrOfLoadedClasses.class);
            this.addLinePrimary(47, 0, 1, I18n._s((String)"Loaded array classes"), ColorPool.getPool().getColor(3, 15), NrOfLoadedArrayClasses.class);
            this.addLinePrimary(46, 0, 1, I18n._s((String)"Unloaded classes"), ColorPool.getPool().getColor(4, 0), NrOfUnloadedClasses.class);
            this.addLinePrimary(48, 0, 1, I18n._s((String)"Unloaded array classes"), ColorPool.getPool().getColor(1, 6), NrOfUnloadedArrayClasses.class);
            this.addArea(I18n._s((String)"Lock Contention"), "general/lock_contention", I18n._s((String)"Shows information the lock contention rate"));
            this.addLine(44, 0, 1, I18n._s((String)"Lock contention rate"), ColorPool.getPool().getColor(0, 27), LockContentionPerSecond.class);
            this.setCurrentTag("general/alerts", I18n._s((String)"Alerts"), I18n._s((String)"Shows alert indications in all graphs"));
            this.addGlobalEvents(5, new LineGraphAnnotation(LineGraphAnnotation.Severity.ERROR, null, 0.0).getBorderColor(), "navigation/delete_small.gif", I18n._s((String)"Errors"));
            this.addGlobalEvents(6, new LineGraphAnnotation(LineGraphAnnotation.Severity.WARNING, null, 0.0).getBorderColor(), "decorators/warning.gif", I18n._s((String)"Warnings"));
            this.addGlobalEvents(7, new LineGraphAnnotation(LineGraphAnnotation.Severity.INFO, null, 0.0).getBorderColor(), "decorators/info_small.gif", I18n._s((String)"Infos"));
            this.addGlobalEvents(8, new Color[]{ProfilingColors.PROFILING_RANGE_BORDER_COLOR, ProfilingColors.PROFILING_RANGE_COLOR}, "views/monitors.gif", I18n._s((String)"Profiling sessions"));
            this.addGlobalEvents(9, new Color[]{ProfilingColors.DEBUGGING_RANGE_BORDER_COLOR, ProfilingColors.DEBUGGING_RANGE_COLOR}, "profiling/debug.gif", I18n._s((String)"Debugging sessions"));
        }
    }

    protected void setCurrent(ResourceName name, int nrOfSeries) {
        Integer offset = this.offsets.get(name);
        if (offset == null) {
            this.currentOffset = this.nextOffset;
            this.nextOffset += nrOfSeries;
            this.offsets.put(name, this.currentOffset);
        } else {
            this.currentOffset = offset;
        }
    }

    protected void setCurrentTag(String tag, String name, String tooltip) {
        assert (!this.entries.containsKey(tag));
        String groupTag = tag.substring(0, tag.indexOf(47));
        assert (this.groups.containsKey(groupTag));
        this.currentTag = new Entry(tag, groupTag, name, tooltip);
        this.entries.put(tag, this.currentTag);
    }

    protected void addArea(String areaTitle) {
        this.areaTitles.add(areaTitle);
        this.graphTypes.add(new ArrayList());
        this.graphAdaptors.add(new ArrayList());
        this.graphOffsets.add(new ArrayList());
        this.graphLegends.add(new ArrayList());
        this.graphColors.add(new ArrayList());
        this.graphStyles.add(new ArrayList());
        this.secondGraphColors.add(new ArrayList());
        this.graphAxes.add(new ArrayList());
        this.forcedPrimary.add(new ArrayList());
        this.forcedSecondary.add(new ArrayList());
        this.graphTags.add(new ArrayList());
        this.eventIcons.add(new ArrayList());
        for (int i = 0; i < this.globalGraphTags.size(); ++i) {
            this.addGlobalEventsToArea(this.areaTitles.size() - 1, i);
        }
    }

    private void addGlobalEventsToArea(int areaIndex, int index) {
        this.graphTypes.get(areaIndex).add(this.globalGraphTypes.get(index));
        this.graphAdaptors.get(areaIndex).add(this.globalGraphAdaptors.get(index));
        this.graphOffsets.get(areaIndex).add(this.globalGraphOffsets.get(index));
        this.graphColors.get(areaIndex).add(this.globalGraphColors.get(index));
        this.graphStyles.get(areaIndex).add(null);
        this.graphLegends.get(areaIndex).add(this.globalLegends.get(index));
        this.secondGraphColors.get(areaIndex).add(this.globalSecondGraphColors.get(index));
        this.graphAxes.get(areaIndex).add(null);
        this.forcedPrimary.get(areaIndex).add(false);
        this.forcedSecondary.get(areaIndex).add(false);
        this.graphTags.get(areaIndex).add(this.globalGraphTags.get(index));
        this.eventIcons.get(areaIndex).add(this.globalEventIcons.get(index));
    }

    public static Class<?> getBaseAxis(Class<?> type) {
        if (type == null) {
            return null;
        }
        try {
            return (Class)type.getDeclaredField("BASE_TYPE").get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return type;
    }

    protected void addArea(String areaTitle, String tag, String tooltip) {
        this.setCurrentTag(tag, areaTitle, tooltip);
        this.addArea(areaTitle);
    }

    protected void addLine(int offset, int graphType, int adaptorType, String legend, Object color, Class<?> axis) {
        this.addLine(offset, graphType, adaptorType, legend, color, LineGraphDataSet.GraphStyle.LINES, this.currentTag.tag, axis, false, false);
    }

    protected void addLinePrimary(int offset, int graphType, int adaptorType, String legend, Object color, Class<?> axis) {
        this.addLine(offset, graphType, adaptorType, legend, color, LineGraphDataSet.GraphStyle.LINES, this.currentTag.tag, axis, true, false);
    }

    protected void addLineSecondary(int offset, int graphType, int adaptorType, String legend, Object color, Class<?> axis) {
        this.addLine(offset, graphType, adaptorType, legend, color, LineGraphDataSet.GraphStyle.LINES, this.currentTag.tag, axis, false, true);
    }

    protected void addLine(int offset, int graphType, int adaptorType, String legend, Object color, LineGraphDataSet.GraphStyle drawingStyle, Class<?> axis) {
        this.addLine(offset, graphType, adaptorType, legend, color, drawingStyle, this.currentTag.tag, axis, false, false);
    }

    protected void addLine(int offset, int graphType, int adaptorType, String legend, Object color, String tag, Class<?> axis) {
        this.addLine(offset, graphType, adaptorType, legend, color, LineGraphDataSet.GraphStyle.LINES, tag, axis, false, false);
    }

    protected void addLine(int offset, int graphType, int adaptorType, String legend, Object color, LineGraphDataSet.GraphStyle drawingStyle, String tag, Class<?> axis, boolean forcePrimary, boolean forceSecondary) {
        int areaIndex = this.areaTitles.size() - 1;
        this.graphTypes.get(areaIndex).add(graphType);
        this.graphAdaptors.get(areaIndex).add(adaptorType);
        this.graphOffsets.get(areaIndex).add(offset + this.currentOffset);
        this.graphLegends.get(areaIndex).add(legend);
        this.graphColors.get(areaIndex).add(this.getColor(color));
        this.graphStyles.get(areaIndex).add(drawingStyle);
        this.secondGraphColors.get(areaIndex).add(this.getSecondColor(color));
        this.graphAxes.get(areaIndex).add(axis);
        this.forcedPrimary.get(areaIndex).add(forcePrimary);
        this.forcedSecondary.get(areaIndex).add(forceSecondary);
        this.eventIcons.get(areaIndex).add(null);
        this.graphTags.get(areaIndex).add(tag);
    }

    protected void addEvents(int offset, Object color, String key, String tag, String legend) {
        int areaIndex = this.areaTitles.size() - 1;
        this.graphTypes.get(areaIndex).add(3);
        this.graphAdaptors.get(areaIndex).add(1);
        this.graphOffsets.get(areaIndex).add(offset + this.currentOffset);
        this.graphLegends.get(areaIndex).add(legend);
        this.graphColors.get(areaIndex).add(this.getColor(color));
        this.graphStyles.get(areaIndex).add(null);
        this.secondGraphColors.get(areaIndex).add(this.getSecondColor(color));
        this.graphAxes.get(areaIndex).add(null);
        this.forcedPrimary.get(areaIndex).add(false);
        this.forcedSecondary.get(areaIndex).add(false);
        this.graphTags.get(areaIndex).add(tag);
        this.eventIcons.get(areaIndex).add(key);
    }

    protected void addEvents(int offset, Object color, String key, String legend) {
        this.addEvents(offset, color, key, this.currentTag.tag, legend);
    }

    protected void addGlobalEvents(int offset, Object color, String key, String tag, String legend) {
        this.globalGraphTypes.add(3);
        this.globalGraphAdaptors.add(1);
        this.globalGraphOffsets.add(offset + this.currentOffset);
        this.globalGraphColors.add(this.getColor(color));
        this.globalSecondGraphColors.add(this.getSecondColor(color));
        this.globalGraphTags.add(tag);
        this.globalEventIcons.add(key);
        this.globalLegends.add(legend);
        for (int i = 0; i < this.areaTitles.size(); ++i) {
            this.addGlobalEventsToArea(i, this.globalGraphTypes.size() - 1);
        }
    }

    protected void addGlobalEvents(int offset, Object color, String key, String legend) {
        this.addGlobalEvents(offset, color, key, this.currentTag.tag, legend);
    }

    public String[] getTags() {
        HashSet<String> inserted = new HashSet<String>();
        ArrayList<String> result = new ArrayList<String>();
        for (DisplayGroup group : this.groups.values()) {
            for (Entry entry : this.entries.values()) {
                String currGroup = entry.groupTag;
                if (!currGroup.equals(group.tag) || !inserted.add(entry.tag)) continue;
                result.add(entry.tag);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String getNameOfTag(String tag) {
        return this.entries.get(tag).name;
    }

    public String getTooltipOfTag(String tag) {
        return this.entries.get(tag).tooltip;
    }

    private Color getColor(Object color) {
        if (color instanceof Color) {
            return (Color)color;
        }
        if (color instanceof Color[]) {
            return ((Color[])color)[0];
        }
        String c = (String)color;
        assert (c.length() >= 6);
        int red = Integer.parseInt(c.substring(0, 2), 16);
        int green = Integer.parseInt(c.substring(2, 4), 16);
        int blue = Integer.parseInt(c.substring(4, 6), 16);
        return new Color(red, green, blue);
    }

    private Color getSecondColor(Object color) {
        if (color instanceof Color) {
            return null;
        }
        if (color instanceof Color[]) {
            Color[] array = (Color[])color;
            return array.length > 1 ? array[1] : null;
        }
        String c = (String)color;
        if (c.length() != 13) {
            return null;
        }
        assert (c.charAt(6) == '/');
        int red = Integer.parseInt(c.substring(7, 9), 16);
        int green = Integer.parseInt(c.substring(9, 11), 16);
        int blue = Integer.parseInt(c.substring(11, 13), 16);
        return new Color(red, green, blue);
    }

    protected abstract ResourceName getCollectionName();

    public String getIconKey() {
        return this.iconKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createDataSets(ProgressReporter reporter) throws IOException {
        TypedTimeSeriesProvider typedTimeSeriesProvider = this;
        synchronized (typedTimeSeriesProvider) {
            if (this.collections != null) {
                return;
            }
        }
        TimeSeriesCollection[] result = new TimeSeriesCollection[this.offsets.size()];
        int[] indices = new int[this.nextOffset];
        int[] seriesOffsets = new int[this.nextOffset];
        int index = 0;
        for (ResourceName name : this.offsets.keySet()) {
            result[index] = (TimeSeriesCollection)name.getResourceManager().get(name, reporter);
            int offset = this.offsets.get(name);
            for (int i = 0; i < result[index].getNrOfTimeSeries(); ++i) {
                indices[offset + i] = index;
                seriesOffsets[offset + i] = offset;
            }
            ++index;
        }
        ResourceName name = this.getResourceName();
        ResourceName converterName = name.addElement((ResourceNameElement)new Elements.CreateTimestampToBookmarkConverter());
        this.converter = (TimestampToBookmarkConverter)name.getResourceManager().get(converterName, reporter);
        TypedTimeSeriesProvider typedTimeSeriesProvider2 = this;
        synchronized (typedTimeSeriesProvider2) {
            if (this.collections == null) {
                this.collections = result;
                this.timeSeriesIndices = indices;
                this.timeSeriesOffsets = seriesOffsets;
            }
        }
    }

    public TimestampToBookmarkConverter getTimestampConverter() {
        return this.converter;
    }

    public final ResourceName[] getDependents() {
        return this.offsets.keySet().toArray(new ResourceName[this.offsets.size()]);
    }

    public final String getTitle() {
        return this.title;
    }

    private TimeSeries getTimeSeries(int areaIndex, int index) {
        int offset = this.graphOffsets.get(areaIndex).get(index);
        TimeSeriesCollection collection = this.collections[this.timeSeriesIndices[offset]];
        offset -= this.timeSeriesOffsets[offset];
        return collection.getTimeSeries(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getGraph(int areaIndex, int index, long xOffset) {
        try {
            TimeSeries timeSeries = this.getTimeSeries(areaIndex, index);
            if (timeSeries instanceof XYList) {
                XYList list = (XYList)timeSeries;
                double minY = 0.0;
                double maxY = 2.0;
                if (list.getSize() > 0) {
                    minY = this.getAdjustedMinY(this.graphTypes.get(areaIndex).get(index), list.getMinY());
                    maxY = this.getAdjustedMaxY(this.graphTypes.get(areaIndex).get(index), list.getMaxY());
                }
                XYListValue2DStorage storage = new XYListValue2DStorage(list, xOffset, minY, maxY);
                String legend = this.graphLegends.get(areaIndex).get(index);
                LineGraphVirtualDataSet dataSet = new LineGraphVirtualDataSet(legend, storage);
                dataSet.setGraphColor(this.graphColors.get(areaIndex).get(index));
                if (this.secondGraphColors.get(areaIndex).get(index) != null) {
                    dataSet.setValueColor(this.secondGraphColors.get(areaIndex).get(index));
                }
                dataSet.setDrawingStyle(this.graphStyles.get(areaIndex).get(index));
                int adaptor = this.graphAdaptors.get(areaIndex).get(index);
                switch (adaptor) {
                    case 3: {
                        dataSet.setPresentationAdapter(GraphTools.POS_NEG_PEAK_PRESENTATION_ADAPTER);
                    }
                    case 0: {
                        dataSet.setPresentationAdapter(GraphTools.MAX_PEAK_PRESENTATION_ADAPTER);
                        break;
                    }
                    case 1: {
                        dataSet.setPresentationAdapter(null);
                        break;
                    }
                    case 2: {
                        dataSet.setPresentationAdapter(new MemoryPresentationAdapter(dataSet));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown presentation adaptor tag: " + adaptor);
                    }
                }
                return dataSet;
            }
            XEventList list = (XEventList)timeSeries;
            LineGraphAnnotationSet set = new LineGraphAnnotationSet();
            try (XEventListIterator it = list.getIterator();){
                while (it.next()) {
                    LineGraphAnnotation annotation = it.range == 0L ? set.addInfoStamp(it.x + xOffset, this.getAnnotationMessage(it.data), it.data) : set.addInfoRange(it.x + xOffset, it.x + it.range + xOffset, this.getAnnotationMessage(it.data), it.data);
                    String annotationIconKey = this.getAnnotationIconKey(it.data);
                    if (annotationIconKey == null) {
                        annotationIconKey = this.eventIcons.get(areaIndex).get(index);
                    }
                    if (annotationIconKey != null) {
                        annotation.setData(annotationIconKey);
                    }
                    annotation.decorate(this.secondGraphColors.get(areaIndex).get(index), this.graphColors.get(areaIndex).get(index));
                }
            }
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private double getAdjustedMinY(int tag, double minY) {
        switch (tag) {
            case 0: 
            case 1: {
                if (minY >= 0.0) {
                    return 0.0;
                }
                return minY * 1.05;
            }
        }
        return minY;
    }

    private double getAdjustedMaxY(int tag, double maxY) {
        switch (tag) {
            case 0: {
                return maxY * 1.05;
            }
            case 1: {
                return Math.max(10500.0, maxY * 1.05);
            }
        }
        return maxY;
    }

    protected String getAnnotationMessage(Object data) {
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof HeartBeatGCStatistic) {
            HeartBeatGCStatistic statistic = (HeartBeatGCStatistic)data;
            StringBuilder text = new StringBuilder();
            text.append(I18n._s((String)"GC Statistic"));
            text.append("\n------------\n");
            text.append(I18n._s((String)"Nr: {0} ({3})\nCause: {2}\nDuration: {1}", (Object[])new Object[]{statistic.getGcNr(), DataFormatter.getNanosDurationText((long)(1000L * statistic.getDuration())), statistic.getCause(), DataFormatter.getTimeStampTime((long)statistic.getTimeMillis(), (TimeZone)this.getResourceName().getSession().getTimeZone())}));
            return text.toString();
        }
        return null;
    }

    protected String getAnnotationIconKey(Object data) {
        return null;
    }

    public Object getToolTipProvider() {
        return new LineGraphSelectionToolTipProvider(){

            @Override
            public String provideSelectedValueToolTip(LineGraphDataSet graph, List<Value2D> values) {
                StringBuilder result = new StringBuilder();
                for (Value2D v : values) {
                    String msg;
                    Object d = graph.getData(v);
                    if (d == null || (msg = TypedTimeSeriesProvider.this.getAnnotationMessage(d)) == null) continue;
                    if (result.length() > 0) {
                        result.append("\n");
                    }
                    result.append(TypedTimeSeriesProvider.this.getAnnotationMessage(d));
                }
                return result.toString();
            }

            @Override
            public String provideHorizontalSelectionText(double min, double max) {
                return DataFormatter.getMicrosDurationText((long)((long)(max - min)));
            }
        };
    }

    public long getMinX(int areaIndex, int index) {
        return this.getTimeSeries(areaIndex, index).getMinX();
    }

    public long getMaxX(int areaIndex, int index) {
        return this.getTimeSeries(areaIndex, index).getMaxX();
    }

    public int getSize(int areaIndex, int index) {
        return this.getTimeSeries(areaIndex, index).getSize();
    }

    public boolean isEmpty(String tag) {
        String splitPattern = Pattern.quote("&");
        for (int areaIndex = 0; areaIndex < this.getNrOfAreas(); ++areaIndex) {
            ArrayList<String> tags = this.graphTags.get(areaIndex);
            block1: for (int index = 0; index < this.getNrOfGraphs(areaIndex); ++index) {
                String[] graphTagParts;
                for (String tagPart : graphTagParts = tags.get(index).split(splitPattern)) {
                    if (!tagPart.equals(tag)) continue;
                    TimeSeries timeSeries = this.getTimeSeries(areaIndex, index);
                    if (timeSeries.getSize() <= 0) continue block1;
                    return false;
                }
            }
        }
        return true;
    }

    public int getNrOfAreas() {
        return this.areaTitles.size();
    }

    public int getNrOfGraphs(int areaIndex) {
        return this.graphOffsets.get(areaIndex).size();
    }

    public String getAreaTitle(int areaIndex) {
        return this.areaTitles.get(areaIndex);
    }

    public String getGraphLegend(int areaIndex, int index) {
        return this.graphLegends.get(areaIndex).get(index);
    }

    public Class<?> getBaseAxisModel(int areaIndex, int index) {
        return TypedTimeSeriesProvider.getBaseAxis(this.graphAxes.get(areaIndex).get(index));
    }

    public Class<?> getAxisModel(int areaIndex, int index) {
        return this.graphAxes.get(areaIndex).get(index);
    }

    public boolean isForcedSecondary(int areaIndex, int index) {
        return this.forcedSecondary.get(areaIndex).get(index);
    }

    public boolean isForcedPrimary(int areaIndex, int index) {
        return this.forcedPrimary.get(areaIndex).get(index);
    }

    public String[] getDefaultVisivilitySet() {
        return this.defaulVisibilitySet.split(Pattern.quote("|"));
    }

    public boolean[][] getGraphVisibility(String[] visibilitySet) {
        int i;
        boolean[][] result = new boolean[this.getNrOfAreas()][];
        String splitPattern = Pattern.quote("&");
        HashSet<String> tmpTags = new HashSet<String>();
        for (i = 0; i < result.length; ++i) {
            result[i] = new boolean[this.getNrOfGraphs(i)];
            for (int j = 0; j < result[i].length; ++j) {
                String tag = this.graphTags.get(i).get(j);
                String[] entryTags = tag.split(splitPattern);
                tmpTags.clear();
                tmpTags.addAll(Arrays.asList(entryTags));
                block2: for (String entry : entryTags) {
                    for (String part : visibilitySet) {
                        if (!part.equals(entry)) continue;
                        tmpTags.remove(entry);
                        continue block2;
                    }
                }
                if (!tmpTags.isEmpty()) continue;
                result[i][j] = true;
            }
        }
        for (i = 0; i < result.length; ++i) {
            int j;
            boolean hasVisibleGraph = false;
            for (j = 0; j < result[i].length; ++j) {
                if (!result[i][j] || this.graphTypes.get(i).get(j) == 3) continue;
                hasVisibleGraph = true;
                break;
            }
            if (hasVisibleGraph) continue;
            for (j = 0; j < result[i].length; ++j) {
                if (!result[i][j] || this.graphTypes.get(i).get(j) != 3) continue;
                result[i][j] = false;
            }
        }
        return result;
    }

    @Override
    public EntryContext getEntryContext() {
        return null;
    }

    public GeneralTimeSeries getGeneralTimeSeries() {
        for (TimeSeriesCollection collection : this.collections) {
            if (!(collection instanceof GeneralTimeSeries)) continue;
            return (GeneralTimeSeries)collection;
        }
        return null;
    }

    private static class Entry {
        private final String tag;
        private final String groupTag;
        private final String name;
        private final String tooltip;

        public Entry(String tag, String groupTag, String name, String tooltip) {
            this.tag = tag;
            this.groupTag = groupTag;
            this.name = name;
            this.tooltip = tooltip;
        }
    }

    private static class DisplayGroup {
        private final String tag;
        private final String name;

        public DisplayGroup(String tag, String name) {
            this.tag = tag;
            this.name = name;
        }
    }

    private static class MemoryPresentationAdapter
    implements LineGraphPresentationAdapter {
        LineGraphVirtualDataSet dataSet;

        public MemoryPresentationAdapter(LineGraphVirtualDataSet dataSet) {
            this.dataSet = dataSet;
        }

        private boolean calc(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            Value2DExtended result = new Value2DExtended(pixelValues.get((int)0).x, pixelValues.get((int)0).y);
            for (Value2D val : pixelValues) {
                if (!val.emphasized) continue;
                result.emphasized = true;
                if (!(result.y < val.y)) continue;
                result.y = val.y;
            }
            if (result.emphasized) {
                visibleSet.add(result);
                return true;
            }
            return false;
        }

        @Override
        public void createPixelValue(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            this.calc(pixelValues, visibleSet);
        }

        @Override
        public void createFirstPixelValue(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            if (!this.calc(pixelValues, visibleSet)) {
                Value2D result;
                long idx = this.dataSet.getIndexOfXValue(pixelValues.get((int)0).x);
                do {
                    result = this.dataSet.getValueAt(idx--);
                } while (idx > 0L && !result.emphasized);
                if (result != null) {
                    visibleSet.add(new Value2DExtended(result));
                } else {
                    visibleSet.add(new Value2DExtended(pixelValues.get(0)));
                }
            }
        }

        @Override
        public void createLastPixelValue(List<Value2D> pixelValues, List<Value2DExtended> visibleSet) {
            if (!this.calc(pixelValues, visibleSet)) {
                Value2D result;
                long idx = this.dataSet.getIndexOfXValue(pixelValues.get((int)0).x);
                do {
                    result = this.dataSet.getValueAt(idx++);
                } while (idx < this.dataSet.getSize() && !result.emphasized);
                if (result != null) {
                    visibleSet.add(new Value2DExtended(result));
                } else {
                    visibleSet.add(new Value2DExtended(pixelValues.get(pixelValues.size() - 1)));
                }
            }
        }
    }
}

