/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.typed.TypedTreeChildCombiner;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.presentation.typed.ProviderResource;
import com.sap.jvm.profiling.presentation.typed.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.TreeChildCombiner;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.entries.CpuTime;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsage;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytesPerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfClosedFiles;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfClosedSockets;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfInvocations;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjects;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOpenedFiles;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOpenedSockets;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfReadWriteRoundtrips;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfRoundtrips;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfWriteReadRoundtrips;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.viewer.tree.NormalItem;
import com.sap.jvm.profiling.viewer.tree.OtherChildrenItem;
import com.sap.jvm.profiling.viewer.tree.SkippedChildrenItem;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import java.io.IOException;

public abstract class TypedTreeProvider<T>
extends ProviderResource {
    protected String title;
    private final String iconKey;
    private TypedColumnSpec columnSpec;
    private EntryContext context;
    private ColumnContext[] columnContexts;
    protected T tree;

    protected TypedTreeProvider(ResourceName name, String title, String iconKey, TypedColumnSpec columnSpec) {
        super(name);
        this.title = title;
        this.iconKey = iconKey;
        this.columnSpec = columnSpec;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIconKey() {
        return this.iconKey;
    }

    public TypedColumnSpec getColumnSpec() {
        return this.columnSpec;
    }

    protected void setColumnSpec(TypedColumnSpec columnSpec) {
        this.columnSpec = columnSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createRoots(ProgressReporter reporter) throws IOException {
        TypedTreeProvider typedTreeProvider = this;
        synchronized (typedTreeProvider) {
            if (this.tree != null) {
                return;
            }
        }
        ProfilingSession session = this.getResourceName().getSession();
        ResourceManager manager = session.getResourceManager();
        ResourceName treeName = this.getTreeName();
        Resource result = manager.get(treeName, reporter);
        TypedTreeProvider typedTreeProvider2 = this;
        synchronized (typedTreeProvider2) {
            if (this.tree == null) {
                this.tree = result;
            }
        }
    }

    public final ResourceName[] getDependents() {
        return new ResourceName[]{this.getTreeName()};
    }

    protected abstract ResourceName getTreeName();

    public final void rootsCreated() {
        this.context = new EntryContext(this.getResourceName().getSession());
        this.columnContexts = new ColumnContext[this.getColumnSpec().getNrOfColumns()];
        long maxBytes = -1L;
        long maxObjects = -1L;
        long maxInvocations = -1L;
        long maxOpenedFiles = -1L;
        long maxClosedFiles = -1L;
        long maxOpenedSockets = -1L;
        long maxClosedSockets = -1L;
        long maxBytesPerSecond = -1L;
        long maxCpuTime = -1L;
        long maxElapsedTime = -1L;
        long maxReadWriteRoundtrips = -1L;
        long maxWriteReadRoundtrips = -1L;
        long maxRoundtrips = -1L;
        long maxMemoryUsage = -1L;
        for (int i = 0; i < this.columnSpec.getNrOfColumns(); ++i) {
            this.columnContexts[i] = new ColumnContext();
            this.columnContexts[i].noPercentageBars = this.getColumnSpec().getNoPercentageBarsFlag(i);
            maxBytes = Math.max(maxBytes, this.getMaxQuantity(i, NrOfBytes.class));
            maxObjects = Math.max(maxObjects, this.getMaxQuantity(i, NrOfObjects.class));
            maxInvocations = Math.max(maxInvocations, this.getMaxQuantity(i, NrOfInvocations.class));
            maxOpenedFiles = Math.max(maxOpenedFiles, this.getMaxQuantity(i, NrOfOpenedFiles.class));
            maxClosedFiles = Math.max(maxClosedFiles, this.getMaxQuantity(i, NrOfClosedFiles.class));
            maxOpenedSockets = Math.max(maxOpenedSockets, this.getMaxQuantity(i, NrOfOpenedSockets.class));
            maxClosedSockets = Math.max(maxClosedSockets, this.getMaxQuantity(i, NrOfClosedSockets.class));
            maxBytesPerSecond = Math.max(maxBytesPerSecond, this.getMaxQuantity(i, NrOfBytesPerSecond.class));
            maxCpuTime = Math.max(maxCpuTime, this.getMaxQuantity(i, CpuTime.class));
            maxElapsedTime = Math.max(maxElapsedTime, this.getMaxQuantity(i, ElapsedTime.class));
            maxReadWriteRoundtrips = Math.max(maxReadWriteRoundtrips, this.getMaxQuantity(i, NrOfReadWriteRoundtrips.class));
            maxWriteReadRoundtrips = Math.max(maxWriteReadRoundtrips, this.getMaxQuantity(i, NrOfWriteReadRoundtrips.class));
            maxRoundtrips = Math.max(maxRoundtrips, this.getMaxQuantity(i, NrOfRoundtrips.class));
            maxMemoryUsage = Math.max(maxMemoryUsage, this.getMaxQuantity(i, MemoryUsage.class));
        }
        this.context.setMaxBytes(maxBytes);
        this.context.setMaxObjects(maxObjects);
        this.context.setMaxInvocations(maxInvocations);
        this.context.setMaxOpenedFiles(maxOpenedFiles);
        this.context.setMaxClosedFiles(maxClosedFiles);
        this.context.setMaxOpenedSockets(maxOpenedSockets);
        this.context.setMaxClosedSockets(maxClosedSockets);
        this.context.setMaxBytesPerSecond(maxBytesPerSecond);
        this.context.setMaxCpuTime(maxCpuTime);
        this.context.setMaxElapsedTime(maxElapsedTime);
        this.context.setTracedMethods(ProviderUtils.getTraceMethods(this.getSnapshot()));
        this.context.setMaxReadWriteRoundtrips(maxReadWriteRoundtrips);
        this.context.setMaxWriteReadRoundtrips(maxWriteReadRoundtrips);
        this.context.setMaxRoundtrips(maxRoundtrips);
        this.context.setMaxMemoryUsage(maxMemoryUsage);
    }

    private long getMaxQuantity(int column, Class<? extends Quantity> clazz) {
        long max = 0L;
        if (this.columnSpec.getColumnType(column) == clazz) {
            for (Object root : this.getRootNodes()) {
                Quantity quantity = (Quantity)this.getEntry(root, column);
                if (quantity == null) continue;
                max = Math.max(max, quantity.getQuantity());
            }
        }
        return max;
    }

    @Override
    public final EntryContext getEntryContext() {
        assert (this.context != null);
        return this.context;
    }

    public ColumnContext getColumnContext(int column) {
        return this.columnContexts[column];
    }

    public ColumnContext[] getColumnContexts() {
        return (ColumnContext[])this.columnContexts.clone();
    }

    public void setColumnContext(int column, ColumnContext columnContext) {
        this.columnContexts[column] = columnContext;
    }

    public abstract Object[] getRootNodes();

    public abstract boolean hasCreatedChildren(Object var1);

    public abstract boolean hasChildren(Object var1);

    public void createChildren(Object node, ProgressReporter reporter) throws IOException {
        throw new IOException("Unsuppored operation");
    }

    public abstract Object[] getChildren(Object var1);

    public abstract Snapshot getSnapshot();

    public boolean hasSubNodes(Object node) {
        return false;
    }

    public boolean hasCreatedSubNodes(Object node) {
        assert (false);
        return false;
    }

    public void createSubNodes(Object node, ProgressReporter reporter) throws IOException {
        throw new IOException("Unsuppored operation");
    }

    public Object[] getSubNodes(Object node) {
        assert (false);
        return null;
    }

    public boolean isSubNode(Object node) {
        return false;
    }

    public abstract Object getParent(Object var1);

    public abstract ProviderEntry getEntry(Object var1, int var2);

    public String getNormalToolTip(NormalItem item, ProviderEntry entry, EntryRenderer renderer, int column) {
        return renderer.getToolTip(entry, this.getEntryContext(), this.getColumnContext(column));
    }

    public String getOtherChildrenToolTip(OtherChildrenItem item, ProviderEntry[] entries, EntryRenderer renderer, int column) {
        return renderer.getToolTipForOtherChildren(entries, this.getEntryContext(), this.getColumnContext(column));
    }

    public String getToggleOtherChildrenToolTip(OtherChildrenItem item, ProviderEntry[] entries, EntryRenderer renderer, int column) {
        return renderer.getToolTipForOtherChildren(entries, this.getEntryContext(), this.getColumnContext(column), false);
    }

    public String getCombinedItemsToolTip(TreeModelItem[] items, ProviderEntry[] entries, EntryRenderer renderer, int column) {
        return renderer.getToolTipForCombinedItems(entries, this.getEntryContext(), this.getColumnContext(column));
    }

    public String getSkippedChildrenToolTip(SkippedChildrenItem item, ProviderEntry[] entries, EntryRenderer renderer, int column) {
        return renderer.getToolTipForSkippedChildren(entries, this.getEntryContext(), this.getColumnContext(column));
    }

    public String getToggleSkippedChildrenToolTip(SkippedChildrenItem item, ProviderEntry[] entries, EntryRenderer renderer, int column) {
        return renderer.getToolTipForSkippedChildren(entries, this.getEntryContext(), this.getColumnContext(column), false);
    }

    public String getToggleNormalItemToolTip(NormalItem item, ProviderEntry entry, EntryRenderer renderer, int column) {
        return renderer.getToolTip(entry, this.getEntryContext(), this.getColumnContext(column), item.isExpanded());
    }

    public TreeChildCombiner createTreeChildCombiner() {
        return new TypedTreeChildCombiner(0.9);
    }
}

