/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.presentation.typed.entries.BaseQuantity;
import com.sap.jvm.profiling.presentation.typed.entries.NormalString;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfEntries;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.presentation.typed.entries.SummarizedProviderEntry;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.viewer.tree.MultiItem;
import com.sap.jvm.profiling.viewer.tree.NormalItem;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TypedTreeSummarizer {
    private final TypedTreeModel model;
    private final Item[] items;
    private final TypedColumnSpec spec;
    private final ProviderEntry[] sums;
    private final ProviderEntry[] averages;
    private final ProviderEntry[] medians;
    private final ProviderEntry[] perc90th;
    private final ProviderEntry[] perc75th;
    private final ProviderEntry[] perc25th;
    private final ProviderEntry[] perc10th;
    private final ProviderEntry[] minimums;
    private final ProviderEntry[] maximums;
    private final ProviderEntry[] zeroEntries;
    private final ProviderEntry[] nonZeroEntries;
    private ArrayList<ProviderEntry[]> enumerations;
    private ProviderEntry[][] entries;
    private final HashSet<Integer> columnsWithSum;
    private final HashSet<Integer> columnsWithAverage;
    private final HashSet<Integer> columnsWithMinMax;
    private final HashSet<Integer> columnsWithNonZero;
    private final HashSet<Integer> columnsWithEnumeration;
    private long work;
    private int nrOfRows;

    public TypedTreeSummarizer(TypedTreeModel model, boolean summarizeAll) {
        int i;
        this.model = model;
        this.spec = new TypedColumnSpec(model.getSpec()).prepend("", "", 0, NormalString.class, "summary");
        this.spec.setDefaultVisibleSets(model.getColumnVisibility());
        this.nrOfRows = model.getSelectedItems().length;
        TreeModelItem[] rawItems = summarizeAll || this.nrOfRows < 1 ? model.getRootItems() : model.getSelectedItems();
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (TreeModelItem item : rawItems) {
            if (item instanceof NormalItem) {
                itemList.add(new Item(item, 0));
                continue;
            }
            if (!(item instanceof MultiItem)) continue;
            int count = ((MultiItem)item).getNodes().length;
            for (i = 0; i < count; ++i) {
                itemList.add(new Item(item, i));
            }
        }
        this.items = itemList.toArray(new Item[itemList.size()]);
        this.nrOfRows = this.items.length;
        this.sums = new ProviderEntry[model.getNrOfColumns() + 1];
        this.averages = new ProviderEntry[model.getNrOfColumns() + 1];
        this.medians = new ProviderEntry[model.getNrOfColumns() + 1];
        this.perc90th = new ProviderEntry[model.getNrOfColumns() + 1];
        this.perc75th = new ProviderEntry[model.getNrOfColumns() + 1];
        this.perc25th = new ProviderEntry[model.getNrOfColumns() + 1];
        this.perc10th = new ProviderEntry[model.getNrOfColumns() + 1];
        this.minimums = new ProviderEntry[model.getNrOfColumns() + 1];
        this.maximums = new ProviderEntry[model.getNrOfColumns() + 1];
        this.zeroEntries = new ProviderEntry[model.getNrOfColumns() + 1];
        this.nonZeroEntries = new ProviderEntry[model.getNrOfColumns() + 1];
        this.columnsWithSum = new HashSet();
        this.columnsWithAverage = new HashSet();
        this.columnsWithMinMax = new HashSet();
        this.columnsWithNonZero = new HashSet();
        this.columnsWithEnumeration = new HashSet();
        HashSet<Integer> columnsWithWork = new HashSet<Integer>();
        if (this.nrOfRows > 0) {
            ProviderEntry entry;
            block2: for (int column : model.getSpec().getColumnsToSum()) {
                if (!model.isColumnVisible(column)) continue;
                for (i = 0; i < itemList.size(); ++i) {
                    entry = this.getEntry((Item)itemList.get(i), column);
                    if (!(entry instanceof Quantity)) continue;
                    this.columnsWithSum.add(column);
                    columnsWithWork.add(column);
                    continue block2;
                }
            }
            block4: for (int column : model.getSpec().getColumnsToAverage()) {
                if (!model.isColumnVisible(column)) continue;
                for (i = 0; i < itemList.size(); ++i) {
                    entry = this.getEntry((Item)itemList.get(i), column);
                    if (!(entry instanceof Quantity)) continue;
                    this.columnsWithAverage.add(column);
                    columnsWithWork.add(column);
                    continue block4;
                }
            }
            block6: for (int column : model.getSpec().getColumnsToMinMax()) {
                if (!model.isColumnVisible(column)) continue;
                for (i = 0; i < itemList.size(); ++i) {
                    entry = this.getEntry((Item)itemList.get(i), column);
                    if (!(entry instanceof Quantity)) continue;
                    this.columnsWithMinMax.add(column);
                    columnsWithWork.add(column);
                    continue block6;
                }
            }
            block8: for (int column : model.getSpec().getColumnsToNonZero()) {
                if (!model.isColumnVisible(column)) continue;
                for (i = 0; i < itemList.size(); ++i) {
                    entry = this.getEntry((Item)itemList.get(i), column);
                    if (!(entry instanceof Quantity)) continue;
                    this.columnsWithNonZero.add(column);
                    columnsWithWork.add(column);
                    continue block8;
                }
            }
            block10: for (int column : model.getSpec().getColumnsToEnumerate()) {
                if (!model.isColumnVisible(column)) continue;
                for (i = 0; i < itemList.size(); ++i) {
                    entry = this.getEntry((Item)itemList.get(i), column);
                    if (entry == null) continue;
                    this.columnsWithEnumeration.add(column);
                    columnsWithWork.add(column);
                    continue block10;
                }
            }
        }
        ArrayList<ProviderEntry[]> rows = new ArrayList<ProviderEntry[]>();
        if (!this.columnsWithMinMax.isEmpty()) {
            this.minimums[0] = new NormalString(I18n._s((String)"Minimum"));
            this.maximums[0] = new NormalString(I18n._s((String)"Maximum"));
            rows.add(this.minimums);
            rows.add(this.maximums);
        }
        if (!this.columnsWithSum.isEmpty()) {
            this.sums[0] = new NormalString(I18n._s((String)"Sum"));
            rows.add(this.sums);
        }
        if (!this.columnsWithNonZero.isEmpty()) {
            this.zeroEntries[0] = new NormalString(I18n._s((String)"Zero entry count"));
            this.nonZeroEntries[0] = new NormalString(I18n._s((String)"Non-Zero entry count"));
            rows.add(this.zeroEntries);
            rows.add(this.nonZeroEntries);
        }
        if (!this.columnsWithAverage.isEmpty()) {
            this.averages[0] = new NormalString(I18n._s((String)"Average"));
            rows.add(this.averages);
            this.medians[0] = new NormalString(I18n._s((String)"Median"));
            rows.add(this.medians);
            this.perc10th[0] = new NormalString(I18n._s((String)"10th Percentile"));
            rows.add(this.perc10th);
            this.perc25th[0] = new NormalString(I18n._s((String)"25th Percentile"));
            rows.add(this.perc25th);
            this.perc75th[0] = new NormalString(I18n._s((String)"75th Percentile"));
            rows.add(this.perc75th);
            this.perc90th[0] = new NormalString(I18n._s((String)"90th Percentile"));
            rows.add(this.perc90th);
        }
        for (int i2 = 0; i2 < model.getNrOfColumns(); ++i2) {
            if (columnsWithWork.contains(i2)) continue;
            this.spec.makeInvisible(i2 + 1);
        }
        this.spec.removeDefaultSorting();
        this.work = columnsWithWork.size() * this.nrOfRows;
        this.entries = (ProviderEntry[][])rows.toArray((T[])new ProviderEntry[rows.size()][]);
    }

    public int getNrOfSummarizedRows() {
        return this.nrOfRows;
    }

    private ProviderEntry getEntry(Item item, int column) {
        if (item.item instanceof NormalItem) {
            return this.model.getEntryForNormalItem((NormalItem)item.item, column);
        }
        if (item.item instanceof MultiItem) {
            return this.model.getEntriesForMultiItem((MultiItem)item.item, column)[item.index];
        }
        return null;
    }

    public void createData(ProgressReporter reporter) throws IOException {
        reporter.addWork(I18n._s((String)"Summarizing (<%> %)"), this.work);
        if (this.nrOfRows > 0) {
            for (int column = 0; column < this.model.getSpec().getNrOfColumns(); ++column) {
                boolean hasSum = this.columnsWithSum.contains(column);
                boolean hasAverage = this.columnsWithAverage.contains(column);
                boolean hasMinMax = this.columnsWithMinMax.contains(column);
                boolean hasNonZero = this.columnsWithNonZero.contains(column);
                boolean hasEnumeration = this.columnsWithEnumeration.contains(column);
                if (hasSum || hasAverage || hasMinMax) {
                    long sum = 0L;
                    long zero = 0L;
                    long nonZero = 0L;
                    Quantity entry = null;
                    long min = Long.MAX_VALUE;
                    long max = Long.MIN_VALUE;
                    int nonNullRows = 0;
                    long[] rawValues = null;
                    LongColumnBase base = null;
                    if (hasAverage) {
                        base = new LongColumnBase(1);
                        rawValues = new long[this.items.length];
                        base.setNrOfRows((int)this.items.length)[0] = rawValues;
                    }
                    for (int i = 0; i < this.items.length; ++i) {
                        reporter.reportNextOrThrow();
                        Quantity curr = (Quantity)this.getEntry(this.items[i], column);
                        if (curr == null) {
                            if (rawValues == null) continue;
                            rawValues[i] = Long.MAX_VALUE;
                            continue;
                        }
                        entry = curr;
                        long q = curr.getQuantity();
                        sum += q;
                        min = Math.min(min, q);
                        max = Math.max(max, q);
                        if (q != 0L) {
                            ++nonZero;
                        } else {
                            ++zero;
                        }
                        if (rawValues != null) {
                            rawValues[i] = q;
                        }
                        ++nonNullRows;
                    }
                    if (nonNullRows == 0) continue;
                    if (hasSum) {
                        this.sums[column + 1] = TypedTreeSummarizer.createQuantity(entry, sum);
                    }
                    if (hasNonZero) {
                        this.zeroEntries[column + 1] = NrOfEntries.PROTOTYPE.create(zero);
                        this.nonZeroEntries[column + 1] = NrOfEntries.PROTOTYPE.create(nonZero);
                    }
                    if (hasAverage) {
                        Quantity quantity;
                        base.convertColumnIfPossible(0);
                        this.averages[column + 1] = TypedTreeSummarizer.createQuantity(entry, sum / (long)nonNullRows);
                        int[] order = new int[this.items.length];
                        for (int i = 0; i < nonNullRows; ++i) {
                            order[i] = i;
                        }
                        int nrOfThreads = this.model.getResourceName().getSession().getNrOfThreads();
                        order = base.sortAscending(order, 0, nrOfThreads);
                        Item medianItem = this.items[order[nonNullRows / 2]];
                        Item perc90thItem = this.items[order[nonNullRows / 10 * 9]];
                        Item perc75thItem = this.items[order[nonNullRows / 4 * 3]];
                        Item perc25thItem = this.items[order[nonNullRows / 4 * 1]];
                        Item perc10thItem = this.items[order[nonNullRows / 10 * 1]];
                        if (nonNullRows < 0xCCCCCCC) {
                            perc90thItem = this.items[order[nonNullRows * 9 / 10]];
                            perc75thItem = this.items[order[nonNullRows * 3 / 4]];
                            perc25thItem = this.items[order[nonNullRows * 1 / 4]];
                            perc10thItem = this.items[order[nonNullRows * 1 / 10]];
                        }
                        this.medians[column + 1] = TypedTreeSummarizer.createQuantity(entry, (quantity = (Quantity)this.getEntry(medianItem, column)) != null ? quantity.getQuantity() : 0L);
                        quantity = (Quantity)this.getEntry(perc90thItem, column);
                        this.perc90th[column + 1] = TypedTreeSummarizer.createQuantity(entry, quantity != null ? quantity.getQuantity() : 0L);
                        quantity = (Quantity)this.getEntry(perc75thItem, column);
                        this.perc75th[column + 1] = TypedTreeSummarizer.createQuantity(entry, quantity != null ? quantity.getQuantity() : 0L);
                        quantity = (Quantity)this.getEntry(perc25thItem, column);
                        this.perc25th[column + 1] = TypedTreeSummarizer.createQuantity(entry, quantity != null ? quantity.getQuantity() : 0L);
                        quantity = (Quantity)this.getEntry(perc10thItem, column);
                        this.perc10th[column + 1] = TypedTreeSummarizer.createQuantity(entry, quantity != null ? quantity.getQuantity() : 0L);
                    }
                    if (!hasMinMax) continue;
                    this.minimums[column + 1] = TypedTreeSummarizer.createQuantity(entry, min);
                    this.maximums[column + 1] = TypedTreeSummarizer.createQuantity(entry, max);
                    continue;
                }
                if (!hasEnumeration) continue;
                HashMap<ProviderEntry, long[]> counts = new HashMap<ProviderEntry, long[]>();
                for (Item item : this.items) {
                    reporter.reportNextOrThrow();
                    ProviderEntry curr = this.getEntry(item, column);
                    long[] count = (long[])counts.get(curr);
                    if (count == null) {
                        count = new long[]{1L};
                        counts.put(curr, count);
                        continue;
                    }
                    count[0] = count[0] + 1L;
                }
                if (this.enumerations == null) {
                    this.enumerations = new ArrayList();
                }
                ArrayList sorted = new ArrayList(counts.entrySet());
                Collections.sort(sorted, new Comparator<Map.Entry<ProviderEntry, long[]>>(){

                    @Override
                    public int compare(Map.Entry<ProviderEntry, long[]> o1, Map.Entry<ProviderEntry, long[]> o2) {
                        return -Long.valueOf(o1.getValue()[0]).compareTo(o2.getValue()[0]);
                    }
                });
                for (int i = 0; i < sorted.size(); ++i) {
                    if (this.enumerations.size() <= i) {
                        this.enumerations.add(new ProviderEntry[this.model.getNrOfColumns() + 1]);
                        if (i == 0) {
                            this.enumerations.get((int)0)[0] = new NormalString(I18n._s((String)"Summary"));
                        }
                    }
                    Map.Entry entry = sorted.get(i);
                    this.enumerations.get((int)i)[column + 1] = new SummarizedProviderEntry((ProviderEntry)entry.getKey(), ((long[])entry.getValue())[0]);
                }
            }
        }
        if (this.enumerations != null) {
            ProviderEntry[][] newEntries = new ProviderEntry[this.entries.length + this.enumerations.size()][];
            System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
            for (int i = 0; i < this.enumerations.size(); ++i) {
                newEntries[i + this.entries.length] = this.enumerations.get(i);
            }
            this.entries = newEntries;
        }
    }

    private static Quantity createQuantity(Quantity blueprint, long value) {
        if (blueprint == null) {
            return null;
        }
        if (blueprint instanceof BaseQuantity) {
            BaseQuantity q = (BaseQuantity)blueprint;
            return q.create(value);
        }
        try {
            Constructor<?> ctor = blueprint.getClass().getConstructor(Long.TYPE);
            return (Quantity)ctor.newInstance(value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Trace.error((Throwable)e, (String)"Could not create quantity");
            return null;
        }
    }

    public TypedTreeModel getModel() {
        return this.model;
    }

    public int getNrOfRows() {
        return this.entries.length;
    }

    public TypedColumnSpec getSpec() {
        return this.spec;
    }

    public ProviderEntry getEntry(int row, int column) {
        return this.entries[row][column];
    }

    private static class Item {
        public final TreeModelItem item;
        public final int index;

        public Item(TreeModelItem item, int index) {
            this.item = item;
            this.index = index;
        }
    }
}

