/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import com.sap.jvm.profiling.presentation.typed.AbstractTableBasedProvider;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public abstract class TypedValueSetProvider<T, R>
extends AbstractTableBasedProvider {
    private final TypedColumnSpec columnSpec;
    private final String title;
    private final String iconKey;
    protected T statistic;

    public TypedValueSetProvider(TypedColumnSpec columnSpec, String title, String iconKey, ResourceName name) {
        super(name);
        this.columnSpec = TypedValueSetProvider.sanitizeColumnSpec(columnSpec);
        this.title = title;
        this.iconKey = iconKey;
    }

    protected abstract ResourceName getStatisticName();

    public abstract String getRowName(int var1);

    public abstract R getRowType(int var1);

    public abstract String getRowToolTip(int var1);

    public abstract String getRowColorTag(int var1);

    public String getIconKey() {
        return this.iconKey;
    }

    public final void valueSetCreated() {
        ProgressReporter reporter = new ProgressReporter();
        try {
            this.initializeContext(reporter);
        }
        catch (OperationCanceledException e) {
            Trace.warn((Throwable)e, (String)"Operation cancelled");
        }
        finally {
            reporter.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createStatistic(ProgressReporter reporter) throws IOException {
        TypedValueSetProvider typedValueSetProvider = this;
        synchronized (typedValueSetProvider) {
            if (this.statistic != null) {
                return;
            }
        }
        ResourceName statisticName = this.getStatisticName();
        Resource result = statisticName.getResourceManager().get(statisticName, reporter);
        TypedValueSetProvider typedValueSetProvider2 = this;
        synchronized (typedValueSetProvider2) {
            if (this.statistic == null) {
                this.statistic = result;
            }
        }
    }

    public final ResourceName[] getDependents() {
        return new ResourceName[]{this.getStatisticName()};
    }

    public final T getStatistic() {
        return this.statistic;
    }

    @Override
    public abstract Quantity getEntry(int var1, int var2);

    public final long getValue(int row, int column) {
        return this.getEntry(row, column).getQuantity();
    }

    @Override
    public final TypedColumnSpec getColumnSpec() {
        return this.columnSpec;
    }

    public final String getTitle() {
        return this.title;
    }

    private static TypedColumnSpec sanitizeColumnSpec(TypedColumnSpec spec) {
        for (VisibilitySet set : spec.getColumnVisibilitySets()) {
            boolean noQuantity = true;
            for (int column : set.getColumns()) {
                if (!Quantity.class.isAssignableFrom(spec.getColumnType(column))) continue;
                noQuantity = false;
                break;
            }
            if (!noQuantity) continue;
            spec.disableVisibilitySets(set.getId());
        }
        return spec;
    }
}

