/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed;

import java.util.Arrays;

public final class VisibilitySet {
    private final String id;
    private final String displayName;
    private final String groupId;
    private final String iconName;
    private final String toolTip;
    private final int[] columns;
    private final boolean isDisabled;
    private final boolean isAlwaysActive;

    public VisibilitySet(String id, String groupId, String displayName, String iconName, String toolTip, Integer ... columns) {
        this.id = id;
        this.groupId = groupId;
        this.displayName = displayName;
        this.iconName = iconName;
        this.toolTip = toolTip;
        this.columns = new int[columns.length];
        this.isDisabled = false;
        this.isAlwaysActive = false;
        for (int i = 0; i < columns.length; ++i) {
            this.columns[i] = columns[i];
        }
    }

    private VisibilitySet(VisibilitySet other, boolean isDisabled, boolean isAlwaysActive) {
        this.id = other.id;
        this.displayName = other.displayName;
        this.groupId = other.groupId;
        this.iconName = other.iconName;
        this.toolTip = other.toolTip;
        this.columns = other.columns;
        this.isDisabled = isDisabled;
        this.isAlwaysActive = isAlwaysActive;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public int[] getColumns() {
        return this.columns;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public boolean isAlwaysActive() {
        return this.isAlwaysActive;
    }

    public VisibilitySet getDisabled() {
        return new VisibilitySet(this, true, this.isAlwaysActive);
    }

    public VisibilitySet getAlwaysActive() {
        return new VisibilitySet(this, this.isDisabled, true);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("VisibilitySet\n");
        result.append("Id            : " + this.id + "\n");
        result.append("Group Id      : " + this.groupId + "\n");
        result.append("Icon Name     : " + this.iconName + "\n");
        result.append("Tool Tip      : " + this.toolTip + "\n");
        result.append("Disabled      : " + this.isDisabled + "\n");
        result.append("Always Active : " + this.isAlwaysActive + "\n");
        result.append("Columns       : " + Arrays.toString(this.columns) + "\n");
        return result.toString();
    }
}

