/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;

public class AmountByAge
implements ProviderEntry {
    private final long[] distribution;
    private final long total;
    private final long max;

    public AmountByAge(int[] amounts) {
        this.distribution = new long[amounts.length];
        long totalTmp = 0L;
        long maxTmp = 0L;
        for (int i = 0; i < amounts.length; ++i) {
            long amount;
            this.distribution[i] = amount = (long)amounts[i];
            totalTmp += amount;
            maxTmp = Math.max(amount, maxTmp);
        }
        this.total = totalTmp;
        this.max = maxTmp;
    }

    public AmountByAge(long[] amounts) {
        this.distribution = new long[amounts.length];
        long totalTmp = 0L;
        long maxTmp = 0L;
        for (int i = 0; i < amounts.length; ++i) {
            long amount;
            this.distribution[i] = amount = amounts[i];
            totalTmp += amount;
            maxTmp = Math.max(amount, maxTmp);
        }
        this.total = totalTmp;
        this.max = maxTmp;
    }

    public long getTotal() {
        return this.total;
    }

    public long getMax() {
        return this.max;
    }

    public long[] getDistribution() {
        return this.distribution;
    }

    @Override
    public int compareTo(ProviderEntry otherEntry, EntryContext context) {
        AmountByAge other = (AmountByAge)otherEntry;
        if (other.distribution.length != this.distribution.length) {
            if (this.distribution.length < other.distribution.length) {
                return -1;
            }
            return 1;
        }
        for (int i = 0; i < this.distribution.length; ++i) {
            if (this.distribution[i] < other.distribution[i]) {
                return -1;
            }
            if (this.distribution[i] <= other.distribution[i]) continue;
            return 1;
        }
        return 0;
    }

    public static long[] getSum(ProviderEntry[] entries) {
        int maxDistrLength = 0;
        for (int i = 0; i < entries.length; ++i) {
            maxDistrLength = Math.max(maxDistrLength, ((AmountByAge)entries[i]).distribution.length);
        }
        long[] sum = new long[maxDistrLength];
        for (int i = 0; i < entries.length; ++i) {
            AmountByAge entry = (AmountByAge)entries[i];
            for (int age = 0; age < entry.distribution.length; ++age) {
                int n = age;
                sum[n] = sum[n] + entry.distribution[age];
            }
        }
        return sum;
    }
}

