/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ArrayLengthRangePers;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;

public class ArrayLengthRange
implements UniqueEntry {
    private final int from;
    public final int to;

    public ArrayLengthRange(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    @Override
    public int compareToUnique(UniqueEntry o) {
        ArrayLengthRange other = (ArrayLengthRange)o;
        if (this.from < other.from) {
            return -1;
        }
        if (this.from > other.from) {
            return 1;
        }
        return Integer.valueOf(this.to).compareTo(other.to);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        return this.compareToUnique((UniqueEntry)other);
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return new ArrayLengthRangePers(this.from, this.to);
    }
}

