/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.NrOfBytesFormat;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.entries.DiffEntryUtils;
import com.sap.jvm.profiling.presentation.typed.entries.Diffable;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public abstract class BaseQuantity<T extends BaseQuantity<T>>
implements Quantity,
Diffable,
Difference {
    private static final String[] subColumnTitles = new String[]{DiffEntryUtils.DIFFERENCE_COLUMN_SUBTITEL, DiffEntryUtils.OLD_VALUE_COLUMN_SUBTITEL, DiffEntryUtils.NEW_VALUE_COLUMN_SUBTITEL};
    private long quantity;
    private long totalQuantity;
    private long displayedQuantity;
    private long parentQuantity;
    private boolean showSign;
    private boolean asPercentageOfMax;
    private boolean isDiff;

    protected abstract T create();

    public void set(long quantity) {
        this.quantity = quantity;
        this.totalQuantity = -1L;
        this.displayedQuantity = -1L;
        this.parentQuantity = -1L;
        this.showSign = false;
        this.asPercentageOfMax = false;
        this.isDiff = false;
    }

    public T create(long quantity) {
        T result = this.create();
        ((BaseQuantity)result).set(quantity);
        return result;
    }

    public void setDiff(long oldValue, long diff) {
        this.quantity = diff;
        this.totalQuantity = oldValue;
        this.displayedQuantity = -1L;
        this.parentQuantity = -1L;
        this.showSign = false;
        this.asPercentageOfMax = false;
        this.isDiff = true;
    }

    public T createDiff(long oldValue, long diff) {
        T result = this.create();
        ((BaseQuantity)result).setDiff(oldValue, diff);
        return result;
    }

    public void set(long quantity, boolean asPercentageOfMax) {
        this.quantity = quantity;
        this.totalQuantity = -1L;
        this.displayedQuantity = -1L;
        this.parentQuantity = -1L;
        this.showSign = false;
        this.asPercentageOfMax = asPercentageOfMax;
        this.isDiff = false;
    }

    public T create(long quantity, boolean asPercentageOfMax) {
        T result = this.create();
        ((BaseQuantity)result).set(quantity, asPercentageOfMax);
        return result;
    }

    public void set(long quantity, long totalQuantity) {
        this.quantity = quantity;
        this.totalQuantity = totalQuantity;
        this.displayedQuantity = -1L;
        this.parentQuantity = -1L;
        this.showSign = false;
        this.asPercentageOfMax = false;
        this.isDiff = false;
    }

    public T create(long quantity, long totalQuantity) {
        T result = this.create();
        ((BaseQuantity)result).set(quantity, totalQuantity);
        return result;
    }

    public void set(long quantity, long totalQuantity, boolean showSign) {
        this.quantity = quantity;
        this.totalQuantity = totalQuantity;
        this.displayedQuantity = -1L;
        this.parentQuantity = -1L;
        this.showSign = showSign;
        this.asPercentageOfMax = false;
        this.isDiff = false;
    }

    public T create(long quantity, long totalQuantity, boolean showSign) {
        T result = this.create();
        ((BaseQuantity)result).set(quantity, totalQuantity, showSign);
        return result;
    }

    public void set(long quantity, long totalQuantity, long displayedQuantity) {
        this.quantity = quantity;
        this.totalQuantity = totalQuantity;
        this.displayedQuantity = displayedQuantity;
        this.parentQuantity = -1L;
        this.showSign = false;
        this.asPercentageOfMax = false;
        this.isDiff = false;
    }

    public T create(long quantity, long totalQuantity, long displayedQuantity) {
        T result = this.create();
        ((BaseQuantity)result).set(quantity, totalQuantity, displayedQuantity);
        return result;
    }

    public void set(long quantity, long totalQuantity, long displayedQuantity, long parentQuantity) {
        this.quantity = quantity;
        this.totalQuantity = totalQuantity;
        this.displayedQuantity = displayedQuantity;
        this.parentQuantity = parentQuantity;
        this.showSign = false;
        this.asPercentageOfMax = false;
        this.isDiff = false;
    }

    public T create(long quantity, long totalQuantity, long displayedQuantity, long parentQuantity) {
        T result = this.create();
        ((BaseQuantity)result).set(quantity, totalQuantity, displayedQuantity, parentQuantity);
        return result;
    }

    @Override
    public long getQuantity() {
        return this.quantity;
    }

    public long getTotalQuantity() {
        return this.totalQuantity;
    }

    public long getDisplayedQuantity() {
        return this.displayedQuantity;
    }

    public long getParentQuantity() {
        return this.parentQuantity;
    }

    public boolean asPercentageOfMax() {
        return this.asPercentageOfMax;
    }

    public boolean hasTotalPercentage() {
        return this.totalQuantity >= 0L;
    }

    public boolean hasDisplayedPercentage() {
        return this.displayedQuantity >= 0L;
    }

    public boolean hasParentPercentage() {
        return this.parentQuantity >= 0L;
    }

    public synchronized boolean hasPercentage() {
        return this.totalQuantity >= 0L;
    }

    public double getPercentage() {
        if (this.parentQuantity >= 0L) {
            return this.getParentPercentage();
        }
        if (this.displayedQuantity >= 0L) {
            return this.getDisplayedPercentage();
        }
        return this.getTotalPercentage();
    }

    public double getTotalPercentage() {
        if (this.totalQuantity == 0L) {
            return 0.0;
        }
        return (double)Math.abs(this.quantity) / (double)this.totalQuantity;
    }

    public double getDisplayedPercentage() {
        if (this.displayedQuantity == 0L) {
            return 0.0;
        }
        return (double)Math.abs(this.quantity) / (double)this.displayedQuantity;
    }

    public double getParentPercentage() {
        if (this.parentQuantity == 0L) {
            return 0.0;
        }
        return (double)Math.abs(this.quantity) / (double)this.parentQuantity;
    }

    public boolean showSign() {
        return this.showSign;
    }

    public boolean isDiff() {
        return this.isDiff;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        BaseQuantity otherQuantity = (BaseQuantity)other;
        return this.quantity < otherQuantity.quantity ? -1 : (this.quantity > otherQuantity.quantity ? 1 : 0);
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        long diff = reader.readInt64();
        long old = reader.readInt64();
        return this.createDiff(old, diff);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.quantity);
        writer.writeInt64(this.totalQuantity);
    }

    @Override
    public Class<? extends ProviderEntry>[] getSubColumnTypes() {
        Class<?> type = this.getClass();
        return new Class[]{type, type, type};
    }

    @Override
    public String[] getSubColumnTitles() {
        return subColumnTitles;
    }

    @Override
    public int getNrOfStandardSubColumns() {
        return 1;
    }

    @Override
    public ProviderEntry getSubColumnEntry(int subColId) {
        if (subColId == 0) {
            return this;
        }
        if (subColId == 1) {
            return this.getOldValue();
        }
        if (subColId == 2) {
            return this.getNewValue();
        }
        throw new IllegalArgumentException("subColId must be in range 0..2");
    }

    @Override
    public boolean isNull() {
        return this.quantity == 0L;
    }

    @Override
    public ProviderEntry getOldValue() {
        assert (this.isDiff);
        return this.create(this.totalQuantity);
    }

    public long getDiffValue() {
        assert (this.isDiff);
        return this.quantity;
    }

    @Override
    public ProviderEntry getNewValue() {
        assert (this.isDiff);
        return this.create(this.quantity + this.totalQuantity);
    }

    @Override
    public Difference getDifference(ProviderEntry newEntry, ProviderEntry oldEntry) {
        long old = oldEntry == null ? 0L : ((BaseQuantity)oldEntry).quantity;
        long diff = DiffEntryUtils.getDiffQuantity((BaseQuantity)newEntry, (BaseQuantity)oldEntry);
        return this.createDiff(old, diff);
    }

    @Override
    public ProviderEntry getAccumulation(ProviderEntry[] entries) {
        long sum = 0L;
        for (ProviderEntry entry : entries) {
            sum += ((BaseQuantity)entry).quantity;
        }
        return this.create(sum);
    }

    public static class ParentToolTip {
        public final String text;

        public ParentToolTip(String text) {
            this.text = text;
        }
    }

    public static class ViewToolTip {
        public final String text;

        public ViewToolTip(String text) {
            this.text = text;
        }
    }

    public static class SnapshotToolTip {
        public final String text;

        public SnapshotToolTip(String text) {
            this.text = text;
        }
    }

    public static class SingleToolTip {
        public final String text;

        public SingleToolTip(String text) {
            this.text = text;
        }
    }

    public static class AxisToolTip {
        public final String text;

        public AxisToolTip(String text) {
            this.text = text;
        }
    }

    public static class DiffToolTip {
        public final String text;

        public DiffToolTip(String text) {
            this.text = text;
        }
    }

    public static class DurationUnits
    extends Units {
        private static final long ns = 1L;
        private static final long us = 1000L;
        private static final long ms = 1000000L;
        private static final long s = 1000000000L;
        private static final long m = 60000000000L;
        private static final long h = 3600000000000L;
        private static final long d = 86400000000000L;
        private static final long y = 31536000000000000L;
        private static final long[] factorsDec = new long[]{1L, 2L, 5L, 10L, 20L, 50L, 100L, 200L, 500L};
        private static final long[] factorsSix = new long[]{1L, 2L, 5L, 10L, 20L};
        public static final long[][] defaultDurationScales = new long[][]{factorsDec, factorsDec, factorsDec, factorsSix, factorsSix, factorsDec, factorsDec, factorsDec};
        public static final long[] defaultDurationFactors = new long[]{1L, 1000L, 1000000L, 1000000000L, 60000000000L, 3600000000000L, 86400000000000L, 31536000000000000L};
        public static final String[] defaultDurationUnitNames = new String[]{I18n._ss((String)"Unit|nanoseconds", (String)"ns"), I18n._ss((String)"Unit|microseconds", (String)"\u00b5s"), I18n._ss((String)"Unit|milliseonds", (String)"ms"), I18n._ss((String)"Unit|seconds", (String)"s"), I18n._ss((String)"Unit|minutes", (String)"m"), I18n._ss((String)"Unit|hours", (String)"h"), I18n._ss((String)"Unit|days", (String)"d"), I18n._ss((String)"Unit|years", (String)"y")};

        public DurationUnits() {
            this(defaultDurationUnitNames);
        }

        public DurationUnits(String ... units) {
            super(units, defaultDurationFactors, defaultDurationScales);
        }

        @Override
        public int getDefaultFormat(RendererThemeSpec theme) {
            return -1;
        }
    }

    public static class ByteUnits
    extends Units {
        private static final long[] defaultFactors = new long[]{1L, 2L, 5L, 10L, 20L, 50L, 100L, 200L, 500L};
        private static final long k = 1024L;
        private static final long M = 0x100000L;
        private static final long G = 0x40000000L;
        private static final long T = 0x10000000000L;
        private static final long P = 0x4000000000000L;
        public static final long[][] defaultByteScales = new long[][]{defaultFactors, defaultFactors, defaultFactors, defaultFactors, defaultFactors, defaultFactors};
        public static final long[] defaultByteFactors = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x4000000000000L};
        public static final String[] defaultByteUnitNames = new String[]{I18n._ss((String)"Unit|bytes", (String)"B"), I18n._ss((String)"Unit|kilo bytes", (String)"KB"), I18n._ss((String)"Unit|mega bytes", (String)"MB"), I18n._ss((String)"Unit|giga bytes", (String)"GB"), I18n._ss((String)"Unit|tera bytes", (String)"TB"), I18n._ss((String)"Unit|peta bytes", (String)"PB")};

        public ByteUnits() {
            this(defaultByteUnitNames);
        }

        public ByteUnits(String ... units) {
            super(units, defaultByteFactors, defaultByteScales);
        }

        @Override
        public int getDefaultFormat(RendererThemeSpec theme) {
            return ByteUnits.convertByteFormat(theme.getNrOfBytesFormat());
        }

        public static int convertByteFormat(NrOfBytesFormat format) {
            switch (format) {
                case ALWAYS_GB: {
                    return 3;
                }
                case ALWAYS_KB: {
                    return 1;
                }
                case ALWAYS_MB: {
                    return 2;
                }
                case ALWAYS_PB: {
                    return 5;
                }
                case ALWAYS_TB: {
                    return 4;
                }
                case BEST_GLOBAL_UNIT: {
                    return -2;
                }
                case BEST_UNIT: {
                    return -1;
                }
                case NO_UNIT: {
                    return 0;
                }
            }
            return -1;
        }
    }

    public static class Units {
        public static final long[] defaultScales;
        public final String[] units;
        public final long[] factors;
        public final long[][] scales;

        public Units(String unit) {
            this(new String[]{unit}, new long[]{1L});
        }

        public Units(String[] units, long[] factors) {
            this(units, factors, defaultScales);
        }

        public Units(String[] units, long[] factors, long[] scales) {
            this.units = units;
            this.factors = factors;
            this.scales = new long[][]{scales};
        }

        public Units(String[] units, long[] factors, long[][] scales) {
            this.units = units;
            this.factors = factors;
            this.scales = scales;
        }

        public int getDefaultFormat(RendererThemeSpec theme) {
            return 0;
        }

        static {
            int max = 15;
            defaultScales = new long[max * 3];
            long fac = 1L;
            for (int i = 0; i < max; ++i) {
                Units.defaultScales[i * 3 + 0] = fac;
                Units.defaultScales[i * 3 + 1] = 2L * fac;
                Units.defaultScales[i * 3 + 2] = 5L * fac;
                fac *= 10L;
            }
        }
    }

    public static class Tag {
        public final String tag;

        public Tag(String tag) {
            this.tag = tag;
        }
    }
}

