/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class BooleanType
implements PersistableProviderEntry {
    static final BooleanType readerInstance = Type.YES_NO.create(false);
    private final boolean value;
    private final Type type;
    private static String maximumText = null;

    public BooleanType(boolean value, Type type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        BooleanType otherBoolean = (BooleanType)other;
        return this.value == otherBoolean.value ? 0 : (this.value ? 1 : -1);
    }

    public boolean getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public String getValueText() {
        return this.value ? this.type.getTrueText() : this.type.getFalseText();
    }

    public String getValueToolTip() {
        return this.value ? this.type.getTrueToolTip() : this.type.getFalseToolTip();
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        boolean tmpValue = reader.readBoolean();
        Type tmpType = Type.values()[reader.readInt8()];
        return new BooleanType(tmpValue, tmpType);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeBoolean(this.value);
        writer.writeInt8(this.type.ordinal());
    }

    public static String getMaximumText() {
        if (maximumText == null) {
            String max = "";
            for (Type type : Type.values()) {
                if (type.getTrueText().length() > max.length()) {
                    max = type.getTrueText();
                }
                if (type.getFalseText().length() <= max.length()) continue;
                max = type.getFalseText();
            }
            maximumText = max;
        }
        return maximumText;
    }

    public int hashCode() {
        return this.value ? 0 : 1 + this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BooleanType) {
            BooleanType other = (BooleanType)obj;
            return this.value == other.value && this.type.equals((Object)other.type);
        }
        return false;
    }

    public static enum Type {
        YES_NO(I18n._s((String)"yes"), I18n._s((String)"no")),
        ON_OFF(I18n._s((String)"on"), I18n._s((String)"off")),
        TRUE_FALSE(I18n._s((String)"true"), I18n._s((String)"false")),
        ENABLED_DISABLED(I18n._s((String)"enabled"), I18n._s((String)"disabled")),
        TCP_UDP(I18n._s((String)"TCP/IP"), I18n._s((String)"Network connection using a stream socket with TCP/IP as protocol"), I18n._s((String)"UDP/IP"), I18n._s((String)"Network connection using a datagram socket with UDP/IP as protocol")),
        SERVER_CLIENT(I18n._s((String)"server"), I18n._s((String)"Server side of the network connection, i.e. the side on which accept(...) was called"), I18n._s((String)"client"), I18n._s((String)"Client side of the network connection, i.e. the side on which connect(...) was called")),
        YOUNG_MIXED(I18n._s((String)"young"), I18n._s((String)"Only young regions were garbage collected."), I18n._s((String)"mixed"), I18n._s((String)"Some old regions were garbage collected in addition to the young regions."));

        private String trueText;
        private String falseText;
        private final String trueToolTip;
        private final String falseToolTip;

        private Type(String trueText, String falseText) {
            this(trueText, trueText, falseText, falseText);
        }

        private Type(String trueText, String trueToolTip, String falseText, String falseToolTip) {
            this.trueText = trueText;
            this.trueToolTip = trueToolTip;
            this.falseText = falseText;
            this.falseToolTip = falseToolTip;
        }

        public String getTrueText() {
            return this.trueText;
        }

        public String getFalseText() {
            return this.falseText;
        }

        public String getTrueToolTip() {
            return this.trueToolTip;
        }

        public String getFalseToolTip() {
            return this.falseToolTip;
        }

        public BooleanType create(boolean value) {
            return new BooleanType(value, this);
        }
    }
}

