/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;

public class CalledMethod
implements UniqueEntry {
    private final MethodLocation location;

    public CalledMethod(MethodLocation location) {
        this.location = location;
    }

    public MethodObject getMethod() {
        return this.location.getMethod();
    }

    public int getLineNr() {
        return this.location.getLineNumber();
    }

    public MethodLocation getLocation() {
        return this.location;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        CalledMethod otherMethod = (CalledMethod)other;
        int result = this.location.compareToIgnoreCase(otherMethod.location);
        if (result != 0) {
            return result;
        }
        return this.location.compareByMethodIndexAndLineNr(otherMethod.location);
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        CalledMethod otherMethod = (CalledMethod)other;
        return this.location.compareByMethodIndexAndLineNr(otherMethod.location);
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        throw new UnsupportedOperationException();
    }
}

