/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class DeadlockCycleEntry
implements UniqueEntry,
PersistableProviderEntry {
    public static PersistableProviderEntry readerInstance = new DeadlockCycleEntry(-1, false);
    private final int deadlockCycle;
    private final boolean indirect;

    public DeadlockCycleEntry(int deadlockCycle, boolean indirect) {
        this.deadlockCycle = deadlockCycle;
        this.indirect = indirect;
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        return this.compareTo(other, null);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        DeadlockCycleEntry otherType = (DeadlockCycleEntry)other;
        int result = this.deadlockCycle - otherType.deadlockCycle;
        if (result == 0) {
            result = (this.indirect ? 1 : 0) - (otherType.indirect ? 1 : 0);
        }
        return result;
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return this;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        int deadlockCycleVal = reader.readInt32();
        boolean indirectVal = reader.readBoolean();
        return new DeadlockCycleEntry(deadlockCycleVal, indirectVal);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.deadlockCycle);
        writer.writeBoolean(this.indirect);
    }

    public int getDeadlockCycle() {
        return this.deadlockCycle;
    }

    public boolean isIndirect() {
        return this.indirect;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.deadlockCycle;
        result = 31 * result + (this.indirect ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeadlockCycleEntry other = (DeadlockCycleEntry)obj;
        if (this.deadlockCycle != other.deadlockCycle) {
            return false;
        }
        return this.indirect == other.indirect;
    }
}

