/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.DetailedTimeDistributionEntry;
import com.sap.jvm.profiling.presentation.typed.entries.DiffEntryUtils;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.tbs.SimpleTimeDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeDist;
import java.io.IOException;

public class DetailedTimeDistributionEntryDiff
implements Difference {
    static final DetailedTimeDistributionEntryDiff readerInstance = new DetailedTimeDistributionEntryDiff(SimpleTimeDist.EMPTY, SimpleTimeDist.EMPTY);
    static final String[] subColumnTitles = new String[]{DiffEntryUtils.OLD_VALUE_COLUMN_SUBTITEL, DiffEntryUtils.NEW_VALUE_COLUMN_SUBTITEL};
    static final Class<?>[] subColumnTypes = new Class[]{DetailedTimeDistributionEntry.class, DetailedTimeDistributionEntry.class};
    private SimpleTimeDist oldDistribution;
    private SimpleTimeDist newDistribution;

    public DetailedTimeDistributionEntryDiff(TimeDist oldDistribution, TimeDist newDistribution) {
        this.oldDistribution = new SimpleTimeDist(oldDistribution);
        this.newDistribution = new SimpleTimeDist(newDistribution);
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        return new DetailedTimeDistributionEntryDiff(new SimpleTimeDist(reader), new SimpleTimeDist(reader));
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        this.oldDistribution.write(writer);
        this.newDistribution.write(writer);
    }

    @Override
    public ProviderEntry getSubColumnEntry(int subColId) {
        if (subColId == 0) {
            return this.getOldValue();
        }
        if (subColId == 1) {
            return this.getNewValue();
        }
        throw new IllegalArgumentException("subColId (" + subColId + ") must be in range 0..1");
    }

    @Override
    public Class<? extends ProviderEntry>[] getSubColumnTypes() {
        return subColumnTypes;
    }

    @Override
    public String[] getSubColumnTitles() {
        return subColumnTitles;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        if (other == this) {
            return 0;
        }
        DetailedTimeDistributionEntryDiff otherEntry = (DetailedTimeDistributionEntryDiff)other;
        int result = this.oldDistribution.compareTo(otherEntry.oldDistribution);
        if (result != 0) {
            return result;
        }
        return this.newDistribution.compareTo(otherEntry.newDistribution);
    }

    @Override
    public boolean isNull() {
        return this.oldDistribution.compareTo(this.newDistribution) == 0;
    }

    @Override
    public int getNrOfStandardSubColumns() {
        return 2;
    }

    @Override
    public ProviderEntry getNewValue() {
        return new DetailedTimeDistributionEntry(this.newDistribution);
    }

    @Override
    public ProviderEntry getOldValue() {
        return new DetailedTimeDistributionEntry(this.oldDistribution);
    }
}

