/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.entries.ArrayLengthRange;
import com.sap.jvm.profiling.presentation.typed.entries.ArrayLengthRangePers;
import com.sap.jvm.profiling.presentation.typed.entries.BaseQuantity;
import com.sap.jvm.profiling.presentation.typed.entries.BasicTimeDistributionEntry;
import com.sap.jvm.profiling.presentation.typed.entries.BasicTimeDistributionEntryDiff;
import com.sap.jvm.profiling.presentation.typed.entries.BooleanType;
import com.sap.jvm.profiling.presentation.typed.entries.DetailedTimeDistributionEntry;
import com.sap.jvm.profiling.presentation.typed.entries.DetailedTimeDistributionEntryDiff;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.presentation.typed.entries.FileDescriptor;
import com.sap.jvm.profiling.presentation.typed.entries.GcCauseEntry;
import com.sap.jvm.profiling.presentation.typed.entries.GcTypeEntry;
import com.sap.jvm.profiling.presentation.typed.entries.LoadAverage;
import com.sap.jvm.profiling.presentation.typed.entries.LoadAverageDiff;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsage;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsageDiff;
import com.sap.jvm.profiling.presentation.typed.entries.NormalArrayLength;
import com.sap.jvm.profiling.presentation.typed.entries.NormalArrayLengthPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClass;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassLoader;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassLoaderPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileName;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntity;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntityPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntry;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntryPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalGcEventId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalGcId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethod;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodInvocationId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodInvocationIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMonitorId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMonitorIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkAddress;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkAddressPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkConnectionType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkConnectionTypePers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkEndpointType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkEndpointTypePers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkLatencyId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkLatencyIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkPort;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkPortPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackage;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackagePart;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackagePartPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackagePers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterSpec;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterSpecPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterValue;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterValuePers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalReentrantLockId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalReentrantLockIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSocketId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSocketIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalString;
import com.sap.jvm.profiling.presentation.typed.entries.NormalStringPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSynchronizationEventId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSynchronizationEventIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadAnnotation;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadAnnotationPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.presentation.typed.entries.Timestamp;
import com.sap.jvm.profiling.presentation.typed.entries.TimestampDiff;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.HashMap;

public class DiffEntryUtils {
    public static final String DIFFERENCE_COLUMN_SUBTITEL = I18n._ss((String)"Column subtitle for difference value", (String)"diff");
    public static final String OLD_VALUE_COLUMN_SUBTITEL = I18n._ss((String)"Column subtitle for old value", (String)"old");
    public static final String NEW_VALUE_COLUMN_SUBTITEL = I18n._ss((String)"Column subtitle for new value", (String)"new");
    public static final String OLD_VIEW_MARK_LABEL = I18n._ss((String)"View marking label for comparison source view", (String)"Old");
    public static final String NEW_VIEW_MARK_LABEL = I18n._ss((String)"View marking label for comparison source view", (String)"New");
    private static final HashMap<Class<? extends ProviderEntry>, PersistableProviderEntry> diffTypeMapping = new HashMap();

    public static PersistableProviderEntry read(Class<? extends ProviderEntry> baseEntryType, ResourceReader reader) throws IOException {
        return DiffEntryUtils.getDiffInstance(baseEntryType).read(reader);
    }

    private static PersistableProviderEntry getDiffInstance(Class<? extends ProviderEntry> baseEntryType) {
        PersistableProviderEntry diffInstance = diffTypeMapping.get(baseEntryType);
        if (diffInstance != null) {
            return diffInstance;
        }
        if (BaseQuantity.class.isAssignableFrom(baseEntryType)) {
            try {
                return (Difference)baseEntryType.getDeclaredField("PROTOTYPE").get(null);
            }
            catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                Trace.error((Throwable)e, (String)"Diff type is wrong");
            }
        }
        Trace.error(() -> "No difference type for " + baseEntryType.getName());
        return null;
    }

    public static Class<? extends ProviderEntry> getDifferenceType(Class<? extends ProviderEntry> baseEntryType) {
        return DiffEntryUtils.getDiffInstance(baseEntryType).getClass();
    }

    public static Class<? extends ProviderEntry>[] getSubColumnTypes(Class<? extends ProviderEntry> baseEntryType) {
        return ((Difference)DiffEntryUtils.getDiffInstance(baseEntryType)).getSubColumnTypes();
    }

    public static String[] getSubColumnTitles(Class<? extends ProviderEntry> baseEntryType) {
        return ((Difference)DiffEntryUtils.getDiffInstance(baseEntryType)).getSubColumnTitles();
    }

    public static int getNrOfStandardSubColumns(Class<? extends ProviderEntry> baseEntryType) {
        return ((Difference)DiffEntryUtils.getDiffInstance(baseEntryType)).getNrOfStandardSubColumns();
    }

    public static long getDiffQuantity(Quantity entry1, Quantity entry2) {
        long value1 = entry1 != null ? entry1.getQuantity() : 0L;
        long value2 = entry2 != null ? entry2.getQuantity() : 0L;
        return value1 - value2;
    }

    static {
        diffTypeMapping.put(BasicTimeDistributionEntry.class, BasicTimeDistributionEntryDiff.readerInstance);
        diffTypeMapping.put(DetailedTimeDistributionEntry.class, DetailedTimeDistributionEntryDiff.readerInstance);
        diffTypeMapping.put(MemoryUsage.class, MemoryUsageDiff.readerInstance);
        diffTypeMapping.put(Timestamp.class, TimestampDiff.readerInstance);
        diffTypeMapping.put(LoadAverage.class, LoadAverageDiff.readerInstance);
        diffTypeMapping.put(ArrayLengthRange.class, ArrayLengthRangePers.readerInstance);
        diffTypeMapping.put(BooleanType.class, BooleanType.readerInstance);
        diffTypeMapping.put(NormalArrayLength.class, NormalArrayLengthPers.readerInstance);
        diffTypeMapping.put(NormalClass.class, NormalClassPers.readerInstance);
        diffTypeMapping.put(NormalClassLoader.class, NormalClassLoaderPers.readerInstance);
        diffTypeMapping.put(NormalFileId.class, NormalFileIdPers.readerInstance);
        diffTypeMapping.put(NormalFilterEntry.class, NormalFilterEntryPers.readerInstance);
        diffTypeMapping.put(NormalFilterEntity.class, NormalFilterEntityPers.readerInstance);
        diffTypeMapping.put(NormalMethod.class, NormalMethodPers.readerInstance);
        diffTypeMapping.put(NormalMethodInvocationId.class, NormalMethodInvocationIdPers.readerInstance);
        diffTypeMapping.put(NormalMonitorId.class, NormalMonitorIdPers.readerInstance);
        diffTypeMapping.put(NormalNetworkAddress.class, NormalNetworkAddressPers.readerInstance);
        diffTypeMapping.put(NormalNetworkConnectionType.class, NormalNetworkConnectionTypePers.readerInstance);
        diffTypeMapping.put(NormalNetworkEndpointType.class, NormalNetworkEndpointTypePers.readerInstance);
        diffTypeMapping.put(NormalNetworkLatencyId.class, NormalNetworkLatencyIdPers.readerInstance);
        diffTypeMapping.put(NormalNetworkPort.class, NormalNetworkPortPers.readerInstance);
        diffTypeMapping.put(NormalPackage.class, NormalPackagePers.readerInstance);
        diffTypeMapping.put(NormalPackagePart.class, NormalPackagePartPers.readerInstance);
        diffTypeMapping.put(NormalParameterSpec.class, NormalParameterSpecPers.readerInstance);
        diffTypeMapping.put(NormalParameterValue.class, NormalParameterValuePers.readerInstance);
        diffTypeMapping.put(NormalReentrantLockId.class, NormalReentrantLockIdPers.readerInstance);
        diffTypeMapping.put(NormalSocketId.class, NormalSocketIdPers.readerInstance);
        diffTypeMapping.put(NormalString.class, NormalStringPers.readerInstance);
        diffTypeMapping.put(NormalSynchronizationEventId.class, NormalSynchronizationEventIdPers.readerInstance);
        diffTypeMapping.put(NormalThreadAnnotation.class, NormalThreadAnnotationPers.readerInstance);
        diffTypeMapping.put(NormalThreadId.class, NormalThreadIdPers.readerInstance);
        diffTypeMapping.put(NormalGcId.class, NormalGcId.readerInstance);
        diffTypeMapping.put(NormalGcEventId.class, NormalGcEventId.readerInstance);
        diffTypeMapping.put(GcCauseEntry.class, GcCauseEntry.readerInstance);
        diffTypeMapping.put(GcTypeEntry.class, GcTypeEntry.readerInstance);
        diffTypeMapping.put(FileDescriptor.class, FileDescriptor.readerInstance);
        diffTypeMapping.put(NormalClassType.class, NormalClassType.readerInstance);
        diffTypeMapping.put(NormalFileName.class, NormalFileName.readerInstance);
        diffTypeMapping.put(NormalThreadName.class, NormalThreadName.readerInstance);
    }
}

