/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public final class FileDescriptor
implements Quantity,
PersistableProviderEntry {
    static final FileDescriptor readerInstance = new FileDescriptor(0L);
    private long fd;

    public FileDescriptor(long fd) {
        this.fd = fd;
    }

    public long getFd() {
        return this.fd;
    }

    @Override
    public long getQuantity() {
        return this.fd;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        FileDescriptor otherFd = (FileDescriptor)other;
        return this.fd < otherFd.fd ? -1 : (this.fd > otherFd.fd ? 1 : 0);
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        return new FileDescriptor(reader.readInt64());
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.getFd());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FileDescriptor) {
            FileDescriptor other = (FileDescriptor)obj;
            return this.fd == other.fd;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.fd ^ this.fd >>> 32);
    }
}

