/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.memory.event.GcCause;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class GcCauseEntry
implements PersistableProviderEntry {
    public static final PersistableProviderEntry readerInstance = new GcCauseEntry(GcCause.NO_GC);
    private final GcCause cause;

    public GcCauseEntry(GcCause cause) {
        this.cause = cause;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        GcCauseEntry otherCause = (GcCauseEntry)other;
        return this.cause.compareTo((Enum)otherCause.cause);
    }

    public GcCause getCause() {
        return this.cause;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        GcCause readCause = GcCause.get((int)reader.readInt8());
        return new GcCauseEntry(readCause);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(GcCause.get((GcCause)this.cause));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GcCauseEntry) {
            return this.cause.equals((Object)((GcCauseEntry)obj).cause);
        }
        return false;
    }

    public int hashCode() {
        return this.cause.hashCode();
    }
}

