/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class GcTypeEntry
implements PersistableProviderEntry {
    public static final PersistableProviderEntry readerInstance = new GcTypeEntry(0);
    private final byte type;

    public GcTypeEntry(byte type) {
        this.type = type;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        GcTypeEntry otherType = (GcTypeEntry)other;
        return this.type - otherType.type;
    }

    public byte getType() {
        return this.type;
    }

    public String getExportText() {
        switch (this.type) {
            case 1: {
                return "full";
            }
            case 2: {
                return "partial";
            }
            case 3: {
                return "concurrent";
            }
        }
        return "unknown";
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        return new GcTypeEntry(reader.readInt8());
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8((int)this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GcTypeEntry) {
            return this.type == ((GcTypeEntry)obj).type;
        }
        return false;
    }

    public int hashCode() {
        return this.type;
    }
}

