/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.JRubyMethodCategorizer;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import org.apache.poi.ss.formula.eval.NotImplementedException;

public abstract class JRubyOrJavaMethod
implements UniqueEntry {
    private static final String RUBY_SYNTHETIC = "$RUBY$SYNTHETIC";
    private static final String RUBY = "$RUBY$";
    private final MethodLocation location;
    private final String methodName;
    private final String fileName;

    public JRubyOrJavaMethod(MethodObject method) {
        this(method.asMethodLocation());
    }

    public JRubyOrJavaMethod(MethodLocation location) {
        this.location = location;
        MethodObject method = location.getMethod();
        if (method.isBoundJRubyMethod()) {
            this.methodName = method.getBoundJRubyMethods()[0].toString();
            this.fileName = null;
        } else {
            JRubyMethodCategorizer categorizer = method.getSession().getJRubyMethodCategorizer();
            if (categorizer.isCompiledJRuby(method)) {
                this.methodName = this.sanitizeCompiledMethodName(method.getName());
                this.fileName = method.getMethodClass().getFilename();
            } else if (categorizer.isInterpretedJRuby(method)) {
                this.fileName = method.getMethodClass().getFullName();
                this.methodName = method.getName();
            } else {
                this.methodName = null;
                this.fileName = null;
            }
        }
    }

    private String sanitizeCompiledMethodName(String name) {
        String realName = name;
        int index = realName.indexOf(RUBY);
        if (index >= 0 && (realName = (realName = realName.substring(index)).startsWith(RUBY_SYNTHETIC) ? realName.substring(RUBY_SYNTHETIC.length()) : realName.substring(RUBY.length())).equals("_ssfile_ss")) {
            realName = "(root)";
        }
        return realName;
    }

    public boolean isJRubyMethod() {
        return this.methodName != null;
    }

    public MethodObject getMethod() {
        return this.location.getMethod();
    }

    public MethodLocation getLocation() {
        return this.location;
    }

    public String getJRubyMethodName() {
        return this.methodName;
    }

    public String getJRubyFileName() {
        return this.fileName;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        JRubyOrJavaMethod otherMethod = (JRubyOrJavaMethod)other;
        int result = this.location.compareToIgnoreCase(otherMethod.location);
        if (result != 0) {
            return result;
        }
        return this.location.compareByMethodIndexAndLineNr(otherMethod.location);
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        JRubyOrJavaMethod otherMethod = (JRubyOrJavaMethod)other;
        return this.location.compareByMethodIndexAndLineNr(otherMethod.location);
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        throw new NotImplementedException("NI");
    }
}

