/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.Diffable;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.presentation.typed.entries.LoadAverageDiff;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;

public class LoadAverage
implements ProviderEntry,
Diffable {
    private double[] loadData;

    public LoadAverage(long[] loadData) {
        int size = loadData != null ? loadData.length : 0;
        this.loadData = new double[size];
        for (int i = 0; i < size; ++i) {
            this.loadData[i] = (double)loadData[i] / 1000.0;
        }
    }

    public LoadAverage(double[] loadData) {
        int size = loadData != null ? loadData.length : 0;
        this.loadData = new double[size];
        for (int i = 0; i < size; ++i) {
            this.loadData[i] = loadData[i];
        }
    }

    public double[] getLoadData() {
        return this.loadData;
    }

    @Override
    public int compareTo(ProviderEntry otherEntry, EntryContext context) {
        LoadAverage other = (LoadAverage)otherEntry;
        if (other.loadData.length != this.loadData.length) {
            if (this.loadData.length < other.loadData.length) {
                return -1;
            }
            return 1;
        }
        for (int i = 0; i < this.loadData.length; ++i) {
            if (this.loadData[i] < other.loadData[i]) {
                return -1;
            }
            if (!(this.loadData[i] > other.loadData[i])) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Difference getDifference(ProviderEntry newEntry, ProviderEntry oldEntry) {
        return new LoadAverageDiff(oldEntry != null ? ((LoadAverage)oldEntry).loadData : new double[]{}, newEntry != null ? ((LoadAverage)newEntry).loadData : new double[]{});
    }

    @Override
    public ProviderEntry getAccumulation(ProviderEntry[] entries) {
        if (entries.length == 1) {
            return entries[0];
        }
        if (entries.length == 0) {
            return null;
        }
        LoadAverage[] loadEntries = (LoadAverage[])entries;
        int size = loadEntries[0].loadData.length;
        double[] loadAvg = new double[size];
        for (int i = 0; i < loadEntries.length; ++i) {
            for (int j = 0; j < size; ++j) {
                int n = j;
                loadAvg[n] = loadAvg[n] + loadEntries[i].loadData[j];
            }
        }
        int j = 0;
        while (j < size) {
            int n = j++;
            loadAvg[n] = loadAvg[n] / (double)loadEntries.length;
        }
        return new LoadAverage(loadAvg);
    }
}

